/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.portal_generation;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.AbstractDiligentForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.peripheral.PeripheralModMain;

public class PortalHelperForm
extends AbstractDiligentForm {
    public PortalHelperForm() {
        super(true);
    }

    @Override
    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithoutCorner) {
            toWorld.setBlockAndUpdate(blockPos, PeripheralModMain.portalHelperBlock.defaultBlockState());
        }
        McHelper.findEntitiesByBox(ServerPlayer.class, (Level)fromWorld, new AABB(fromShape.anchor).inflate(10.0), 2.0, e -> true).forEach(player -> player.displayClientMessage((Component)Component.translatable((String)"imm_ptl.portal_helper_not_linked"), false));
    }

    @Override
    public Portal[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        Portal[] portals;
        ServerLevel world = McHelper.getServerWorld(info.from);
        for (BlockPos blockPos : info.fromShape.area) {
            world.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
        }
        world.setBlockAndUpdate(info.fromShape.firstFramePos, Blocks.AIR.defaultBlockState());
        world.setBlockAndUpdate(info.toShape.firstFramePos, Blocks.AIR.defaultBlockState());
        Portal portal = info.createTemplatePortal(Portal.ENTITY_TYPE);
        PortalExtension.get((Portal)portal).bindCluster = true;
        Portal flipped = PortalManipulation.createFlippedPortal(portal, Portal.ENTITY_TYPE);
        Portal reverse = PortalManipulation.createReversePortal(portal, Portal.ENTITY_TYPE);
        Portal parallel = PortalManipulation.createReversePortal(flipped, Portal.ENTITY_TYPE);
        for (Portal p : portals = new Portal[]{portal, flipped, reverse, parallel}) {
            McHelper.spawnServerEntity(p);
        }
        return portals;
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return blockState -> blockState.getBlock() == PeripheralModMain.portalHelperBlock;
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return blockState -> blockState.getBlock() == PeripheralModMain.portalHelperBlock;
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return blockState -> blockState.isAir();
    }

    @Override
    public MapCodec<? extends PortalGenForm> getCodec() {
        throw new RuntimeException();
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }
}

