/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.mixin.client.dim_stack;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.dim_stack.DimensionStackAPI;
import qouteall.imm_ptl.peripheral.ducks.IECreateWorldScreen;
import qouteall.q_misc_util.Helper;

@Mixin(value={CreateWorldScreen.class})
public abstract class MixinCreateWorldScreen_CVB
extends Screen
implements IECreateWorldScreen {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private WorldCreationUiState uiState;
    @Nullable
    private DimStackGuiController ip_dimStackController;

    protected MixinCreateWorldScreen_CVB(Component title) {
        super(title);
        throw new RuntimeException();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInitEnd(Minecraft minecraft, Screen screen, WorldCreationContext worldCreationContext, Optional<ResourceKey<WorldPreset>> optional, OptionalLong optionalLong, CallbackInfo ci) {
        DimStackManagement.dimStackToApply = DimStackManagement.getDimStackPreset();
        if (DimStackManagement.dimStackToApply != null) {
            LOGGER.info("[ImmPtl] Applying dimension stack preset");
        }
    }

    @Override
    public void ip_openDimStackScreen() {
        if (this.ip_dimStackController == null) {
            CreateWorldScreen this_ = (CreateWorldScreen)this;
            this.ip_dimStackController = new DimStackGuiController((Screen)this_, () -> this.portal_getDimensionList(), info -> {
                DimStackManagement.dimStackToApply = info;
                Minecraft.getInstance().setScreen((Screen)this_);
            });
            this.ip_dimStackController.initializeAsDefault();
        }
        Minecraft.getInstance().setScreen((Screen)this.ip_dimStackController.view);
    }

    private List<ResourceKey<Level>> portal_getDimensionList() {
        LinkedHashSet<ResourceKey<Level>> result;
        block4: {
            Helper.log("Getting the dimension list");
            result = new LinkedHashSet<ResourceKey<Level>>();
            try {
                WorldCreationContext settings = this.uiState.getSettings();
                RegistryAccess.Frozen registryAccess = settings.worldgenLoadContext();
                WorldDimensions selectedDimensions = settings.selectedDimensions();
                for (Map.Entry entry : selectedDimensions.dimensions().entrySet()) {
                    result.add(Helper.dimIdToKey(((ResourceKey)entry.getKey()).location()));
                }
                for (Map.Entry entry : settings.datapackDimensions().entrySet()) {
                    result.add(Helper.dimIdToKey(((ResourceKey)entry.getKey()).location()));
                }
                Set<ResourceKey<Level>> other = ((DimensionStackAPI.DimensionStackCandidateCollectionEvent)NeoForge.EVENT_BUS.post((Event)new DimensionStackAPI.DimensionStackCandidateCollectionEvent(registryAccess, settings.options()))).getDimensionsResult();
                result.addAll(other);
            }
            catch (Exception e) {
                LOGGER.error("ImmPtl getting dimension list", (Throwable)e);
                if (!result.isEmpty()) break block4;
                result.add(Helper.dimIdToKey("error:error"));
            }
        }
        return new ArrayList<ResourceKey<Level>>(result);
    }
}

