/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.DimensionEvents;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimensionStackAPI;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.api.McRemoteProcedureCallClient;

public class DimStackManagement {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static DimStackInfo dimStackToApply = null;
    public static Map<ResourceKey<Level>, BlockState> bedrockReplacementMap = new HashMap<ResourceKey<Level>, BlockState>();

    public static void init() {
        if (!DimStackManagement.isDimStackEnabled()) {
            return;
        }
        NeoForge.EVENT_BUS.addListener(DimensionEvents.ServerDimensionsLoadEvent.class, event -> {
            if (dimStackToApply != null) {
                NeoForge.EVENT_BUS.post((Event)new DimensionStackAPI.DimensionStackPreUpdateEvent(event.server, dimStackToApply));
            }
        });
    }

    private static boolean isDimStackEnabled() {
        return true;
    }

    public static void onServerEarlyInit(MinecraftServer server) {
        if (!DimStackManagement.isDimStackEnabled()) {
            return;
        }
        DimStackManagement.updateDimStackFromPresetInDedicatedServer(server);
        HashMap<ResourceKey<Level>, BlockState> bedrockReplacementMap = new HashMap<ResourceKey<Level>, BlockState>();
        if (dimStackToApply != null) {
            for (DimStackEntry entry : DimStackManagement.dimStackToApply.entries) {
                bedrockReplacementMap.put(entry.getDimension(), DimStackInfo.parseBlockString(entry.bedrockReplacementStr));
            }
        }
        DimStackManagement.bedrockReplacementMap = bedrockReplacementMap;
    }

    public static void onServerCreatedWorlds(MinecraftServer server) {
        if (!DimStackManagement.isDimStackEnabled()) {
            return;
        }
        if (dimStackToApply != null) {
            dimStackToApply.apply(server);
            dimStackToApply = null;
        } else {
            DimStackManagement.updateBedrockReplacementFromStorage(server);
        }
    }

    private static void updateDimStackFromPresetInDedicatedServer(MinecraftServer server) {
        if (O_O.isDedicatedServer()) {
            DimStackInfo dimStackPreset = DimStackManagement.getDimStackPreset();
            if (dimStackPreset != null) {
                if (!DimStackManagement.hasDimStackPortal(server)) {
                    LOGGER.info("Applying dimension stack preset in dedicated server");
                    dimStackToApply = dimStackPreset;
                } else {
                    LOGGER.info("There are already dim stack portals, so the preset is not applied");
                }
            } else {
                LOGGER.info("The server has no dimension stack preset.");
            }
        }
    }

    private static void updateBedrockReplacementFromStorage(MinecraftServer server) {
        HashMap<ResourceKey<Level>, BlockState> newMap = new HashMap<ResourceKey<Level>, BlockState>();
        for (ServerLevel world : server.getAllLevels()) {
            BlockState replacement = GlobalPortalStorage.get((ServerLevel)world).bedrockReplacement;
            newMap.put((ResourceKey<Level>)world.dimension(), replacement);
            LOGGER.info("Bedrock Replacement {} {}", (Object)world.dimension().location(), replacement != null ? BuiltInRegistries.BLOCK.getKey((Object)replacement.getBlock()) : "null");
        }
        bedrockReplacementMap = newMap;
    }

    public static void replaceBedrock(ServerLevel world, ChunkAccess chunk) {
        if (!DimStackManagement.isDimStackEnabled()) {
            return;
        }
        if (bedrockReplacementMap == null) {
            LOGGER.error("Dimension Stack Bedrock Replacement Abnormal");
            return;
        }
        BlockState replacement = bedrockReplacementMap.get(world.dimension());
        if (replacement != null) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.getMinBuildHeight(); y < chunk.getMaxBuildHeight(); ++y) {
                        mutable.set(x, y, z);
                        BlockState blockState = chunk.getBlockState((BlockPos)mutable);
                        if (blockState.getBlock() != Blocks.BEDROCK) continue;
                        chunk.setBlockState((BlockPos)mutable, replacement, false);
                    }
                }
            }
        }
    }

    private static Collection<ResourceKey<Level>> collectDimStackCandidateWhenServerRunning(MinecraftServer server) {
        LinkedHashSet<ResourceKey<Level>> result = new LinkedHashSet<ResourceKey<Level>>(server.levelKeys());
        Set<ResourceKey<Level>> extra = ((DimensionStackAPI.DimensionStackCandidateCollectionEvent)NeoForge.EVENT_BUS.post((Event)new DimensionStackAPI.DimensionStackCandidateCollectionEvent(server.registryAccess(), server.getWorldData().worldGenOptions()))).getDimensionsResult();
        result.addAll(extra);
        return result;
    }

    public static void onDimensionStackCommandExecute(ServerPlayer player) {
        List<String> dimIdList = DimStackManagement.collectDimStackCandidateWhenServerRunning(player.server).stream().map(k -> k.location().toString()).toList();
        McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.clientOpenScreen", dimIdList);
    }

    private static void updateDimStack(MinecraftServer server, DimStackInfo dimStackInfo) {
        NeoForge.EVENT_BUS.post((Event)new DimensionStackAPI.DimensionStackPreUpdateEvent(server, dimStackInfo));
        DimStackManagement.clearDimStackPortals(server);
        dimStackInfo.apply(server);
        if (O_O.isDedicatedServer()) {
            DimStackManagement.setDimStackPreset(dimStackInfo);
        }
    }

    public static boolean hasDimStackPortal(MinecraftServer server) {
        for (ServerLevel world : server.getAllLevels()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world);
            if (Helper.indexOf(gps.data, p -> p instanceof VerticalConnectingPortal) == -1) continue;
            return true;
        }
        return false;
    }

    private static void clearDimStackPortals(MinecraftServer server) {
        for (ServerLevel world : server.getAllLevels()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world);
            gps.data.removeIf(p -> p instanceof VerticalConnectingPortal);
            gps.bedrockReplacement = null;
            gps.onDataChanged();
        }
        DimStackManagement.updateBedrockReplacementFromStorage(server);
    }

    @Nullable
    public static DimStackInfo getDimStackPreset() {
        JsonObject json = IPConfig.getConfig().dimStackPreset;
        if (json == null) {
            return null;
        }
        try {
            DimStackInfo dimStackInfo = (DimStackInfo)IPGlobal.gson.fromJson((JsonElement)json, DimStackInfo.class);
            return dimStackInfo;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse dimension stack preset JSON {}", (Object)json, (Object)e);
            return null;
        }
    }

    public static void setDimStackPreset(@Nullable DimStackInfo preset) {
        JsonObject json = null;
        if (preset != null) {
            json = IPGlobal.gson.toJsonTree((Object)preset).getAsJsonObject();
        }
        IPConfig config = IPConfig.getConfig();
        config.dimStackPreset = json;
        config.saveConfigFile();
    }

    public static class RemoteCallables {
        public static void clientOpenScreen(List<String> dimensions) {
            List dimensionList = dimensions.stream().map(Helper::dimIdToKey).collect(Collectors.toList());
            DimStackGuiController controller = new DimStackGuiController(null, () -> dimensionList, dimStackInfo -> {
                if (dimStackInfo != null) {
                    McRemoteProcedureCallClient.tellServerToInvoke("qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.serverSetupDimStack", dimStackInfo);
                } else {
                    McRemoteProcedureCallClient.tellServerToInvoke("qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.serverRemoveDimStack", new Object[0]);
                }
                Minecraft.getInstance().setScreen(null);
            });
            controller.initializeAsDefault();
            Minecraft.getInstance().setScreen((Screen)controller.view);
        }

        public static void serverSetupDimStack(ServerPlayer player, DimStackInfo dimStackInfo) {
            if (!player.hasPermissions(2)) {
                player.sendSystemMessage((Component)Component.literal((String)"You don't have permission to change dimension stack"));
                return;
            }
            if (!DimStackManagement.isDimStackEnabled()) {
                player.sendSystemMessage((Component)Component.literal((String)"Dimension stack feature is not enabled"));
                return;
            }
            MinecraftServer server = player.getServer();
            DimStackManagement.updateDimStack(server, dimStackInfo);
            player.displayClientMessage((Component)Component.translatable((String)"imm_ptl.dim_stack_established"), false);
        }

        public static void serverRemoveDimStack(ServerPlayer player) {
            if (!player.hasPermissions(2)) {
                Helper.err("one player without permission tries to change dimension stack");
                return;
            }
            MinecraftServer server = player.getServer();
            DimStackManagement.clearDimStackPortals(server);
            player.displayClientMessage((Component)Component.translatable((String)"imm_ptl.dim_stack_removed"), false);
            if (O_O.isDedicatedServer()) {
                DimStackManagement.setDimStackPreset(null);
            }
        }
    }
}

