/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.peripheral.dim_stack.DimEntryWidget;
import qouteall.q_misc_util.Helper;

public class DimListWidget
extends AbstractSelectionList<DimEntryWidget> {
    public static final int ROW_WIDTH = 300;
    public final Screen parent;
    private final Type type;
    @Nullable
    private final DraggingCallback draggingCallback;

    public DimListWidget(int width, int height, int top, int itemHeight, Screen parent, Type type, @Nullable DraggingCallback draggingCallback) {
        super(Minecraft.getInstance(), width, height, top, itemHeight);
        this.parent = parent;
        this.type = type;
        this.draggingCallback = draggingCallback;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        DimEntryWidget mouseOn;
        DimEntryWidget selected;
        if (this.type == Type.mainDimensionList && this.draggingCallback != null && (selected = (DimEntryWidget)this.getSelected()) != null && (mouseOn = (DimEntryWidget)this.getEntryAtPosition(mouseX, mouseY)) != null && mouseOn != selected) {
            int selectedIndex = this.children().indexOf((Object)selected);
            int mouseOnIndex = this.children().indexOf((Object)mouseOn);
            if (selectedIndex != -1 && mouseOnIndex != -1) {
                this.draggingCallback.run(selectedIndex, mouseOnIndex);
            } else {
                Helper.err("Invalid dragging");
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public int getRowWidth() {
        return 300;
    }

    protected int getScrollbarPosition() {
        return (this.width - 300) / 2 + 300;
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    public static enum Type {
        mainDimensionList,
        addDimensionList;

    }

    public static interface DraggingCallback {
        public void run(int var1, int var2);
    }
}

