/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.peripheral.dim_stack.DimListWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.q_misc_util.my_util.DQuaternion;

public class DimEntryWidget
extends ContainerObjectSelectionList.Entry<DimEntryWidget> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ResourceKey<Level> dimension;
    public final DimListWidget parent;
    private final Consumer<DimEntryWidget> selectCallback;
    @Nullable
    private final ResourceLocation dimIconPath;
    private final Component dimensionName;
    @Nullable
    public final DimStackEntry entry;
    public int entryIndex;
    ArrowType arrowToPrevious = ArrowType.none;
    ArrowType arrowToNext = ArrowType.none;
    public static final int widgetHeight = 50;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return List.of();
    }

    public DimEntryWidget(ResourceKey<Level> dimension, DimListWidget parent, Consumer<DimEntryWidget> selectCallback, @Nullable DimStackEntry entry) {
        this.dimension = dimension;
        this.parent = parent;
        this.selectCallback = selectCallback;
        this.dimIconPath = CHelper.getDimensionIconPath(this.dimension);
        this.dimensionName = McHelper.getDimensionName(dimension);
        this.entry = entry;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean bl, float delta) {
        Minecraft client = Minecraft.getInstance();
        guiGraphics.drawString(client.font, this.dimensionName.getString(), x + 50 + 3, y, -1);
        guiGraphics.drawString(client.font, this.dimension.location().toString(), x + 50 + 3, y + 10, -6710887);
        if (this.dimIconPath != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)x, (float)y, 0.0f);
            int iconLen = 46;
            if (this.entry != null && this.entry.flipped) {
                guiGraphics.pose().rotateAround(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 180.0).toMcQuaternion(), (float)iconLen / 2.0f, (float)iconLen / 2.0f, 0.0f);
            }
            guiGraphics.blit(this.dimIconPath, 0, 0, 0.0f, 0.0f, iconLen, iconLen, iconLen, iconLen);
            guiGraphics.pose().popPose();
        }
        if (this.entry != null) {
            guiGraphics.drawString(client.font, this.getText1(), x + 50 + 3, y + 20, -6710887);
            guiGraphics.drawString(client.font, this.getText2(), x + 50 + 3, y + 30, -6710887);
            if (this.arrowToPrevious != ArrowType.none) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(x + rowWidth - 13), (float)y, 0.0f);
                guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
                guiGraphics.drawString(client.font, (Component)Component.literal((String)"\u2191"), 0, 0, this.arrowToPrevious == ArrowType.enabled ? -6710887 : -65536);
                guiGraphics.pose().popPose();
            }
            if (this.arrowToNext != ArrowType.none) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(x + rowWidth - 13), (float)(y + 50) - 14.5f, 0.0f);
                guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
                guiGraphics.drawString(client.font, (Component)Component.literal((String)"\u2193"), 0, 0, this.arrowToNext == ArrowType.enabled ? -6710887 : -65536);
                guiGraphics.pose().popPose();
            }
        }
    }

    private Component getText1() {
        MutableComponent scaleText = this.entry.scale != 1.0 ? Component.translatable((String)"imm_ptl.scale").append((Component)Component.literal((String)(":" + this.entry.scale))) : Component.literal((String)"");
        return scaleText;
    }

    private Component getText2() {
        MutableComponent horizontalRotationText = this.entry.horizontalRotation != 0.0 ? Component.translatable((String)"imm_ptl.horizontal_rotation").append((Component)Component.literal((String)(":" + this.entry.horizontalRotation))).append((Component)Component.literal((String)" ")) : Component.literal((String)"");
        return horizontalRotationText;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.selectCallback.accept(this);
        super.mouseClicked(mouseX, mouseY, button);
        return true;
    }

    public static enum ArrowType {
        none,
        enabled,
        conflicting;

    }
}

