/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.ChunkGenerator;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.peripheral.CommandStickItem;
import qouteall.imm_ptl.peripheral.IPOuterClientMisc;
import qouteall.imm_ptl.peripheral.PortalHelperItem;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.FormulaGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.NormalSkylandGenerator;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.portal_generation.IntrinsicPortalGeneration;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalDrag;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;
import qouteall.imm_ptl.peripheral.wand.PortalWandItem;

public class PeripheralModMain {
    public static Block portalHelperBlock;
    public static final CreativeModeTab TAB;

    public static void initClient() {
        IPOuterClientMisc.initClient();
        PortalWandItem.initClient();
        ClientPortalWandPortalDrag.init();
    }

    public static void init() {
        FormulaGenerator.init();
        IntrinsicPortalGeneration.init();
        DimStackManagement.init();
        PortalWandItem.init();
        CommandStickItem.init();
        PortalWandInteraction.init();
        CommandStickItem.registerCommandStickTypes();
    }

    public static void registerItems(BiConsumer<ResourceLocation, Item> regFunc) {
        regFunc.accept(McHelper.newResourceLocation("immersive_portals", "portal_helper"), (Item)new PortalHelperItem(portalHelperBlock, new Item.Properties()));
        CommandStickItem commandStickItem = new CommandStickItem(new Item.Properties());
        regFunc.accept(McHelper.newResourceLocation("immersive_portals:command_stick"), commandStickItem);
        CommandStickItem.instance = commandStickItem;
        PortalWandItem portalWandItem = new PortalWandItem(new Item.Properties());
        regFunc.accept(McHelper.newResourceLocation("immersive_portals:portal_wand"), portalWandItem);
        PortalWandItem.instance = portalWandItem;
    }

    public static void registerBlocks(BiConsumer<ResourceLocation, Block> regFunc) {
        Block block = new Block(BlockBehaviour.Properties.of().noOcclusion().isRedstoneConductor((a, b, c) -> false));
        regFunc.accept(McHelper.newResourceLocation("immersive_portals", "portal_helper"), block);
        portalHelperBlock = block;
    }

    public static void registerChunkGenerators(BiConsumer<ResourceLocation, MapCodec<? extends ChunkGenerator>> regFunc) {
        regFunc.accept(McHelper.newResourceLocation("immersive_portals:error_terrain_generator"), ErrorTerrainGenerator.MAP_CODEC);
        regFunc.accept(McHelper.newResourceLocation("immersive_portals:normal_skyland_generator"), NormalSkylandGenerator.MAP_CODEC);
    }

    public static void registerBiomeSources(BiConsumer<ResourceLocation, MapCodec<? extends BiomeSource>> regFunc) {
        regFunc.accept(McHelper.newResourceLocation("immersive_portals:chaos_biome_source"), ChaosBiomeSource.MAP_CODEC);
    }

    public static void registerCreativeTabs(BiConsumer<ResourceLocation, CreativeModeTab> regFunc) {
        regFunc.accept(McHelper.newResourceLocation("immersive_portals", "general"), TAB);
    }

    static {
        TAB = CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)PortalWandItem.instance)).title((Component)Component.translatable((String)"imm_ptl.item_group")).displayItems((enabledFeatures, entries) -> {
            PortalWandItem.addIntoCreativeTag(entries);
            CommandStickItem.addIntoCreativeTag(entries);
            entries.accept((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"immersive_portals", (String)"portal_helper")));
        }).build();
    }
}

