/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.ClientPortalSpawnEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;

public class IPOuterClientMisc {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static OuterConfig outerConfig = new OuterConfig();

    private static OuterConfig readFromFile() {
        File storageFile = IPOuterClientMisc.getStorageFile();
        if (storageFile.exists()) {
            OuterConfig result = null;
            try (FileReader fileReader = new FileReader(storageFile);){
                result = (OuterConfig)IPGlobal.gson.fromJson((Reader)fileReader, OuterConfig.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new OuterConfig();
            }
            if (result == null) {
                return new OuterConfig();
            }
            return result;
        }
        return new OuterConfig();
    }

    private static File getStorageFile() {
        return new File(Minecraft.getInstance().gameDirectory, "imm_ptl_state.json");
    }

    private static void writeToFile(OuterConfig outerConfig) {
        try (FileWriter fileWriter = new FileWriter(IPOuterClientMisc.getStorageFile());){
            IPGlobal.gson.toJson((Object)outerConfig, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initClient() {
        outerConfig = IPOuterClientMisc.readFromFile();
        DimStackInfo dimStackPreset = IPOuterClientMisc.outerConfig.dimensionStackDefault;
        if (dimStackPreset != null) {
            try {
                IPConfig config = IPConfig.getConfig();
                config.dimStackPreset = (JsonObject)IPGlobal.gson.toJsonTree((Object)dimStackPreset);
                config.saveConfigFile();
                IPOuterClientMisc.outerConfig.dimensionStackDefault = null;
                IPOuterClientMisc.writeToFile(outerConfig);
                LOGGER.info("Successfully upgraded dimension stack preset");
            }
            catch (Exception e) {
                LOGGER.info("Failed to upgrade dimension stack preset", (Throwable)e);
            }
        }
        NeoForge.EVENT_BUS.addListener(ClientPortalSpawnEvent.class, event -> {
            Portal p = event.portal;
            LocalPlayer player = Minecraft.getInstance().player;
            if (!IPOuterClientMisc.outerConfig.wikiInformed && player != null && player.isCreative()) {
                IPOuterClientMisc.outerConfig.wikiInformed = true;
                IPOuterClientMisc.writeToFile(outerConfig);
                IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization", Component.translatable((String)"imm_ptl.inform_wiki"));
            }
        });
    }

    private static void informWithURL(String link, MutableComponent text) {
        CHelper.printChat((Component)text.append((Component)McHelper.getLinkText(link)));
    }

    public static class OuterConfig {
        public boolean wikiInformed = false;
        public boolean portalHelperInformed = false;
        public boolean lagInformed = false;
        @Nullable
        public DimStackInfo dimensionStackDefault = null;
    }
}

