/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.peripheral.platform_specific.PeripheralModEntry;

public class CommandStickItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<Data> DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(Data::command), (App)Codec.STRING.fieldOf("nameTranslationKey").forGetter(Data::nameTranslationKey), (App)Codec.STRING.listOf().fieldOf("descriptionTranslationKeys").forGetter(Data::descriptionTranslationKeys)).apply((Applicative)instance, Data::new));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Data>> COMPONENT_TYPE = PeripheralModEntry.DATA_COMPONENTS_REGISTRAR.registerComponentType("command_stick_data", b -> b.persistent(DATA_CODEC));
    public static final LinkedHashMap<String, Data> BUILT_IN_COMMAND_STICK_TYPES = new LinkedHashMap();
    public static CommandStickItem instance;

    public static void registerBuiltInCommandStick(Data data) {
        BUILT_IN_COMMAND_STICK_TYPES.put(data.command, data);
    }

    public CommandStickItem(Item.Properties settings) {
        super(settings);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        this.doUse(player, player.getItemInHand(hand));
        return super.use(world, player, hand);
    }

    private void doUse(Player player, ItemStack stack) {
        if (player.level().isClientSide()) {
            return;
        }
        if (CommandStickItem.canUseCommand(player)) {
            Data data = (Data)stack.get(COMPONENT_TYPE);
            if (data == null) {
                LOGGER.error("Missing component in command stick item {}", (Object)stack);
                return;
            }
            CommandSourceStack commandSource = player.createCommandSourceStack().withPermission(2);
            MinecraftServer server = player.getServer();
            assert (server != null);
            Commands commandManager = server.getCommands();
            String command = data.command;
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
            commandManager.performPrefixedCommand(commandSource, command);
        } else {
            CommandStickItem.sendMessage(player, (Component)Component.literal((String)"No Permission"));
        }
    }

    private static boolean canUseCommand(Player player) {
        if (IPGlobal.easeCommandStickPermission) {
            return true;
        }
        return player.hasPermissions(2) || player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltip, tooltipFlag);
        Data data = (Data)stack.get(COMPONENT_TYPE);
        if (data == null) {
            return;
        }
        Iterable splitCommand = Splitter.fixedLength((int)40).split((CharSequence)data.command);
        for (String commandPortion : splitCommand) {
            tooltip.add((Component)Component.literal((String)commandPortion).withStyle(ChatFormatting.GOLD));
        }
        for (String descriptionTranslationKey : data.descriptionTranslationKeys) {
            tooltip.add((Component)Component.translatable((String)descriptionTranslationKey).withStyle(ChatFormatting.AQUA));
        }
        tooltip.add((Component)Component.translatable((String)"imm_ptl.command_stick").withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        Data data = (Data)stack.get(COMPONENT_TYPE);
        if (data == null) {
            return "";
        }
        return data.nameTranslationKey;
    }

    public static void sendMessage(Player player, Component message) {
        ((ServerPlayer)player).sendSystemMessage(message);
    }

    public static void init() {
        PortalCommand.createCommandStickCommandSignal.connect((player, command) -> {
            ItemStack itemStack = new ItemStack((ItemLike)instance, 1);
            Data data = new Data((String)command, (String)command, (List<String>)new ArrayList<String>());
            itemStack.set(COMPONENT_TYPE, (Object)data);
            player.getInventory().add(itemStack);
            player.inventoryMenu.broadcastChanges();
        });
    }

    public static void addIntoCreativeTag(CreativeModeTab.Output entries) {
        for (Data data : BUILT_IN_COMMAND_STICK_TYPES.values()) {
            ItemStack stack = new ItemStack((ItemLike)instance);
            stack.set(COMPONENT_TYPE, (Object)data);
            entries.accept(stack);
        }
    }

    public static void registerCommandStickTypes() {
        CommandStickItem.registerPortalSubCommandStick("delete_portal");
        CommandStickItem.registerPortalSubCommandStick("remove_connected_portals");
        CommandStickItem.registerPortalSubCommandStick("eradicate_portal_cluster");
        CommandStickItem.registerPortalSubCommandStick("complete_bi_way_bi_faced_portal");
        CommandStickItem.registerPortalSubCommandStick("complete_bi_way_portal");
        CommandStickItem.registerPortalSubCommandStick("move_portal_front", "move_portal 0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_back", "move_portal -0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_back_a_little", "move_portal -0.001");
        CommandStickItem.registerPortalSubCommandStick("move_portal_destination_front", "move_portal_destination 0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_destination_back", "move_portal_destination -0.5");
        CommandStickItem.registerPortalSubCommandStick("rotate_x", "rotate_portal_rotation_along x 15");
        CommandStickItem.registerPortalSubCommandStick("rotate_y", "rotate_portal_rotation_along y 15");
        CommandStickItem.registerPortalSubCommandStick("rotate_z", "rotate_portal_rotation_along z 15");
        CommandStickItem.registerPortalSubCommandStick("make_unbreakable", "nbt {unbreakable:true}");
        CommandStickItem.registerPortalSubCommandStick("make_fuse_view", "nbt {fuseView:true}");
        CommandStickItem.registerPortalSubCommandStick("enable_pos_adjust", "nbt {adjustPositionAfterTeleport:true}");
        CommandStickItem.registerPortalSubCommandStick("disable_rendering_yourself", "nbt {doRenderPlayer:false}");
        CommandStickItem.registerPortalSubCommandStick("enable_isometric", "debug isometric_enable 50");
        CommandStickItem.registerPortalSubCommandStick("disable_isometric", "debug isometric_disable");
        CommandStickItem.registerPortalSubCommandStick("create_5_connected_rooms", "create_connected_rooms roomSize 6 4 6 roomNumber 5");
        CommandStickItem.registerPortalSubCommandStick("accelerate50", "debug accelerate 50");
        CommandStickItem.registerPortalSubCommandStick("accelerate200", "debug accelerate 200");
        CommandStickItem.registerPortalSubCommandStick("reverse_accelerate50", "debug accelerate -50");
        CommandStickItem.registerPortalSubCommandStick("enable_gravity_change", "nbt {teleportChangesGravity:true}");
        CommandStickItem.registerPortalSubCommandStick("make_invisible", "nbt {isVisible:false}");
        CommandStickItem.registerPortalSubCommandStick("make_visible", "nbt {isVisible:true}");
        CommandStickItem.registerPortalSubCommandStick("disable_default_animation", "nbt {defaultAnimation:{durationTicks:0}}");
        CommandStickItem.registerPortalSubCommandStick("pause_animation", "animation pause");
        CommandStickItem.registerPortalSubCommandStick("resume_animation", "animation resume");
        CommandStickItem.registerPortalSubCommandStick("rotate_around_y", "animation rotate_infinitely @s 0 1 0 1.0");
        CommandStickItem.registerPortalSubCommandStick("rotate_randomly", "animation rotate_infinitely_random");
        CommandStickItem.registerBuiltInCommandStick(new Data("execute positioned 0.0 0.0 0.0 run portal animation rotate_infinitely @p ^0.0 ^0.0 ^1.0 1.7", "imm_ptl.command.rotate_around_view", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.rotate_around_view"})));
        CommandStickItem.registerPortalSubCommandStick("expand_from_center", "animation expand_from_center 20");
        CommandStickItem.registerPortalSubCommandStick("clear_animation", "animation clear");
        CommandStickItem.registerPortalSubCommandStick("sculpt", "shape sculpt");
        CommandStickItem.registerPortalSubCommandStick("reset_shape", "shape reset");
        CommandStickItem.registerBuiltInCommandStick(new Data("/attribute @s minecraft:generic.scale modifier remove iportal:scaling", "imm_ptl.command.reset_iportal_scale", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.reset_iportal_scale"})));
        CommandStickItem.registerBuiltInCommandStick(new Data("/attribute @s minecraft:player.block_interaction_range base set 100", "imm_ptl.command.long_reach", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.long_reach"})));
        CommandStickItem.registerBuiltInCommandStick(new Data("/effect give @s minecraft:night_vision 9999 1 true", "imm_ptl.command.night_vision", List.of()));
        CommandStickItem.registerBuiltInCommandStick(new Data("/setblock ~ ~ ~ minecraft:grass_block", "imm_ptl.command.block_on_feet", List.of()));
        CommandStickItem.registerPortalSubCommandStick("goback");
        CommandStickItem.registerPortalSubCommandStick("show_wiki", "wiki");
    }

    private static Data registerPortalSubCommandStick(String name) {
        return CommandStickItem.registerPortalSubCommandStick(name, name);
    }

    private static Data registerPortalSubCommandStick(String name, String subCommand) {
        Data data = new Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name}));
        CommandStickItem.registerBuiltInCommandStick(data);
        return data;
    }

    public record Data(String command, String nameTranslationKey, List<String> descriptionTranslationKeys) {
        public void serialize(CompoundTag tag) {
            tag.putString("command", this.command);
            tag.putString("nameTranslationKey", this.nameTranslationKey);
            ListTag listTag = new ListTag();
            for (String descriptionTK : this.descriptionTranslationKeys) {
                listTag.add((Object)StringTag.valueOf((String)descriptionTK));
            }
            tag.put("descriptionTranslationKeys", (Tag)listTag);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            this.serialize(tag);
            return tag;
        }

        public static Data deserialize(CompoundTag tag) {
            return new Data(tag.getString("command"), tag.getString("nameTranslationKey"), tag.getList("descriptionTranslationKeys", (int)StringTag.valueOf((String)"").getId()).stream().map(tag1 -> ((StringTag)tag1).getAsString()).collect(Collectors.toList()));
        }
    }
}

