/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.DimensionEvents;
import de.nick1st.imm_ptl.events.ServerPortalTickEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ScaleUtils;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEServerPlayerEntity;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.WithDim;

public class ServerTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Set<Entity> teleportingEntities = new HashSet<Entity>();
    private final WeakHashMap<Entity, Long> lastTeleportGameTime = new WeakHashMap();
    public boolean isFiringMyChangeDimensionEvent = false;
    public final WeakHashMap<ServerPlayer, WithDim<Vec3>> lastPosition = new WeakHashMap();

    public static ServerTeleportationManager of(MinecraftServer server) {
        return IPPerServerInfo.of((MinecraftServer)server).teleportationManager;
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> ServerTeleportationManager.of(event.getServer()).tick(event.getServer()));
        NeoForge.EVENT_BUS.addListener(ServerPortalTickEvent.class, event -> {
            Portal portal = event.portal;
            ServerTeleportationManager serverTeleportationManager = ServerTeleportationManager.of(portal.getServer());
            ServerTeleportationManager.getEntitiesToTeleport(portal).forEach(entity -> serverTeleportationManager.startTeleportingRegularEntity(portal, (Entity)entity));
        });
        NeoForge.EVENT_BUS.addListener(DimensionEvents.BeforeRemovingDimensionEvent.class, beforeRemovingDimensionEvent -> ServerTeleportationManager.of(beforeRemovingDimensionEvent.getServer()).evacuatePlayersFromDimension(beforeRemovingDimensionEvent.dimension));
    }

    private void tick(MinecraftServer server) {
        this.teleportingEntities.clear();
        this.manageGlobalPortalTeleportation();
    }

    public static boolean shouldEntityTeleport(Portal portal, Entity entity) {
        if (entity.level() != portal.level()) {
            return false;
        }
        if (!portal.canTeleportEntity(entity)) {
            return false;
        }
        Vec3 lastEyePos = entity.getEyePosition(0.0f);
        Vec3 nextEyePos = entity.getEyePosition(1.0f);
        if (entity instanceof Projectile) {
            nextEyePos = nextEyePos.add(McHelper.getWorldVelocity(entity));
        }
        boolean movedThroughPortal = portal.isMovedThroughPortal(lastEyePos, nextEyePos);
        return movedThroughPortal;
    }

    public void startTeleportingRegularEntity(Portal portal, Entity entity) {
        if (entity instanceof ServerPlayer) {
            return;
        }
        if (entity instanceof Portal) {
            return;
        }
        if (entity.getVehicle() != null || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        if (entity.isRemoved()) {
            return;
        }
        if (!entity.canChangeDimensions(entity.level(), portal.getDestinationWorld())) {
            return;
        }
        if (this.isJustTeleported(entity, 1L)) {
            return;
        }
        if (entity.xo == 0.0 && entity.yo == 0.0 && entity.zo == 0.0) {
            LOGGER.warn("Trying to teleport a fresh new entity {}", (Object)entity);
            return;
        }
        double motion = McHelper.lastTickPosOf(entity).distanceToSqr(entity.position());
        if (motion > 20.0) {
            return;
        }
        ServerTaskList.of(portal.getServer()).addTask(() -> {
            try {
                this.teleportRegularEntity(entity, portal);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
            return true;
        });
    }

    private static Stream<Entity> getEntitiesToTeleport(Portal portal) {
        return portal.level().getEntitiesOfClass(Entity.class, portal.getBoundingBox().inflate(2.0), e -> true).stream().filter(e -> !(e instanceof Portal)).filter(entity -> ServerTeleportationManager.shouldEntityTeleport(portal, entity));
    }

    public void onPlayerTeleportedInClient(ServerPlayer player, ResourceKey<Level> dimensionBefore, Vec3 eyePosBeforeTeleportation, UUID portalId) {
        if (player.getRemovalReason() != null) {
            LOGGER.error("Trying to teleport a removed player {}", (Object)player);
            return;
        }
        Portal portal = this.findPortal(player.server, dimensionBefore, portalId);
        if (portal == null) {
            LOGGER.error("Unable to find portal {} in {} to teleport {}", new Object[]{portalId, dimensionBefore.location(), player});
            return;
        }
        this.lastTeleportGameTime.put((Entity)player, McHelper.getServerGameTime());
        Vec3 oldFeetPos = eyePosBeforeTeleportation.subtract(McHelper.getEyeOffset((Entity)player));
        String failReason = this.validatePlayerTeleportationAndGetReason(player, dimensionBefore, oldFeetPos, portal);
        if (failReason == null) {
            if (this.isTeleporting((Entity)player)) {
                LOGGER.info("{} is teleporting frequently", (Object)player);
            }
            ServerTeleportationManager.notifyChasersForPlayer(player, portal);
            ResourceKey<Level> dimensionTo = portal.getDestDim();
            Vec3 newEyePos = portal.transformPoint(eyePosBeforeTeleportation);
            this.recordLastPosition(player, dimensionBefore, oldFeetPos);
            this.teleportPlayer(player, dimensionTo, newEyePos);
            portal.onEntityTeleportedOnServer((Entity)player);
            ScaleUtils.onServerEntityTeleported((Entity)player, portal);
            if (portal.getTeleportChangesGravity()) {
                Direction oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
                GravityChangerInterface.invoker.setBaseGravityDirectionServer((Entity)player, portal.getTransformedGravityDirection(oldGravityDir));
            }
        } else {
            LOGGER.error("Player {} {} {} cannot teleport through portal {}\nReason: {}", new Object[]{player, player.level().dimension().location(), player.position(), portal, failReason});
            ServerTeleportationManager.teleportEntityGeneral((Entity)player, player.position(), (ServerLevel)player.level());
            ScaleUtils.setBaseScale((Entity)player, ScaleUtils.getBaseScale((Entity)player));
            GravityChangerInterface.invoker.setBaseGravityDirectionServer((Entity)player, GravityChangerInterface.invoker.getGravityDirection((Entity)player));
        }
    }

    @Nullable
    private Portal findPortal(MinecraftServer server, ResourceKey<Level> dimensionBefore, UUID portalId) {
        ServerLevel originalWorld = server.getLevel(dimensionBefore);
        if (originalWorld == null) {
            LOGGER.error("Missing world {} when finding portal", (Object)dimensionBefore.location());
            return null;
        }
        Entity portalEntity = originalWorld.getEntity(portalId);
        if (portalEntity == null) {
            portalEntity = GlobalPortalStorage.get((ServerLevel)originalWorld).data.stream().filter(p -> p.getUUID().equals(portalId)).findFirst().orElse(null);
        }
        if (portalEntity == null) {
            return null;
        }
        if (portalEntity instanceof Portal) {
            return (Portal)portalEntity;
        }
        return null;
    }

    public void recordLastPosition(ServerPlayer player, ResourceKey<Level> dim, Vec3 pos) {
        this.lastPosition.put(player, new WithDim<Vec3>(dim, pos));
    }

    @Nullable
    private String validatePlayerTeleportationAndGetReason(ServerPlayer player, ResourceKey<Level> dimensionBefore, Vec3 posBefore, Portal portal) {
        if (player.getVehicle() != null) {
            return null;
        }
        if (((IEServerPlayNetworkHandler)player.connection).ip_hasAwaitingTeleport()) {
            return "has awaiting teleport";
        }
        if (!portal.canTeleportEntity((Entity)player)) {
            return "portal cannot teleport player";
        }
        if (player.level().dimension() != dimensionBefore) {
            return "player is not in the dimensionBefore in packet";
        }
        if (player.position().distanceToSqr(posBefore) > 256.0) {
            return "player is too far from the posBefore in packet";
        }
        if (portal.getDistanceToNearestPointInPortal(posBefore) > 20.0) {
            return "posBefore is too far from portal";
        }
        return null;
    }

    public static boolean canPlayerReachPos(ServerPlayer player, ResourceKey<Level> dimension, Vec3 pos) {
        Vec3 playerPos = player.position();
        if (player.level().dimension() == dimension && playerPos.distanceToSqr(pos) < 256.0) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((Entity)player, 20.0).filter(portal -> portal.getDestDim() == dimension).filter(portal -> portal.canTeleportEntity((Entity)player)).map(portal -> portal.transformPoint(playerPos)).anyMatch(mappedPos -> mappedPos.distanceToSqr(pos) < 256.0);
    }

    public static boolean canPlayerReachBlockEntity(ServerPlayer player, BlockEntity blockEntity) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            return false;
        }
        return ServerTeleportationManager.canPlayerReachPos(player, (ResourceKey<Level>)world.dimension(), Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()));
    }

    public void teleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionTo, Vec3 newEyePos) {
        MinecraftServer server = player.server;
        server.getProfiler().push("portal_teleport");
        ServerLevel fromWorld = (ServerLevel)player.level();
        ServerLevel toWorld = server.getLevel(dimensionTo);
        if (player.level().dimension() == dimensionTo) {
            McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
            McHelper.updateBoundingBox((Entity)player);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
        }
        McHelper.adjustVehicle((Entity)player);
        player.connection.resetPosition();
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((Entity)player, newEyePos, newEyePos, 1.0f);
        server.getProfiler().pop();
    }

    public void forceTeleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionTo, Vec3 newPos) {
        this.forceTeleportPlayer(player, dimensionTo, newPos, true);
    }

    public void forceTeleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionTo, Vec3 newPos, boolean sendPacket) {
        if (IPConfig.getConfig().serverTeleportLogging) {
            LOGGER.info("Force teleporting {} to {} {}", new Object[]{player, dimensionTo.location(), newPos});
        }
        ServerLevel fromWorld = (ServerLevel)player.level();
        ServerLevel toWorld = player.server.getLevel(dimensionTo);
        if (toWorld == null) {
            LOGGER.error("Cannot teleport player {} to non-existing dimension {}", (Object)player, (Object)dimensionTo.location());
            return;
        }
        if (player.level().dimension() == dimensionTo) {
            player.setPos(newPos.x, newPos.y, newPos.z);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newPos.add(McHelper.getEyeOffset((Entity)player)));
        }
        if (sendPacket) {
            player.connection.teleport(newPos.x, newPos.y, newPos.z, player.getYRot(), player.getXRot());
        }
        player.connection.resetPosition();
        Vec3 newEyePos = McHelper.getEyePos((Entity)player);
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((Entity)player, newEyePos, newEyePos, 1.0f);
        ImmPtlChunkTracking.immediatelyUpdateForPlayer(player);
    }

    private void changePlayerDimension(ServerPlayer player, ServerLevel fromWorld, ServerLevel toWorld, Vec3 newEyePos) {
        this.teleportingEntities.add((Entity)player);
        Entity vehicle = player.getVehicle();
        if (vehicle != null) {
            ((IEServerPlayerEntity)player).ip_stopRidingWithoutTeleportRequest();
        }
        Vec3 oldPos = player.position();
        fromWorld.removePlayerImmediately(player, Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)player).ip_unsetRemoved();
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        player.setServerLevel(toWorld);
        toWorld.addDuringTeleport((Entity)player);
        if (vehicle != null) {
            Vec3 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (Entity)player);
            Vec3 vehiclePos = player.position().add(offset);
            vehicle = this.teleportVehicleAcrossDimensions(vehicle, (ResourceKey<Level>)toWorld.dimension(), vehiclePos.add(McHelper.getEyeOffset(vehicle)));
            McHelper.setPosAndLastTickPos(vehicle, player.position().add(offset), McHelper.lastTickPosOf((Entity)player).add(offset));
            ((IEServerPlayerEntity)player).ip_startRidingWithoutTeleportRequest(vehicle);
            McHelper.adjustVehicle((Entity)player);
        }
        if (IPConfig.getConfig().serverTeleportLogging) {
            LOGGER.info("{} :: ({} {} {} {})->({} {} {} {})", new Object[]{player.getName().getContents(), fromWorld.dimension().location(), oldPos.x(), oldPos.y(), oldPos.z(), toWorld.dimension().location(), (int)player.getX(), (int)player.getY(), (int)player.getZ()});
        }
        O_O.onPlayerTravelOnServer(player, fromWorld, toWorld);
        ((IEServerPlayerEntity)player).portal_worldChanged(fromWorld, oldPos);
    }

    private void manageGlobalPortalTeleportation() {
        for (ServerLevel world : MiscHelper.getServer().getAllLevels()) {
            for (Entity entity : world.getAllEntities()) {
                Portal collidingPortal;
                if (entity instanceof ServerPlayer || (collidingPortal = ((IEEntity)entity).ip_getCollidingPortal()) == null || !collidingPortal.getIsGlobal() || !ServerTeleportationManager.shouldEntityTeleport(collidingPortal, entity)) continue;
                this.startTeleportingRegularEntity(collidingPortal, entity);
            }
        }
    }

    public boolean isTeleporting(Entity entity) {
        return this.teleportingEntities.contains(entity);
    }

    private void teleportRegularEntity(Entity entity, Portal portal) {
        Long lastTeleportGameTime;
        Validate.isTrue((!(entity instanceof ServerPlayer) ? 1 : 0) != 0);
        if (entity.getRemovalReason() != null) {
            LOGGER.error("Trying to teleport an entity that is already removed {} {}", (Object)entity, (Object)portal);
            return;
        }
        if (entity.level() != portal.level()) {
            LOGGER.error("Cannot teleport {} from {} through {}", new Object[]{entity, entity.level().dimension(), portal});
            return;
        }
        if (portal.getDistanceToNearestPointInPortal(entity.getEyePosition()) > 5.0) {
            LOGGER.error("Entity is too far to teleport {} {}", (Object)entity, (Object)portal);
            return;
        }
        long currGameTime = McHelper.getServerGameTime();
        if (currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, 0L)) <= 0L) {
            return;
        }
        this.lastTeleportGameTime.put(entity, currGameTime);
        if (entity.isPassenger() || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        Vec3 velocity = entity.getDeltaMovement();
        Vec3 oldPos = entity.position();
        List passengerList = entity.getPassengers();
        Vec3 newEyePos = ServerTeleportationManager.getRegularEntityTeleportedEyePos(entity, portal);
        TeleportationUtil.transformEntityVelocity(portal, entity, TeleportationUtil.PortalPointVelocity.ZERO, oldPos);
        if (portal.getDestDim() != entity.level().dimension()) {
            Entity newEntity = entity = this.changeEntityDimension(entity, portal.getDestDim(), newEyePos, true);
            passengerList.stream().map(e -> this.changeEntityDimension((Entity)e, portal.getDestDim(), newEyePos, true)).collect(Collectors.toList()).forEach(e -> e.startRiding(newEntity, true));
        }
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        McHelper.sendToTrackers(entity, McRemoteProcedureCall.createPacketToSendToClient("qouteall.imm_ptl.core.teleportation.ClientTeleportationManager.RemoteCallables.updateEntityPos", entity.level().dimension(), entity.getId(), entity.position()));
        portal.onEntityTeleportedOnServer(entity);
        ScaleUtils.onServerEntityTeleported(entity, portal);
        this.lastTeleportGameTime.put(entity, currGameTime);
    }

    private static Vec3 getRegularEntityTeleportedEyePos(Entity entity, Portal portal) {
        Vec3 eyePosLastTick;
        Vec3 deltaMovement;
        Vec3 deltaMovementDirection;
        Vec3 eyePosThisTick = McHelper.getEyePos(entity);
        Vec3 collidingPoint = portal.rayTrace(eyePosThisTick.subtract((deltaMovementDirection = (deltaMovement = eyePosThisTick.subtract(eyePosLastTick = McHelper.getLastTickEyePos(entity))).normalize()).scale(5.0)), eyePosThisTick.add(deltaMovementDirection));
        if (collidingPoint == null) {
            collidingPoint = eyePosLastTick;
        }
        Vec3 result = portal.transformPoint(collidingPoint).add(deltaMovementDirection.scale(0.05));
        return result;
    }

    public Entity changeEntityDimension(Entity entity, ResourceKey<Level> toDimension, Vec3 newEyePos, boolean recreateEntity) {
        if (entity.getRemovalReason() != null) {
            LOGGER.error("Trying to teleport a removed entity {}", (Object)entity, (Object)new Throwable());
            return entity;
        }
        MinecraftServer server = entity.getServer();
        Validate.notNull((Object)server, (String)"server is null", (Object[])new Object[0]);
        ServerLevel fromWorld = (ServerLevel)entity.level();
        ServerLevel toWorld = server.getLevel(toDimension);
        if (toWorld == null) {
            LOGGER.error("Invalid dest dimension {} to teleport entity {} to", (Object)toDimension.location(), (Object)entity);
            return entity;
        }
        entity.unRide();
        if (recreateEntity) {
            Entity oldEntity = entity;
            Entity newEntity = entity.getType().create((Level)toWorld);
            if (newEntity == null) {
                return oldEntity;
            }
            newEntity.restoreFrom(oldEntity);
            newEntity.setId(oldEntity.getId());
            McHelper.setEyePos(newEntity, newEyePos, newEyePos);
            McHelper.updateBoundingBox(newEntity);
            newEntity.setYHeadRot(oldEntity.getYHeadRot());
            oldEntity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
            toWorld.addDuringTeleport(newEntity);
            return newEntity;
        }
        entity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)entity).ip_unsetRemoved();
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        ((IEEntity)entity).ip_setWorld((Level)toWorld);
        toWorld.addDuringTeleport(entity);
        Validate.isTrue((!entity.isRemoved() ? 1 : 0) != 0);
        return entity;
    }

    public Entity teleportVehicleAcrossDimensions(Entity entity, ResourceKey<Level> toDimension, Vec3 newEyePos) {
        this.teleportingEntities.add(entity);
        ServerLevel fromWorld = (ServerLevel)entity.level();
        ServerLevel toWorld = MiscHelper.getServer().getLevel(toDimension);
        Entity oldEntity = entity;
        Entity newEntity = entity.getType().create((Level)toWorld);
        Validate.isTrue((newEntity != null ? 1 : 0) != 0);
        newEntity.restoreFrom(oldEntity);
        newEntity.setId(oldEntity.getId());
        McHelper.setEyePos(newEntity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(newEntity);
        newEntity.setYHeadRot(oldEntity.getYHeadRot());
        oldEntity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)oldEntity).ip_unsetRemoved();
        toWorld.addDuringTeleport(newEntity);
        return newEntity;
    }

    private boolean doesEntityClusterContainPlayer(Entity entity) {
        if (entity instanceof Player) {
            return true;
        }
        List passengerList = entity.getPassengers();
        if (passengerList.isEmpty()) {
            return false;
        }
        return passengerList.stream().anyMatch(this::doesEntityClusterContainPlayer);
    }

    public boolean isJustTeleported(Entity entity, long valveTickTime) {
        Long lastTeleportGameTime;
        long currGameTime = McHelper.getServerGameTime();
        return currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, -100000L)) < valveTickTime;
    }

    public static Entity teleportEntityGeneral(Entity entity, Vec3 targetPos, ServerLevel targetWorld) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ServerTeleportationManager.of(serverPlayer.server).forceTeleportPlayer(serverPlayer, (ResourceKey<Level>)targetWorld.dimension(), targetPos);
            return entity;
        }
        return ServerTeleportationManager.teleportRegularEntityTo(entity, (ResourceKey<Level>)targetWorld.dimension(), targetPos);
    }

    public static <E extends Entity> E teleportRegularEntityTo(E entity, ResourceKey<Level> targetDim, Vec3 targetPos) {
        if (entity.level().dimension() == targetDim) {
            entity.moveTo(targetPos.x, targetPos.y, targetPos.z, entity.getYRot(), entity.getXRot());
            entity.setYHeadRot(entity.getYRot());
            return entity;
        }
        return (E)ServerTeleportationManager.of(entity.getServer()).changeEntityDimension(entity, targetDim, targetPos.add(McHelper.getEyeOffset(entity)), true);
    }

    private static void notifyChasersForPlayer(ServerPlayer player, Portal portal) {
        List<Mob> chasers = McHelper.findEntitiesRough(Mob.class, player.level(), player.position(), 1, e -> e.getTarget() == player);
        for (Mob chaser : chasers) {
            chaser.setTarget(null);
            ServerTeleportationManager.notifyChaser(player, portal, chaser);
        }
    }

    private static void notifyChaser(ServerPlayer player, Portal portal, Mob chaser) {
        Vec3 targetPos = player.position().add(portal.getNormal().scale(-0.1));
        UUID chaserId = chaser.getUUID();
        ServerLevel destWorld = (ServerLevel)portal.getDestinationWorld();
        ServerTaskList.of(player.server).addTask(MyTaskList.withRetryNumberLimit(140, () -> {
            if (chaser.isRemoved()) {
                Entity newChaser = destWorld.getEntity(chaserId);
                if (newChaser instanceof Mob) {
                    ((Mob)newChaser).setTarget((LivingEntity)player);
                    return true;
                }
                return false;
            }
            if (chaser.position().distanceTo(targetPos) < 2.0) {
                chaser.getMoveControl().setWantedPosition(targetPos.x, targetPos.y, targetPos.z, 1.0);
            } else {
                @Nullable Path path = chaser.getNavigation().createPath(BlockPos.containing((Position)targetPos), 0);
                chaser.getNavigation().moveTo(path, 1.0);
            }
            return false;
        }, () -> {}));
    }

    private void evacuatePlayersFromDimension(ServerLevel world) {
        ArrayList players = new ArrayList(MiscHelper.getServer().getPlayerList().getPlayers());
        for (ServerPlayer player : players) {
            if (player.level().dimension() != world.dimension()) continue;
            ServerLevel overWorld = McHelper.getOverWorldOnServer();
            BlockPos spawnPos = overWorld.getSharedSpawnPos();
            this.forceTeleportPlayer(player, (ResourceKey<Level>)Level.OVERWORLD, Vec3.atCenterOf((Vec3i)spawnPos));
            player.sendSystemMessage((Component)Component.literal((String)"Teleported to spawn pos because dimension %s had been removed".formatted(world.dimension().location())));
        }
    }
}

