/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.ClientCleanupEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ScaleUtilsClient;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEAbstractClientPlayer;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Vec2d;

public class ClientTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Minecraft client = Minecraft.getInstance();
    public static long tickTimeForTeleportation = 0L;
    private static long lastTeleportGameTime = 0L;
    private static long teleportTickTimeLimit = 0L;
    private static Vec3 lastPlayerEyePos = null;
    private static long lastRecordStableTickTime = 0L;
    private static float lastRecordStablePartialTicks = 0.0f;
    public static boolean isTeleportingTick = false;
    public static boolean isTeleportingFrame = false;
    public static boolean isTicking = false;
    private static final int teleportLimitPerFrame = 3;
    private static long teleportationCounter = 0L;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(IPGlobal.PostClientTickEvent.class, postClientTickEvent -> ClientTeleportationManager.tick());
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> {
            lastPlayerEyePos = null;
        });
    }

    private static void tick() {
        ++tickTimeForTeleportation;
        ClientTeleportationManager.changePlayerMotionIfCollidingWithPortal();
        isTeleportingTick = false;
    }

    public static void acceptSynchronizationDataFromServer(ResourceKey<Level> dimension, Vec3 pos, boolean forceAccept) {
        if (!forceAccept) {
            if (ClientTeleportationManager.isTeleportingFrequently()) {
                return;
            }
            if (ClientTeleportationManager.client.player.tickCount < 200) {
                return;
            }
        }
        if (ClientTeleportationManager.client.player.level().dimension() != dimension) {
            ClientTeleportationManager.forceTeleportPlayer(dimension, pos);
        }
    }

    public static void manageTeleportation(boolean isTicking_) {
        if (IPGlobal.disableTeleportation) {
            return;
        }
        isTicking = isTicking_;
        ++teleportationCounter;
        isTeleportingFrame = false;
        if (ClientTeleportationManager.client.level == null || ClientTeleportationManager.client.player == null) {
            lastPlayerEyePos = null;
            return;
        }
        if (ClientTeleportationManager.client.player.xo == 0.0 && ClientTeleportationManager.client.player.yo == 0.0 && ClientTeleportationManager.client.player.zo == 0.0) {
            return;
        }
        client.getProfiler().push("ip_teleport");
        ClientPortalAnimationManagement.foreachCustomAnimatedPortals(portal -> PortalExtension.forClusterPortals(portal, p -> p.animation.updateClientState((Portal)p, teleportationCounter)));
        float realPartialTicks = RenderStates.getPartialTick();
        TeleportationUtil.Teleportation lastTeleportation = null;
        ResourceKey originalDim = ClientTeleportationManager.client.player.level().dimension();
        if (lastPlayerEyePos != null) {
            TeleportationUtil.Teleportation teleportation;
            for (int i = 0; i <= 3 && (teleportation = ClientTeleportationManager.tryTeleport(realPartialTicks)) != null; ++i) {
                lastTeleportation = teleportation;
                if (i == 0) continue;
                LOGGER.info("The client player made a combo-teleport");
                if (i != 3) continue;
                LOGGER.info("Combo teleport out of limit. Reject teleportation!");
                Vec3 oldPos = lastPlayerEyePos.subtract(McHelper.getEyeOffset((Entity)ClientTeleportationManager.client.player));
                ClientTeleportationManager.forceTeleportPlayer((ResourceKey<Level>)originalDim, oldPos.add(teleportation.worldSurfaceNormal().scale(-0.001)));
                ClientTeleportationManager.client.player.setDeltaMovement(teleportation.worldSurfaceNormal().scale(-0.1));
                lastTeleportation = null;
                break;
            }
        }
        if (lastTeleportation != null && PortalExtension.get((Portal)lastTeleportation.portal()).adjustPositionAfterTeleport) {
            ClientTeleportationManager.adjustPlayerPosition(ClientTeleportationManager.client.player);
        }
        lastPlayerEyePos = ClientTeleportationManager.getPlayerEyePos(realPartialTicks);
        lastRecordStableTickTime = StableClientTimer.getStableTickTime();
        lastRecordStablePartialTicks = StableClientTimer.getStablePartialTicks();
        client.getProfiler().pop();
    }

    @Nullable
    private static TeleportationUtil.Teleportation tryTeleport(float partialTicks) {
        LocalPlayer player = ClientTeleportationManager.client.player;
        assert (player != null);
        Vec3 thisFrameEyePos = ClientTeleportationManager.getPlayerEyePos(partialTicks);
        if (lastPlayerEyePos.distanceToSqr(thisFrameEyePos) > 1600.0) {
            return null;
        }
        assert (ClientTeleportationManager.client.level != null);
        long currentGameTime = ClientTeleportationManager.client.level.getGameTime();
        Vec3 lastTickEyePos = McHelper.getLastTickEyePos((Entity)player);
        Vec3 thisTickEyePos = McHelper.getEyePos((Entity)player);
        ArrayList teleportationCandidates = new ArrayList();
        IPMcHelper.traverseNearbyPortals(player.level(), thisFrameEyePos, IPGlobal.maxNormalPortalRadius + 1, portal -> {
            if (!portal.canTeleportEntity((Entity)player)) {
                return;
            }
            if (portal.animation.clientLastFramePortalStateCounter == teleportationCounter - 1L && portal.animation.clientLastFramePortalState != null && portal.animation.lastTickAnimatedState != null && portal.animation.thisTickAnimatedState != null) {
                assert (portal.animation.clientCurrentFramePortalState != null);
                TeleportationUtil.Teleportation teleportation = TeleportationUtil.checkDynamicTeleportation(portal, portal.animation.clientLastFramePortalState, portal.animation.clientCurrentFramePortalState, lastPlayerEyePos, thisFrameEyePos, portal.animation.lastTickAnimatedState, portal.animation.thisTickAnimatedState, lastTickEyePos, thisTickEyePos, partialTicks);
                if (teleportation != null) {
                    teleportationCandidates.add(teleportation);
                }
            } else {
                TeleportationUtil.Teleportation teleportation = TeleportationUtil.checkStaticTeleportation(portal, lastPlayerEyePos, thisFrameEyePos, lastTickEyePos, thisTickEyePos);
                if (teleportation != null) {
                    teleportationCandidates.add(teleportation);
                }
            }
        });
        TeleportationUtil.Teleportation teleportation = teleportationCandidates.stream().min(Comparator.comparingDouble(p -> p.worldCollisionPoint().distanceToSqr(lastPlayerEyePos))).orElse(null);
        if (teleportation != null) {
            Portal portal2 = teleportation.portal();
            Vec3 collidingPos = teleportation.worldCollisionPoint();
            client.getProfiler().push("portal_teleport");
            ClientTeleportationManager.teleportPlayer(teleportation, partialTicks);
            client.getProfiler().pop();
            boolean allowOverlappedTeleport = portal2.respectParallelOrientedPortal();
            double adjustment = allowOverlappedTeleport ? -0.001 : 0.001;
            Vec3 newDelta = teleportation.newThisTickEyePos().subtract(teleportation.newLastTickEyePos());
            lastPlayerEyePos = teleportation.teleportationCheckpoint().add(newDelta.scale(adjustment));
            return teleportation;
        }
        return null;
    }

    public static Vec3 getPlayerEyePos(float partialTick) {
        return ClientTeleportationManager.client.player.getEyePosition(partialTick);
    }

    private static void teleportPlayer(TeleportationUtil.Teleportation teleportation, float partialTicks) {
        Portal portal = teleportation.portal();
        if (tickTimeForTeleportation <= teleportTickTimeLimit) {
            Helper.log("Client player teleportation rejected");
            return;
        }
        lastTeleportGameTime = tickTimeForTeleportation;
        LocalPlayer player = ClientTeleportationManager.client.player;
        Validate.isTrue((player != null ? 1 : 0) != 0);
        ResourceKey<Level> toDimension = portal.getDestDim();
        float partialTick = RenderStates.getPartialTick();
        Entity vehicle = player.getVehicle();
        Vec3 oldVehiclePos = vehicle != null ? vehicle.position() : null;
        Vec3 thisTickEyePos = McHelper.getEyePos((Entity)player);
        Vec3 lastTickEyePos = McHelper.getLastTickEyePos((Entity)player);
        Vec3 newThisTickEyePos = teleportation.newThisTickEyePos();
        Vec3 newLastTickEyePos = teleportation.newLastTickEyePos();
        ClientLevel fromWorld = ClientTeleportationManager.client.level;
        ResourceKey fromDimension = fromWorld.dimension();
        if (fromDimension != toDimension) {
            ClientLevel toWorld = ClientWorldLoader.getWorld(toDimension);
            ClientTeleportationManager.changePlayerDimension(player, fromWorld, toWorld, newThisTickEyePos);
        }
        McHelper.setEyePos((Entity)player, newThisTickEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((Entity)player);
        Vec3 oldRealVelocity = McHelper.getWorldVelocity((Entity)player);
        TransformationManager.managePlayerRotationAndChangeGravity(portal);
        McHelper.setWorldVelocity((Entity)player, oldRealVelocity);
        TeleportationUtil.PortalPointVelocity portalPointVelocity = teleportation.portalPointVelocity();
        TeleportationUtil.transformEntityVelocity(portal, (Entity)player, portalPointVelocity, thisTickEyePos);
        if (vehicle != null) {
            TeleportationUtil.transformEntityVelocity(portal, vehicle, portalPointVelocity, oldVehiclePos);
        }
        ScaleUtilsClient.onClientPlayerTeleported(portal);
        player.connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ImmPtlNetworking.TeleportPacket(PortalAPI.clientDimKeyToInt((ResourceKey<Level>)fromDimension), thisTickEyePos, portal.getUUID())));
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((Entity)player, newThisTickEyePos, newLastTickEyePos, RenderStates.getPartialTick());
        McHelper.adjustVehicle((Entity)player);
        RenderStates.updatePreRenderInfo(partialTick);
        if (teleportation.isDynamic()) {
            LOGGER.info("Client Teleported Dynamically\nportal: {}\ntickTime: {}\nduring ticking: {}\ncounter: {}\neye pos (by frame): {} -> {}\npartial ticks: {}\nnew immediate eye pos: {}\nportal origin/normal: {} {}\nportal dest/content dir: {} {}", new Object[]{portal, tickTimeForTeleportation, isTicking, teleportationCounter, teleportation.lastWorldEyePos(), teleportation.currentWorldEyePos(), Float.valueOf(partialTicks), teleportation.newLastTickEyePos().lerp(teleportation.newThisTickEyePos(), (double)partialTick), portal.getOriginPos(), portal.getNormal(), portal.getDestPos(), portal.getContentDirection()});
        } else {
            LOGGER.info("Client Teleported Statically\nportal: {}\neye pos: {} -> {}", new Object[]{portal, teleportation.lastWorldEyePos(), teleportation.currentWorldEyePos()});
        }
        isTeleportingTick = true;
        isTeleportingFrame = true;
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public static boolean isTeleportingFrequently() {
        return tickTimeForTeleportation - lastTeleportGameTime <= 100L || tickTimeForTeleportation <= teleportTickTimeLimit;
    }

    public static void forceTeleportPlayer(ResourceKey<Level> toDimension, Vec3 destination) {
        LOGGER.info("client player force teleported {} {}", (Object)toDimension.location(), (Object)destination);
        ClientLevel fromWorld = ClientTeleportationManager.client.level;
        assert (fromWorld != null);
        ResourceKey fromDimension = fromWorld.dimension();
        LocalPlayer player = ClientTeleportationManager.client.player;
        assert (player != null);
        if (fromDimension != toDimension) {
            ClientLevel toWorld = ClientWorldLoader.getWorld(toDimension);
            Vec3 eyeOffset = McHelper.getEyeOffset((Entity)player);
            ClientTeleportationManager.changePlayerDimension(player, fromWorld, toWorld, destination.add(eyeOffset));
        }
        player.setPos(destination.x, destination.y, destination.z);
        McHelper.adjustVehicle((Entity)player);
        lastPlayerEyePos = null;
        RenderStates.updatePreRenderInfo(RenderStates.getPartialTick());
        MyGameRenderer.vanillaTerrainSetupOverride = 1;
    }

    public static void changePlayerDimension(LocalPlayer player, ClientLevel fromWorld, ClientLevel toWorld, Vec3 newEyePos) {
        Validate.isTrue((!WorldRenderInfo.isRendering() ? 1 : 0) != 0);
        Validate.isTrue((!FrontClipping.isClippingEnabled ? 1 : 0) != 0);
        Validate.isTrue((!PacketRedirectionClient.getIsProcessingRedirectedMessage() ? 1 : 0) != 0);
        Entity vehicle = player.getVehicle();
        player.unRide();
        ResourceKey toDimension = toWorld.dimension();
        ResourceKey fromDimension = fromWorld.dimension();
        ((IEClientPlayNetworkHandler)client.getConnection()).ip_setWorld(toWorld);
        fromWorld.removeEntity(player.getId(), Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)player).ip_setWorld((Level)toWorld);
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        ((IEEntity)player).ip_unsetRemoved();
        toWorld.addEntity((Entity)player);
        ((IEAbstractClientPlayer)player).ip_setClientLevel(toWorld);
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.getInstance().gameRenderer;
        gameRenderer.ip_setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)toDimension).lightmapTexture);
        ClientTeleportationManager.client.level = toWorld;
        ((IEMinecraftClient)client).ip_setWorldRenderer(ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)toDimension));
        if (ClientTeleportationManager.client.particleEngine != null) {
            ((IEParticleManager)ClientTeleportationManager.client.particleEngine).ip_setWorld(toWorld);
        }
        client.getBlockEntityRenderDispatcher().setLevel((Level)toWorld);
        if (vehicle != null) {
            Vec3 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (Entity)player);
            Vec3 vehiclePos = player.position().add(offset);
            ClientTeleportationManager.moveClientEntityAcrossDimension(vehicle, toWorld, vehiclePos);
            McHelper.setPosAndLastTickPos(vehicle, player.position().add(offset), McHelper.lastTickPosOf((Entity)player).add(offset));
            player.startRiding(vehicle, true);
        }
        Helper.log(String.format("Client Changed Dimension from %s to %s time: %s age: %s", fromDimension.location(), toDimension.location(), tickTimeForTeleportation, player.tickCount));
        FogRendererContext.onPlayerTeleport((ResourceKey<Level>)fromDimension, (ResourceKey<Level>)toDimension);
        O_O.onPlayerChangeDimensionClient((ResourceKey<Level>)fromDimension, (ResourceKey<Level>)toDimension);
    }

    private static void changePlayerMotionIfCollidingWithPortal() {
        LocalPlayer player = ClientTeleportationManager.client.player;
        Portal portal = ((IEEntity)player).ip_getCollidingPortal();
        if (portal != null) {
            if (PortalExtension.get((Portal)portal).motionAffinity > 0.0) {
                ClientTeleportationManager.changeMotion((Entity)player, portal);
            } else if (PortalExtension.get((Portal)portal).motionAffinity < 0.0 && player.getDeltaMovement().length() > 0.7) {
                ClientTeleportationManager.changeMotion((Entity)player, portal);
            }
        }
    }

    private static void changeMotion(Entity player, Portal portal) {
        Vec3 velocity = player.getDeltaMovement();
        player.setDeltaMovement(velocity.scale(1.0 + PortalExtension.get((Portal)portal).motionAffinity));
    }

    public static void moveClientEntityAcrossDimension(Entity entity, ClientLevel newWorld, Vec3 newPos) {
        ClientLevel oldWorld = (ClientLevel)entity.level();
        oldWorld.removeEntity(entity.getId(), Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)entity).ip_setWorld((Level)newWorld);
        entity.setPos(newPos.x, newPos.y, newPos.z);
        ((IEEntity)entity).ip_unsetRemoved();
        newWorld.addEntity(entity);
        Validate.isTrue((!entity.isRemoved() ? 1 : 0) != 0);
    }

    public static void disableTeleportFor(int ticks) {
        teleportTickTimeLimit = tickTimeForTeleportation + (long)ticks;
    }

    private static void adjustPlayerPosition(LocalPlayer player) {
        Function<VoxelShape, VoxelShape> shapeFilter;
        if (player.isSpectator()) {
            return;
        }
        if (player.getVehicle() != null) {
            return;
        }
        AABB playerBoundingBox = player.getBoundingBox();
        PortalCollisionHandler portalCollisionHandler = ((IEEntity)player).ip_getPortalCollisionHandler();
        List<Object> collidingPortals = portalCollisionHandler == null ? Collections.emptyList() : portalCollisionHandler.getCollidingPortals();
        Direction gravityDir = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
        Direction levitationDir = gravityDir.getOpposite();
        Vec3 eyeOffset = GravityChangerInterface.invoker.getEyeOffset((Entity)player);
        AABB bottomHalfBox = playerBoundingBox.contract(eyeOffset.x / 2.0, eyeOffset.y / 2.0, eyeOffset.z / 2.0);
        AABB collisionUnion = CollisionHelper.getTotalBlockCollisionBox((Entity)player, bottomHalfBox, shapeFilter = c -> {
            VoxelShape curr = c;
            for (Portal collidingPortal : collidingPortals) {
                Plane outerClipping = collidingPortal.getPortalShape().getOuterClipping(collidingPortal.getThisSideState());
                if (outerClipping == null || (curr = CollisionHelper.clipVoxelShape(curr, outerClipping.pos(), outerClipping.normal())) != null) continue;
                return null;
            }
            return curr;
        });
        if (collisionUnion == null) {
            return;
        }
        Vec3 anchor = player.position();
        AABB collisionUnionLocal = Helper.transformBox(collisionUnion, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.subtract(anchor)));
        AABB playerBoxLocal = Helper.transformBox(playerBoundingBox, v -> GravityChangerInterface.invoker.transformWorldToPlayer(gravityDir, v.subtract(anchor)));
        double targetLocalY = collisionUnionLocal.maxY + 0.01;
        double originalLocalY = playerBoxLocal.minY;
        double delta = targetLocalY - originalLocalY;
        if (delta <= 0.0) {
            return;
        }
        Vec3 levitationVec = Vec3.atLowerCornerOf((Vec3i)levitationDir.getNormal());
        Vec3 offset = levitationVec.scale(delta);
        int ticks = 5;
        Helper.log("Adjusting Client Player Position");
        int[] counter = new int[]{0};
        IPGlobal.CLIENT_TASK_LIST.addTask(() -> {
            Vec3 newEyePos;
            Vec3 eyePos;
            if (player.isRemoved()) {
                return true;
            }
            if (GravityChangerInterface.invoker.getGravityDirection((Entity)player) != gravityDir) {
                return true;
            }
            if (counter[0] >= 5) {
                return true;
            }
            counter[0] = counter[0] + 1;
            double len = player.position().subtract(anchor).dot(levitationVec);
            if (len < -1.0 || len > 2.0) {
                return true;
            }
            double progress = (double)counter[0] / 5.0;
            progress = TransformationManager.mapProgress(progress);
            Vec3 expectedPos = anchor.add(offset.scale(progress));
            Vec3 newPos = Helper.putCoordinate(player.position(), levitationDir.getAxis(), Helper.getCoordinate(expectedPos, levitationDir.getAxis()));
            Portal currentCollidingPortal = ((IEEntity)player).ip_getCollidingPortal();
            if (currentCollidingPortal != null && currentCollidingPortal.rayTrace(eyePos = McHelper.getEyePos((Entity)player), newEyePos = newPos.add(McHelper.getEyeOffset((Entity)player))) != null) {
                return true;
            }
            player.setPosRaw(newPos.x, newPos.y, newPos.z);
            McHelper.updateBoundingBox((Entity)player);
            return false;
        });
    }

    public static class RemoteCallables {
        public static void updateEntityPos(ResourceKey<Level> dim, int entityId, Vec3 pos) {
            ClientLevel world = ClientWorldLoader.getWorld(dim);
            Entity entity = world.getEntity(entityId);
            if (entity == null) {
                Helper.err("cannot find entity to update position");
                return;
            }
            entity.setPos(pos);
            entity.lerpTo(pos.x, pos.y, pos.z, entity.getYRot(), entity.getXRot(), 0);
            entity.setPos(pos);
        }
    }

    private record TeleportationRec(Portal portal, Vec2d portalLocalXY, Vec3 collisionPos) {
    }
}

