/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;

public class RendererDebug
extends PortalRenderer {
    @Override
    public void onBeforeTranslucentRendering(Matrix4f modelView) {
        this.renderPortals(modelView);
    }

    @Override
    public void onAfterTranslucentRendering(Matrix4f modelView) {
    }

    @Override
    public void onHandRenderingEnded() {
    }

    @Override
    public void prepareRendering() {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        return false;
    }

    protected void doRenderPortal(Portal portal, Matrix4f modelView) {
        if (RenderStates.getRenderedPortalNum() != 0) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, modelView)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        GlStateManager._clearColor((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)16640, (boolean)Minecraft.ON_OSX);
        GL11.glDisable((int)2960);
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
    }

    private boolean testShouldRenderPortal(Portal portal, Matrix4f modelView) {
        return QueryManager.renderAndGetDoesAnySamplePass(() -> ViewAreaRenderer.renderPortalArea(portal, Vec3.ZERO, modelView, RenderSystem.getProjectionMatrix(), true, true, true, true));
    }

    protected void renderPortals(Matrix4f modelView) {
        List<Portal> portalsToRender = this.getPortalsToRender(modelView);
        for (Portal portal : portalsToRender) {
            this.doRenderPortal(portal, modelView);
        }
    }
}

