/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class StaticFieldsSwappingManager<Context> {
    private final Consumer<Context> copyFromObject;
    private final Consumer<Context> copyToObject;
    private final boolean strictCheck;
    @Nullable
    private final Supplier<Context> contextConstructor;
    private ResourceKey<Level> outerDimension;
    private Stack<ContextRecord<Context>> swappedContext = new Stack();
    public final Map<ResourceKey<Level>, ContextRecord<Context>> contextMap = new HashMap<ResourceKey<Level>, ContextRecord<Context>>();

    public StaticFieldsSwappingManager(Consumer<Context> copyFromObject, Consumer<Context> copyToObject, boolean doStrictCheck, @Nullable Supplier<Context> contextConstructor) {
        this.copyFromObject = copyFromObject;
        this.copyToObject = copyToObject;
        this.strictCheck = doStrictCheck;
        this.contextConstructor = contextConstructor;
    }

    public boolean isSwapped() {
        return !this.swappedContext.empty();
    }

    public void setOuterDimension(ResourceKey<Level> dim) {
        Validate.isTrue((!this.isSwapped() ? 1 : 0) != 0);
        this.outerDimension = dim;
    }

    public void resetChecks() {
        Validate.isTrue((!this.isSwapped() ? 1 : 0) != 0);
        this.contextMap.values().forEach(record -> {
            record.isHoldingLatestContext = record.dimension != this.outerDimension;
        });
    }

    public ResourceKey<Level> getCurrentDimension() {
        if (this.swappedContext.empty()) {
            Validate.notNull(this.outerDimension);
            return this.outerDimension;
        }
        return this.swappedContext.peek().dimension;
    }

    public void pushSwapping(ResourceKey<Level> newDimension) {
        ResourceKey<Level> currentDimension = this.getCurrentDimension();
        ContextRecord<Context> oldContext = this.contextMap.get(currentDimension);
        ContextRecord newContext = this.contextMap.computeIfAbsent(newDimension, k -> new ContextRecord<Context>(newDimension, this.contextConstructor.get(), true));
        Validate.notNull(oldContext);
        Validate.notNull((Object)newContext);
        this.swappedContext.push(newContext);
        this.transferDataFromStaticFieldsToObject(oldContext);
        this.transferDataFromObjectToStaticFields(newContext);
    }

    public void popSwapping() {
        ContextRecord<Context> outerContext = this.swappedContext.pop();
        ContextRecord<Context> innerContext = this.contextMap.get(this.getCurrentDimension());
        this.transferDataFromStaticFieldsToObject(outerContext);
        this.transferDataFromObjectToStaticFields(innerContext);
    }

    public void swapAndInvoke(ResourceKey<Level> newDimension, Runnable func) {
        this.pushSwapping(newDimension);
        func.run();
        this.popSwapping();
    }

    private void transferDataFromObjectToStaticFields(ContextRecord<Context> newContext) {
        if (!this.strictCheck && newContext == null) {
            return;
        }
        if (this.strictCheck) {
            Validate.isTrue((boolean)newContext.isHoldingLatestContext);
        }
        newContext.isHoldingLatestContext = false;
        this.copyFromObject.accept(newContext.context);
    }

    private void transferDataFromStaticFieldsToObject(ContextRecord<Context> oldContext) {
        if (!this.strictCheck && oldContext == null) {
            return;
        }
        if (this.strictCheck) {
            Validate.isTrue((!oldContext.isHoldingLatestContext ? 1 : 0) != 0);
        }
        oldContext.isHoldingLatestContext = true;
        this.copyToObject.accept(oldContext.context);
    }

    public void updateOuterDimensionAndChangeContext(ResourceKey<Level> newDimension) {
        Validate.isTrue((!this.isSwapped() ? 1 : 0) != 0);
        Validate.notNull(this.outerDimension);
        ResourceKey<Level> oldDimension = this.outerDimension;
        this.transferDataFromStaticFieldsToObject(this.contextMap.get(oldDimension));
        this.transferDataFromObjectToStaticFields(this.contextMap.get(newDimension));
        this.outerDimension = newDimension;
    }

    public static class ContextRecord<Ctx> {
        public ResourceKey<Level> dimension;
        public Ctx context;
        public boolean isHoldingLatestContext = false;

        public ContextRecord(ResourceKey<Level> dimension, Ctx context, boolean isHoldingLatestContext) {
            this.dimension = dimension;
            this.context = context;
            this.isHoldingLatestContext = isHoldingLatestContext;
        }
    }
}

