/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import com.mojang.logging.LogUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationClient;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.miscellaneous.ClientPerformanceMonitor;
import qouteall.imm_ptl.core.mixin.client.particle.IEParticle;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.ForceMainThreadRebuild;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

public class RenderStates {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static int frameIndex = 0;
    public static ResourceKey<Level> originalPlayerDimension;
    public static Vec3 originalPlayerPos;
    public static Vec3 originalPlayerLastTickPos;
    public static GameType originalGameMode;
    public static AABB originalPlayerBoundingBox;
    private static float partialTick;
    public static Set<ResourceKey<Level>> renderedDimensions;
    public static List<List<WeakReference<Portal>>> lastPortalRenderInfos;
    public static List<List<WeakReference<Portal>>> portalRenderInfos;
    public static int portalsRenderedThisFrame;
    public static Vec3 lastCameraPos;
    public static Vec3 cameraPosDelta;
    public static boolean shouldForceDisableCull;
    public static long renderStartNanoTime;
    public static double viewBobFactor;
    public static Matrix4f basicProjectionMatrix;
    public static Camera originalCamera;
    public static String debugText;
    public static boolean isLaggy;
    public static boolean isRenderingEntities;
    public static boolean renderedScalingPortal;
    public static boolean isRenderingPortalWeather;

    public static void updatePreRenderInfo(float newPartialTick) {
        ClientWorldLoader.initializeIfNeeded();
        Entity cameraEntity = MyRenderHelper.client.cameraEntity;
        if (cameraEntity == null) {
            return;
        }
        originalPlayerDimension = cameraEntity.level().dimension();
        originalPlayerPos = cameraEntity.position();
        originalPlayerLastTickPos = McHelper.lastTickPosOf(cameraEntity);
        PlayerInfo entry = CHelper.getClientPlayerListEntry();
        originalGameMode = entry != null ? entry.getGameMode() : GameType.CREATIVE;
        partialTick = newPartialTick;
        renderedDimensions.clear();
        lastPortalRenderInfos = portalRenderInfos;
        portalRenderInfos = new ArrayList<List<WeakReference<Portal>>>();
        portalsRenderedThisFrame = 0;
        FogRendererContext.update();
        renderStartNanoTime = System.nanoTime();
        RenderStates.updateViewBobbingFactor(cameraEntity);
        basicProjectionMatrix = null;
        originalCamera = MyRenderHelper.client.gameRenderer.getMainCamera();
        RenderStates.updateIsLaggy();
        ForceMainThreadRebuild.onPreRender();
        debugText = "";
        QueryManager.queryStallCounter = 0;
        Vec3 velocity = McHelper.getWorldVelocity(cameraEntity);
        originalPlayerBoundingBox = cameraEntity.getBoundingBox().expandTowards(-velocity.x, -velocity.y, -velocity.z);
    }

    private static void updateIsLaggy() {
        if (!IPGlobal.lagAttackProof) {
            isLaggy = false;
            return;
        }
        if (isLaggy) {
            if (ClientPerformanceMonitor.getMinimumFps() > 15) {
                isLaggy = false;
            }
        } else if (lastPortalRenderInfos.size() > 10 && (ClientPerformanceMonitor.getAverageFps() < 8 || ClientPerformanceMonitor.getMinimumFps() < 6)) {
            MyRenderHelper.client.gui.setOverlayMessage((Component)Component.translatable((String)"imm_ptl.laggy"), false);
            isLaggy = true;
        }
    }

    private static void updateViewBobbingFactor(Entity cameraEntity) {
        Vec3 cameraPosVec = cameraEntity.getEyePosition(RenderStates.getPartialTick());
        double minPortalDistance = CHelper.getClientNearbyPortals(16.0).map(portal -> portal.getDistanceToNearestPointInPortal(cameraPosVec)).min(Double::compareTo).orElse(100.0);
        if (minPortalDistance < 2.0) {
            if (minPortalDistance < 1.0) {
                RenderStates.setViewBobFactor(0.0);
            } else {
                RenderStates.setViewBobFactor(minPortalDistance - 1.0);
            }
        } else {
            RenderStates.setViewBobFactor(1.0);
        }
    }

    public static double getViewBobbingOffsetMultiplier() {
        if (!IPGlobal.viewBobbingReduce) {
            return 1.0;
        }
        if (!WorldRenderInfo.isViewBobbingEnabled()) {
            return 0.0;
        }
        double allScaling = PortalRendering.getExtraModelViewScaling();
        return viewBobFactor * allScaling;
    }

    private static void setViewBobFactor(double arg) {
        viewBobFactor = arg < viewBobFactor ? arg : Mth.lerp((double)0.1, (double)viewBobFactor, (double)arg);
    }

    public static void onTotalRenderEnd() {
        Minecraft client = Minecraft.getInstance();
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.getInstance().gameRenderer;
        gameRenderer.ip_setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)client.level.dimension()).lightmapTexture);
        Vec3 currCameraPos = client.gameRenderer.getMainCamera().getPosition();
        cameraPosDelta = currCameraPos.subtract(lastCameraPos);
        if (cameraPosDelta.lengthSqr() > 1.0) {
            cameraPosDelta = Vec3.ZERO;
        }
        lastCameraPos = currCameraPos;
    }

    public static int getRenderedPortalNum() {
        return portalRenderInfos.size();
    }

    public static boolean isDimensionRendered(ResourceKey<Level> dimensionType) {
        if (dimensionType == originalPlayerDimension) {
            return true;
        }
        return renderedDimensions.contains(dimensionType);
    }

    public static boolean shouldRenderParticle(Particle particle) {
        if (((IEParticle)particle).portal_getWorld() != Minecraft.getInstance().level) {
            return false;
        }
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            Vec3 particlePos = particle.getBoundingBox().getCenter();
            return renderingPortal.isOnDestinationSide(particlePos, 0.5);
        }
        return true;
    }

    public static void setPartialTick(float partialTick_) {
        partialTick = partialTick_;
    }

    public static float getPartialTick() {
        return partialTick;
    }

    public static List<String> collectDebugText() {
        Portal collidingPortal;
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rendered Portals: " + lastPortalRenderInfos.size());
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (collidingPortal = ((IEEntity)player).ip_getCollidingPortal()) != null) {
            String text = "Colliding " + collidingPortal.toString();
            result.addAll(Helper.splitStringByLen(text, 50));
        }
        result.add("Occlusion Query Stall: " + QueryManager.queryStallCounter);
        result.add("Client Perf %s %d %d".formatted(new Object[]{ClientPerformanceMonitor.level, ClientPerformanceMonitor.getAverageFps(), ClientPerformanceMonitor.getAverageFreeMemoryMB()}));
        result.add(StableClientTimer.getDebugString());
        String blockPointingInfo = BlockManipulationClient.getDebugString();
        if (blockPointingInfo != null) {
            result.add(blockPointingInfo);
        }
        if (debugText != null && !debugText.isEmpty()) {
            result.addAll(Helper.splitStringByLen("Debug: " + debugText, 50));
        }
        return result;
    }

    static {
        originalPlayerPos = Vec3.ZERO;
        originalPlayerLastTickPos = Vec3.ZERO;
        partialTick = 0.0f;
        renderedDimensions = new HashSet<ResourceKey<Level>>();
        lastPortalRenderInfos = new ArrayList<List<WeakReference<Portal>>>();
        portalRenderInfos = new ArrayList<List<WeakReference<Portal>>>();
        portalsRenderedThisFrame = 0;
        lastCameraPos = Vec3.ZERO;
        cameraPosDelta = Vec3.ZERO;
        shouldForceDisableCull = false;
        isLaggy = false;
        isRenderingEntities = false;
        renderedScalingPortal = false;
        isRenderingPortalWeather = false;
    }
}

