/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

@OnlyIn(value=Dist.CLIENT)
public class TransformationManager {
    private static DQuaternion animationDeltaStart;
    private static long interpolationStartTime;
    private static long interpolationEndTime;
    public static final Minecraft client;
    public static boolean isIsometricView;
    public static float isometricViewLength;
    public static boolean isCalculatingViewBobbingOffset;

    public static DQuaternion getPlayerCameraRotation() {
        LocalPlayer player = TransformationManager.client.player;
        if (player == null) {
            return DQuaternion.identity;
        }
        Direction gravity = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
        return TransformationManager.getCameraRotationWithGravity(gravity, player.getXRot(), player.getYRot());
    }

    private static DQuaternion getCameraRotationWithGravity(Direction gravityDirection, float pitch, float yaw) {
        DQuaternion gravity = GravityChangerInterface.invoker.getExtraCameraRotation(gravityDirection);
        DQuaternion rawCameraRotation = DQuaternion.getCameraRotation(pitch, yaw);
        if (gravity == null) {
            return rawCameraRotation;
        }
        return rawCameraRotation.hamiltonProduct(gravity);
    }

    @Nullable
    private static DQuaternion getCurrentAnimationDelta() {
        Double animationProgress = TransformationManager.getAnimationProgress();
        if (animationProgress != null) {
            double progress = animationProgress;
            return DQuaternion.interpolate(animationDeltaStart, DQuaternion.identity, TransformationManager.mapProgress(progress));
        }
        return null;
    }

    private static void processTransformation(Camera camera, PoseStack matrixStack) {
        DQuaternion currentAnimationDelta = TransformationManager.getCurrentAnimationDelta();
        if (currentAnimationDelta != null) {
            matrixStack.mulPose(currentAnimationDelta.toMcQuaternion());
        }
        WorldRenderInfo.applyAdditionalTransformations(matrixStack);
    }

    public static Matrix4f processTransformation(Camera camera, Matrix4f matrix4f) {
        PoseStack poseStack = new PoseStack();
        poseStack.last().pose().set((Matrix4fc)matrix4f);
        TransformationManager.processTransformation(camera, poseStack);
        return poseStack.last().pose();
    }

    public static boolean isAnimationRunning() {
        return TransformationManager.getAnimationProgress() != null;
    }

    @Nullable
    public static Double getAnimationProgress() {
        if (interpolationStartTime == 0L) {
            return null;
        }
        if (animationDeltaStart == null) {
            return null;
        }
        double progress = (double)(RenderStates.renderStartNanoTime - interpolationStartTime) / ((double)interpolationEndTime - (double)interpolationStartTime);
        if (progress >= 0.0 && progress <= 1.0) {
            return progress;
        }
        return null;
    }

    public static double mapProgress(double progress) {
        return Math.sin(progress * 1.5707963267948966);
    }

    public static void managePlayerRotationAndChangeGravity(Portal portal) {
        if (portal.getRotation() != null) {
            LocalPlayer player = TransformationManager.client.player;
            Direction oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
            DQuaternion oldCameraRotation = TransformationManager.getCameraRotationWithGravity(oldGravityDir, player.getViewXRot(RenderStates.getPartialTick()), player.getViewYRot(RenderStates.getPartialTick()));
            DQuaternion currentAnimationDelta = TransformationManager.getCurrentAnimationDelta();
            if (currentAnimationDelta != null) {
                oldCameraRotation = oldCameraRotation.hamiltonProduct(currentAnimationDelta);
            }
            DQuaternion immediateFinalRot = oldCameraRotation.hamiltonProduct(portal.getRotation().getConjugated());
            Direction oldBaseGravityDir = GravityChangerInterface.invoker.getBaseGravityDirection((Entity)player);
            Direction newBaseGravityDir = portal.getTeleportedGravityDirection(oldBaseGravityDir);
            if (newBaseGravityDir != oldBaseGravityDir) {
                GravityChangerInterface.invoker.setClientPlayerGravityDirection((Player)player, newBaseGravityDir);
            }
            Direction immediateNewGravityDir = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
            DQuaternion newGravityRot = DQuaternion.fromNullable(GravityChangerInterface.invoker.getExtraCameraRotation(immediateNewGravityDir));
            DQuaternion newRawCameraRotation = immediateFinalRot.hamiltonProduct(newGravityRot.getConjugated());
            Tuple<Double, Double> pitchYaw = DQuaternion.getPitchYawFromRotation(newRawCameraRotation);
            float finalYaw = (float)((Double)pitchYaw.getB()).doubleValue();
            float finalPitch = (float)((Double)pitchYaw.getA()).doubleValue();
            if (finalPitch > 90.0f) {
                finalPitch = 90.0f - (finalPitch - 90.0f);
            } else if (finalPitch < -90.0f) {
                finalPitch = -90.0f + (-90.0f - finalPitch);
            }
            player.setYRot(finalYaw);
            player.setXRot(finalPitch);
            player.yRotO = finalYaw;
            player.xRotO = finalPitch;
            player.yBob = finalYaw;
            player.xBob = finalPitch;
            player.yBobO = finalYaw;
            player.xBobO = finalPitch;
            DQuaternion newCameraRotationWithGravity = TransformationManager.getCameraRotationWithGravity(immediateNewGravityDir, finalPitch, finalYaw);
            DQuaternion newAnimationDelta = newCameraRotationWithGravity.getConjugated().hamiltonProduct(immediateFinalRot);
            if (newAnimationDelta.getRotatingAngleDegrees() > 0.1) {
                animationDeltaStart = newAnimationDelta;
                interpolationStartTime = RenderStates.renderStartNanoTime;
                interpolationEndTime = interpolationStartTime + Helper.secondToNano(TransformationManager.getAnimationDurationSeconds());
            }
            TransformationManager.updateCamera(client);
        }
    }

    private static double getAnimationDurationSeconds() {
        return 1.0;
    }

    private static void updateCamera(Minecraft client) {
        Camera camera = client.gameRenderer.getMainCamera();
        camera.setup((BlockGetter)client.level, (Entity)client.player, !client.options.getCameraType().isFirstPerson(), client.options.getCameraType().isMirrored(), RenderStates.getPartialTick());
    }

    public static Matrix4f getMirrorTransformation(Vec3 normal) {
        float x = (float)normal.x;
        float y = (float)normal.y;
        float z = (float)normal.z;
        Matrix4f matrix = new Matrix4f();
        matrix.reflection(x, y, z, 0.0f);
        return matrix;
    }

    public static Matrix4f getIsometricProjection() {
        int w = client.getWindow().getWidth();
        int h = client.getWindow().getHeight();
        float wView = isometricViewLength / (float)h * (float)w;
        float near = -2000.0f;
        float far = 2000.0f;
        float left = -wView / 2.0f;
        float right = wView / 2.0f;
        float top = isometricViewLength / 2.0f;
        float bottom = -isometricViewLength / 2.0f;
        float[] arr = new float[]{2.0f / (right - left), 0.0f, 0.0f, -(right + left) / (right - left), 0.0f, 2.0f / (top - bottom), 0.0f, -(top + bottom) / (top - bottom), 0.0f, 0.0f, -2.0f / (far - near), -(far + near) / (far - near), 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix4f m1 = new Matrix4f();
        m1.set(arr);
        return m1;
    }

    public static Vec3 getIsometricAdjustedCameraPos() {
        Camera camera = TransformationManager.client.gameRenderer.getMainCamera();
        return TransformationManager.getIsometricAdjustedCameraPos(camera);
    }

    public static Vec3 getIsometricAdjustedCameraPos(Camera camera) {
        Vec3 cameraPos = camera.getPosition();
        if (!isIsometricView) {
            return cameraPos;
        }
        Quaternionf rotation = camera.rotation();
        Vector3f vec = new Vector3f(0.0f, 0.0f, (float)(TransformationManager.client.options.getEffectiveRenderDistance() * -10));
        rotation.transform(vec);
        return cameraPos.add((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    static {
        interpolationStartTime = 0L;
        interpolationEndTime = 1L;
        client = Minecraft.getInstance();
        isIsometricView = false;
        isometricViewLength = 50.0f;
        isCalculatingViewBobbingOffset = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RemoteCallables {
        public static void enableIsometricView(float viewLength) {
            isometricViewLength = viewLength;
            isIsometricView = true;
            TransformationManager.client.smartCull = false;
        }

        public static void disableIsometricView() {
            isIsometricView = false;
            TransformationManager.client.smartCull = true;
        }
    }
}

