/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

public class OverlayRendering {
    private static final RandomSource random = RandomSource.create();
    private static boolean shaderOverlayWarned = false;

    public static boolean shouldRenderOverlay(Portal portal) {
        BreakablePortalEntity breakablePortalEntity;
        if (portal instanceof BreakablePortalEntity && (breakablePortalEntity = (BreakablePortalEntity)portal).getActualOverlay() != null) {
            return breakablePortalEntity.isInFrontOfPortal(CHelper.getCurrentCameraPos());
        }
        return false;
    }

    public static void onRenderPortalEntity(Portal portal, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        if (IrisInterface.invoker.isShaders()) {
            if (!shaderOverlayWarned) {
                shaderOverlayWarned = true;
                CHelper.printChat("[Immersive Portals] Portal overlay cannot be rendered with shaders");
            }
            return;
        }
        if (portal instanceof BreakablePortalEntity) {
            OverlayRendering.renderBreakablePortalOverlay((BreakablePortalEntity)portal, RenderStates.getPartialTick(), matrixStack, vertexConsumerProvider);
        }
    }

    public static List<BakedQuad> getQuads(BakedModel model, BlockState blockState, Vec3 portalNormal) {
        Direction facing = Direction.getNearest((double)portalNormal.x, (double)portalNormal.y, (double)portalNormal.z);
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        result.addAll(model.getQuads(blockState, facing, random));
        result.addAll(model.getQuads(blockState, null, random));
        if (result.isEmpty()) {
            for (Direction direction : Direction.values()) {
                result.addAll(model.getQuads(blockState, direction, random));
            }
        }
        return result;
    }

    private static void renderBreakablePortalOverlay(BreakablePortalEntity portal, float partialTick, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        BreakablePortalEntity.OverlayInfo overlay = portal.getActualOverlay();
        if (overlay == null) {
            return;
        }
        BlockState blockState = overlay.blockState();
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        if (blockState == null) {
            return;
        }
        BlockRenderDispatcher blockRenderManager = Minecraft.getInstance().getBlockRenderer();
        BlockPortalShape blockPortalShape = portal.blockPortalShape;
        if (blockPortalShape == null) {
            return;
        }
        matrixStack.pushPose();
        Vec3 offset = portal.getNormal().scale(overlay.offset());
        Vec3 pos = portal.position();
        matrixStack.translate(offset.x, offset.y, offset.z);
        BakedModel model = blockRenderManager.getBlockModel(blockState);
        RenderType renderLayer = Sheets.translucentCullBlockSheet();
        VertexConsumer buffer = vertexConsumerProvider.getBuffer(renderLayer);
        List<BakedQuad> quads = OverlayRendering.getQuads(model, blockState, portal.getNormal());
        random.setSeed(0L);
        for (BlockPos blockPos : blockPortalShape.area) {
            matrixStack.pushPose();
            matrixStack.translate((double)blockPos.getX() - pos.x, (double)blockPos.getY() - pos.y, (double)blockPos.getZ() - pos.z);
            if (overlay.rotation() != null) {
                matrixStack.mulPose(overlay.rotation().toMcQuaternion());
            }
            for (BakedQuad quad : quads) {
                SodiumInterface.invoker.markSpriteActive(quad.getSprite());
                buffer.putBulkData(matrixStack.last(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 1.0f, 1.0f, (float)overlay.opacity(), new int[]{0xE000F0, 0xE000F0, 0xE000F0, 0xE000F0}, OverlayTexture.NO_OVERLAY, true);
            }
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

