/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class MyRenderHelper {
    public static final Minecraft client = Minecraft.getInstance();
    public static final SignalBiArged<ResourceProvider, Consumer<ShaderInstance>> loadShaderSignal = new SignalBiArged();
    public static DrawFbInAreaShader drawFbInAreaShader;
    public static ShaderInstance portalAreaShader;
    public static ShaderInstance blitScreenNoBlendShader;
    private static boolean debugEnabled;

    public static void init() {
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                DrawFbInAreaShader shader = new DrawFbInAreaShader(MyRenderHelper.getResourceFactory(resourceManager), "portal_draw_fb_in_area", DefaultVertexFormat.POSITION_COLOR);
                resultConsumer.accept(shader);
                drawFbInAreaShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                ShaderInstance shader = new ShaderInstance(MyRenderHelper.getResourceFactory(resourceManager), "portal_area", DefaultVertexFormat.POSITION_COLOR);
                resultConsumer.accept(shader);
                portalAreaShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                ShaderInstance shader = new ShaderInstance(MyRenderHelper.getResourceFactory(resourceManager), "blit_screen_noblend", DefaultVertexFormat.POSITION_TEX_COLOR);
                resultConsumer.accept(shader);
                blitScreenNoBlendShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static ResourceProvider getResourceFactory(final ResourceProvider resourceManager) {
        ResourceProvider resourceFactory = new ResourceProvider(){

            public Optional<Resource> getResource(ResourceLocation resourceLocation) {
                ResourceLocation corrected = McHelper.newResourceLocation("immersive_portals", resourceLocation.getPath());
                return resourceManager.getResource(corrected);
            }
        };
        return resourceFactory;
    }

    public static void drawPortalAreaWithFramebuffer(Portal portal, RenderTarget textureProvider, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableDepthTest();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._viewport((int)0, (int)0, (int)textureProvider.width, (int)textureProvider.height);
        DrawFbInAreaShader shader = drawFbInAreaShader;
        shader.setSampler("DiffuseSampler", textureProvider.getColorTextureId());
        shader.loadWidthHeight(textureProvider.width, textureProvider.height);
        if (shader.MODEL_VIEW_MATRIX != null) {
            shader.MODEL_VIEW_MATRIX.set(modelViewMatrix);
        }
        if (shader.PROJECTION_MATRIX != null) {
            shader.PROJECTION_MATRIX.set(projectionMatrix);
        }
        shader.apply();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(Vec3.ZERO, portal, CHelper.getCurrentCameraPos(), RenderStates.getPartialTick());
        shader.clear();
    }

    public static void renderScreenTriangle() {
        MyRenderHelper.renderScreenTriangle(255, 255, 255, 255);
    }

    public static void renderScreenTriangle(Vec3 color) {
        MyRenderHelper.renderScreenTriangle((int)(color.x * 255.0), (int)(color.y * 255.0), (int)(color.z * 255.0), 255);
    }

    public static void testOneTriangle(int r, int g, int b, int a) {
        ShaderInstance shader = GameRenderer.getPositionColorShader();
        Validate.notNull((Object)shader);
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        shader.MODEL_VIEW_MATRIX.set(identityMatrix);
        shader.PROJECTION_MATRIX.set(identityMatrix);
        shader.apply();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex(-1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(-1.0f, -1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(1.0f, -1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(-1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        BufferUploader.draw((MeshData)bufferBuilder.build());
        shader.clear();
    }

    @IPVanillaCopy
    public static void renderScreenTriangle(int r, int g, int b, int a) {
        ShaderInstance shader = GameRenderer.getPositionColorShader();
        Validate.notNull((Object)shader);
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        shader.MODEL_VIEW_MATRIX.set(identityMatrix);
        shader.PROJECTION_MATRIX.set(identityMatrix);
        shader.apply();
        Tesselator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex(1.0f, -1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(-1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(-1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(-1.0f, -1.0f, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(1.0f, -1.0f, 0.0f).setColor(r, g, b, a);
        BufferUploader.draw((MeshData)bufferBuilder.build());
        shader.clear();
    }

    public static void drawScreenFrameBuffer(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha) {
        int x = 0;
        int y = 0;
        int viewportWidth = textureProvider.viewWidth;
        int viewportHeight = textureProvider.viewHeight;
        MyRenderHelper.drawFramebufferWithCoordinatesAndDimensions(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, x, y, viewportWidth, viewportHeight);
    }

    public static void drawFramebuffer(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, float xMin, float xMax, float yMin, float yMax) {
        MyRenderHelper.drawFramebufferWithCoordinatesAndDimensions(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, 0, 0, client.getWindow().getWidth(), client.getWindow().getHeight());
    }

    public static void drawFramebufferWithViewport(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, float left, float right, float bottom, float up, int viewportWidth, int viewportHeight) {
        MyRenderHelper.drawFramebufferWithCoordinatesAndDimensions(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, 0, 0, viewportWidth, viewportHeight);
    }

    public static void drawFramebufferWithBounds(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, int xMin, int xMax, int yMin, int yMax) {
        MyRenderHelper.drawFramebufferWithCoordinatesAndDimensions(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, xMin, yMin, Mth.abs((int)(xMax - xMin)), Mth.abs((int)(yMax - yMin)));
    }

    @IPVanillaCopy
    public static void drawFramebufferWithCoordinatesAndDimensions(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, int x, int y, int viewportWidth, int viewportHeight) {
        CHelper.checkGlError();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.viewport((int)x, (int)(textureProvider.viewHeight - viewportHeight - y), (int)viewportWidth, (int)viewportHeight);
        if (doUseAlphaBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        } else {
            RenderSystem.disableBlend();
        }
        if (doEnableModifyAlpha) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        ShaderInstance shader = doUseAlphaBlend ? MyRenderHelper.client.gameRenderer.blitShader : blitScreenNoBlendShader;
        Validate.notNull((Object)shader, (String)"shader is null", (Object[])new Object[0]);
        shader.setSampler("DiffuseSampler", (Object)textureProvider.getColorTextureId());
        shader.apply();
        BufferBuilder bufferBuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLIT_SCREEN);
        bufferBuilder.addVertex(0.0f, 0.0f, 0.0f);
        bufferBuilder.addVertex(1.0f, 0.0f, 0.0f);
        bufferBuilder.addVertex(1.0f, 1.0f, 0.0f);
        bufferBuilder.addVertex(0.0f, 1.0f, 0.0f);
        BufferUploader.draw((MeshData)bufferBuilder.buildOrThrow());
        shader.clear();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        CHelper.checkGlError();
    }

    public static void lateUpdateLight() {
        if (!ClientWorldLoader.getIsInitialized()) {
            return;
        }
        ClientWorldLoader.getClientWorlds().forEach(world -> {
            if (!RenderStates.isDimensionRendered((ResourceKey<Level>)world.dimension())) {
                world.getChunkSource().getLightEngine().runLightUpdates();
            }
        });
    }

    public static void earlyRemoteUpload() {
        if (!ClientWorldLoader.getIsInitialized()) {
            return;
        }
        ClientWorldLoader.WORLD_RENDERER_MAP.forEach((dim, worldRenderer) -> {
            if (MyRenderHelper.client.level.dimension() != dim) {
                worldRenderer.getSectionRenderDispatcher().uploadAllPendingUploads();
            }
        });
    }

    public static void applyMirrorFaceCulling() {
        GL11.glCullFace((int)1028);
    }

    public static void recoverFaceCulling() {
        GL11.glCullFace((int)1029);
    }

    public static void clearAlphaTo1(RenderTarget mcFrameBuffer) {
        mcFrameBuffer.bindWrite(true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void restoreViewPort() {
        Minecraft client = Minecraft.getInstance();
        GlStateManager._viewport((int)0, (int)0, (int)client.getWindow().getWidth(), (int)client.getWindow().getHeight());
    }

    public static float transformFogDistance(float value) {
        Portal renderingPortal;
        if (!WorldRenderInfo.isFogEnabled()) {
            return value * 23333.0f;
        }
        if (PortalRendering.isRendering() && (renderingPortal = PortalRendering.getRenderingPortal()).isFuseView()) {
            return value * 23333.0f;
        }
        return value;
    }

    public static void debugFramebufferDepth() {
        if (!debugEnabled) {
            return;
        }
        debugEnabled = false;
        int width = MyRenderHelper.client.getMainRenderTarget().width;
        int height = MyRenderHelper.client.getMainRenderTarget().height;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = directBuffer.asFloatBuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)5126, (FloatBuffer)floatBuffer);
        float[] data = new float[width * height];
        floatBuffer.rewind();
        floatBuffer.get(data);
        float maxValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).max().getAsDouble();
        float minValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).min().getAsDouble();
        byte[] grayData = new byte[width * height];
        for (int i2 = 0; i2 < data.length; ++i2) {
            float datum = data[i2];
            datum = (datum - minValue) / (maxValue - minValue);
            grayData[i2] = (byte)(datum * 255.0f);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(grayData, grayData.length), new Point()));
        System.out.println("oops");
    }

    public static void debugFramebufferColorRed() {
        if (!debugEnabled) {
            return;
        }
        debugEnabled = false;
        int width = MyRenderHelper.client.getMainRenderTarget().width;
        int height = MyRenderHelper.client.getMainRenderTarget().height;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = directBuffer.asFloatBuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6403, (int)5126, (FloatBuffer)floatBuffer);
        float[] data = new float[width * height];
        floatBuffer.rewind();
        floatBuffer.get(data);
        float maxValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).max().getAsDouble();
        float minValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).min().getAsDouble();
        byte[] grayData = new byte[width * height];
        for (int i2 = 0; i2 < data.length; ++i2) {
            float datum = data[i2];
            datum = (datum - minValue) / (maxValue - minValue);
            grayData[i2] = (byte)(datum * 255.0f);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(grayData, grayData.length), new Point()));
        System.out.println("oops");
    }

    static {
        debugEnabled = false;
    }

    public static class DrawFbInAreaShader
    extends ShaderInstance {
        public final Uniform uniformW = this.getUniform("w");
        public final Uniform uniformH = this.getUniform("h");

        public DrawFbInAreaShader(ResourceProvider factory, String name, VertexFormat format) throws IOException {
            super(factory, name, format);
        }

        void loadWidthHeight(int w, int h) {
            this.uniformW.set((float)w);
            this.uniformH.set((float)h);
        }
    }
}

