/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import de.nick1st.imm_ptl.events.ClientCleanupEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationClient;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.client.render.IERenderSystem;
import qouteall.imm_ptl.core.mixin.client.render.IESectionRenderDispatcher;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class MyGameRenderer {
    public static final Minecraft client = Minecraft.getInstance();
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static Stack<RenderBuffers> secondaryRenderBuffers = new Stack();
    private static int usingRenderBuffersObjectNum = 0;
    public static int vanillaTerrainSetupOverride = 0;
    public static boolean enablePortalCaveCulling = true;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> secondaryRenderBuffers.clear());
    }

    @Nullable
    private static RenderBuffers acquireRenderBuffersObject() {
        ++usingRenderBuffersObjectNum;
        if (secondaryRenderBuffers.isEmpty()) {
            return new RenderBuffers(0);
        }
        return secondaryRenderBuffers.pop();
    }

    private static void returnRenderBuffersObject(RenderBuffers renderBuffers) {
        --usingRenderBuffersObjectNum;
        secondaryRenderBuffers.push(renderBuffers);
    }

    public static void renderWorldNew(WorldRenderInfo worldRenderInfo, Consumer<Runnable> invokeWrapper) {
        WorldRenderInfo.pushRenderInfo(worldRenderInfo);
        MyGameRenderer.switchAndRenderTheWorld(worldRenderInfo.world, worldRenderInfo.cameraPos, worldRenderInfo.cameraPos, invokeWrapper, worldRenderInfo.renderDistance, worldRenderInfo.doRenderHand);
        WorldRenderInfo.popRenderInfo();
    }

    private static void switchAndRenderTheWorld(ClientLevel newWorld, Vec3 thisTickCameraPos, Vec3 lastTickCameraPos, Consumer<Runnable> invokeWrapper, int renderDistance, boolean doRenderHand) {
        if (!enablePortalCaveCulling) {
            MyGameRenderer.client.smartCull = false;
        }
        if (!PortalRendering.shouldEnableSodiumCaveCulling()) {
            MyGameRenderer.client.smartCull = false;
        }
        ResourceKey newDimension = newWorld.dimension();
        LevelRenderer worldRenderer = ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)newDimension);
        CHelper.checkGlError();
        IEGameRenderer ieGameRenderer = (IEGameRenderer)MyGameRenderer.client.gameRenderer;
        DimensionRenderHelper helper = ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)newDimension);
        Camera newCamera = new Camera();
        ClientLevel oldWorld = MyGameRenderer.client.level;
        LevelRenderer oldWorldRenderer = MyGameRenderer.client.levelRenderer;
        LightTexture oldLightmap = MyGameRenderer.client.gameRenderer.lightTexture();
        boolean oldNoClip = MyGameRenderer.client.player.noPhysics;
        boolean oldDoRenderHand = ieGameRenderer.ip_getDoRenderHand();
        ObjectArrayList<SectionRenderDispatcher.RenderSection> oldChunkInfoList = ((IEWorldRenderer)oldWorldRenderer).portal_getChunkInfoList();
        HitResult oldCrosshairTarget = MyGameRenderer.client.hitResult;
        Camera oldCamera = MyGameRenderer.client.gameRenderer.getMainCamera();
        PostChain oldTransparencyShader = ((IEWorldRenderer)worldRenderer).portal_getTransparencyShader();
        RenderBuffers oldRenderBuffers = ((IEWorldRenderer)worldRenderer).ip_getRenderBuffers();
        RenderBuffers oldClientRenderBuffers = client.renderBuffers();
        SectionBufferBuilderPack oldSectionRenderDispatcherFixedBuffers = ((IESectionRenderDispatcher)worldRenderer.getSectionRenderDispatcher()).ip_getFixedBuffers();
        Frustum oldFrustum = ((IEWorldRenderer)worldRenderer).portal_getFrustum();
        Matrix4f oldProjectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4fStack oldModelViewStack = IERenderSystem.ip_getModelViewStack();
        ObjectArrayList<SectionRenderDispatcher.RenderSection> newChunkInfoList = VisibleSectionDiscovery.takeList();
        ((IEWorldRenderer)oldWorldRenderer).portal_setChunkInfoList(newChunkInfoList);
        Object irisPipeline = IrisInterface.invoker.getPipeline(worldRenderer);
        ((IEMinecraftClient)client).ip_setWorldRenderer(worldRenderer);
        MyGameRenderer.client.level = newWorld;
        ieGameRenderer.ip_setLightmapTextureManager(helper.lightmapTexture);
        MyGameRenderer.client.getBlockEntityRenderDispatcher().level = newWorld;
        MyGameRenderer.client.player.noPhysics = true;
        MyGameRenderer.client.gameRenderer.setRenderHand(doRenderHand);
        FogRendererContext.swappingManager.pushSwapping((ResourceKey<Level>)newDimension);
        ((IEParticleManager)MyGameRenderer.client.particleEngine).ip_setWorld(newWorld);
        if (BlockManipulationClient.remotePointedDim == newDimension) {
            MyGameRenderer.client.hitResult = BlockManipulationClient.remoteHitResult;
        }
        if (!PortalRendering.shouldRenderHitResult()) {
            MyGameRenderer.client.hitResult = null;
        }
        ieGameRenderer.ip_setCamera(newCamera);
        RenderBuffers newRenderBuffers = null;
        if (IPGlobal.useSecondaryEntityVertexConsumer) {
            newRenderBuffers = MyGameRenderer.acquireRenderBuffersObject();
            if (newRenderBuffers != null) {
                ((IEWorldRenderer)worldRenderer).ip_setRenderBuffers(newRenderBuffers);
                ((IEMinecraftClient)client).ip_setRenderBuffers(newRenderBuffers);
                ((IESectionRenderDispatcher)worldRenderer.getSectionRenderDispatcher()).ip_setFixedBuffers(newRenderBuffers.fixedBufferPack());
            } else {
                client.renderBuffers().bufferSource().endBatch();
            }
        }
        Object newSodiumContext = SodiumInterface.invoker.createNewContext(renderDistance);
        SodiumInterface.invoker.switchContextWithCurrentWorldRenderer(newSodiumContext);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(null);
        IERenderSystem.ip_setModelViewStack(new Matrix4fStack(16));
        RenderSystem.applyModelViewMatrix();
        IrisInterface.invoker.setPipeline(worldRenderer, null);
        if (!RenderStates.isDimensionRendered((ResourceKey<Level>)newDimension)) {
            helper.lightmapTexture.updateLightTexture(0.0f);
        }
        invokeWrapper.accept(() -> {
            client.getProfiler().push("render_portal_content");
            MyGameRenderer.client.gameRenderer.renderLevel(client.getTimer());
            client.getProfiler().pop();
        });
        SodiumInterface.invoker.switchContextWithCurrentWorldRenderer(newSodiumContext);
        ((IEMinecraftClient)client).ip_setWorldRenderer(oldWorldRenderer);
        MyGameRenderer.client.level = oldWorld;
        ieGameRenderer.ip_setLightmapTextureManager(oldLightmap);
        MyGameRenderer.client.getBlockEntityRenderDispatcher().level = oldWorld;
        MyGameRenderer.client.player.noPhysics = oldNoClip;
        MyGameRenderer.client.gameRenderer.setRenderHand(oldDoRenderHand);
        ((IEParticleManager)MyGameRenderer.client.particleEngine).ip_setWorld(oldWorld);
        MyGameRenderer.client.hitResult = oldCrosshairTarget;
        ieGameRenderer.ip_setCamera(oldCamera);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(oldTransparencyShader);
        FogRendererContext.swappingManager.popSwapping();
        ((IEWorldRenderer)oldWorldRenderer).portal_setChunkInfoList(oldChunkInfoList);
        VisibleSectionDiscovery.returnList(newChunkInfoList);
        ((IEWorldRenderer)worldRenderer).ip_setRenderBuffers(oldRenderBuffers);
        ((IEMinecraftClient)client).ip_setRenderBuffers(oldClientRenderBuffers);
        ((IESectionRenderDispatcher)worldRenderer.getSectionRenderDispatcher()).ip_setFixedBuffers(oldSectionRenderDispatcherFixedBuffers);
        if (newRenderBuffers != null) {
            MyGameRenderer.returnRenderBuffersObject(newRenderBuffers);
        }
        ((IEWorldRenderer)worldRenderer).portal_setFrustum(oldFrustum);
        MyGameRenderer.client.gameRenderer.resetProjectionMatrix(oldProjectionMatrix);
        IERenderSystem.ip_setModelViewStack(oldModelViewStack);
        RenderSystem.applyModelViewMatrix();
        IrisInterface.invoker.setPipeline(worldRenderer, irisPipeline);
        client.getEntityRenderDispatcher().prepare((Level)MyGameRenderer.client.level, oldCamera, MyGameRenderer.client.crosshairPickEntity);
        CHelper.checkGlError();
        MyGameRenderer.client.smartCull = true;
    }

    @IPVanillaCopy
    public static void resetFogState() {
        Camera camera = MyGameRenderer.client.gameRenderer.getMainCamera();
        float g = MyGameRenderer.client.gameRenderer.getRenderDistance();
        Vec3 cameraPos = camera.getPosition();
        double x = cameraPos.x();
        double y = cameraPos.y();
        double z = cameraPos.z();
        boolean isFoggy = MyGameRenderer.client.level.effects().isFoggyAt(Mth.floor((double)x), Mth.floor((double)y)) || MyGameRenderer.client.gui.getBossOverlay().shouldCreateWorldFog();
        FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(g, 32.0f), (boolean)isFoggy, (float)RenderStates.getPartialTick());
        FogRenderer.levelFogColor();
    }

    public static void updateFogColor() {
        FogRenderer.setupColor((Camera)MyGameRenderer.client.gameRenderer.getMainCamera(), (float)RenderStates.getPartialTick(), (ClientLevel)MyGameRenderer.client.level, (int)MyGameRenderer.client.options.getEffectiveRenderDistance(), (float)MyGameRenderer.client.gameRenderer.getDarkenWorldAmount(RenderStates.getPartialTick()));
    }

    @IPVanillaCopy
    public static void resetDiffuseLighting() {
        ClientLevel world = MyGameRenderer.client.level;
        assert (world != null);
        if (world.effects().constantAmbientLight()) {
            Lighting.setupNetherLevel();
        } else {
            Lighting.setupLevel();
        }
    }
}

