/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL15;

public class GlQueryObject {
    private int idQueryObject = -1;
    private boolean isQuerying = false;
    private boolean hasResult = false;
    private static final ArrayList<GlQueryObject> queryObjects = new ArrayList();

    public GlQueryObject(int handle) {
        this.idQueryObject = handle;
    }

    public void performQueryAnySamplePassed(Runnable renderingFunc) {
        if (Minecraft.ON_OSX) {
            this.performQuerySampleNumPassed(renderingFunc);
            return;
        }
        this.performQuery(renderingFunc, 35887);
    }

    public void performQuerySampleNumPassed(Runnable renderingFunc) {
        this.performQuery(renderingFunc, 35092);
    }

    private void performQuery(Runnable renderingFunc, int glQueryType) {
        Validate.isTrue((boolean)this.isValid());
        Validate.isTrue((!this.isQuerying ? 1 : 0) != 0);
        GL15.glBeginQuery((int)glQueryType, (int)this.idQueryObject);
        this.isQuerying = true;
        renderingFunc.run();
        GL15.glEndQuery((int)glQueryType);
        this.isQuerying = false;
        this.hasResult = true;
    }

    public boolean fetchQueryResult() {
        Validate.isTrue((boolean)this.isValid());
        Validate.isTrue((boolean)this.hasResult);
        int result = GL15.glGetQueryObjecti((int)this.idQueryObject, (int)34918);
        return result != 0;
    }

    private void dispose() {
        if (this.idQueryObject != -1) {
            GL15.glDeleteQueries((int)this.idQueryObject);
            this.idQueryObject = -1;
        }
    }

    public boolean isValid() {
        return this.idQueryObject != -1;
    }

    private void reset() {
        this.hasResult = false;
    }

    private static void prepareQueryObjects() {
        int[] buf = new int[500];
        GL15.glGenQueries((int[])buf);
        for (int id : buf) {
            queryObjects.add(new GlQueryObject(id));
        }
    }

    public static GlQueryObject acquireQueryObject() {
        if (queryObjects.isEmpty()) {
            GlQueryObject.prepareQueryObjects();
        }
        return queryObjects.remove(queryObjects.size() - 1);
    }

    public static void returnQueryObject(GlQueryObject obj) {
        obj.reset();
        if (queryObjects.size() > 1500) {
            obj.dispose();
        } else {
            queryObjects.add(obj);
        }
    }
}

