/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ScaleUtils;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;

public class CrossPortalViewRendering {
    public static final Minecraft client = Minecraft.getInstance();

    public static boolean renderCrossPortalView() {
        Vec3 renderingCameraPos;
        if (!IPGlobal.enableCrossPortalView) {
            return false;
        }
        Entity cameraEntity = CrossPortalViewRendering.client.cameraEntity;
        Camera camera1 = new Camera();
        float cameraY = ((IECamera)RenderStates.originalCamera).ip_getCameraY();
        float lastCameraY = ((IECamera)RenderStates.originalCamera).ip_getLastCameraY();
        ((IECamera)camera1).ip_setCameraY(cameraY, lastCameraY);
        Camera camera = camera1;
        camera.setup((BlockGetter)CrossPortalViewRendering.client.level, cameraEntity, CrossPortalViewRendering.isThirdPerson(), CrossPortalViewRendering.isFrontView(), RenderStates.getPartialTick());
        Vec3 realCameraPos = camera.getPosition();
        Vec3 isometricAdjustedOriginalCameraPos = TransformationManager.getIsometricAdjustedCameraPos(camera);
        Vec3 physicalPlayerHeadPos = ClientTeleportationManager.getPlayerEyePos(RenderStates.getPartialTick());
        Pair portalHit = PortalCommand.raytracePortals((Level)CrossPortalViewRendering.client.level, physicalPlayerHeadPos, isometricAdjustedOriginalCameraPos, true).orElse(null);
        if (portalHit == null) {
            return false;
        }
        Portal portal = (Portal)portalHit.getFirst();
        Vec3 hitPos = (Vec3)portalHit.getSecond();
        if (!portal.canTeleportEntity(cameraEntity)) {
            return false;
        }
        if (CrossPortalViewRendering.isThirdPerson()) {
            double distance = CrossPortalViewRendering.getThirdPersonMaxDistance();
            Vec3 thirdPersonPos = realCameraPos.subtract(physicalPlayerHeadPos).normalize().scale(distance).add(physicalPlayerHeadPos);
            renderingCameraPos = CrossPortalViewRendering.getThirdPersonCameraPos(thirdPersonPos, portal, hitPos);
        } else {
            renderingCameraPos = portal.transformPoint(realCameraPos);
        }
        ((IECamera)RenderStates.originalCamera).portal_setPos(renderingCameraPos);
        WorldRenderInfo worldRenderInfo = new WorldRenderInfo.Builder().setWorld(ClientWorldLoader.getWorld(portal.getDestDim())).setCameraPos(renderingCameraPos).setCameraTransformation(portal.getAdditionalCameraTransformation()).setOverwriteCameraTransformation(false).setDescription(null).setRenderDistance(CrossPortalViewRendering.client.options.getEffectiveRenderDistance()).setDoRenderHand(false).setEnableViewBobbing(false).build();
        IPCGlobal.renderer.invokeWorldRendering(worldRenderInfo);
        return true;
    }

    private static boolean isFrontView() {
        return CrossPortalViewRendering.client.options.getCameraType().isMirrored();
    }

    private static boolean isThirdPerson() {
        return !CrossPortalViewRendering.client.options.getCameraType().isFirstPerson();
    }

    private static Vec3 getThirdPersonCameraPos(Vec3 endPos, Portal portal, Vec3 startPos) {
        Vec3 rtStart = portal.transformPoint(startPos);
        Vec3 rtEnd = portal.transformPoint(endPos);
        assert (CrossPortalViewRendering.client.cameraEntity != null);
        BlockHitResult blockHitResult = portal.getDestinationWorld().clip(new ClipContext(rtStart, rtEnd, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CrossPortalViewRendering.client.cameraEntity));
        if (blockHitResult.getType() == HitResult.Type.BLOCK) {
            return rtStart.add(rtEnd.subtract(rtStart).normalize().scale(CrossPortalViewRendering.getThirdPersonMaxDistance()));
        }
        return blockHitResult.getLocation();
    }

    private static double getThirdPersonMaxDistance() {
        return 4.0 * ScaleUtils.computeThirdPersonScale((Entity)CrossPortalViewRendering.client.player);
    }
}

