/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.nick1st.imm_ptl.events.ClientCleanupEvent;
import de.nick1st.imm_ptl.events.DimensionEvents;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionEntry;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Plane;

@OnlyIn(value=Dist.CLIENT)
public class CrossPortalEntityRenderer {
    private static final Minecraft client = Minecraft.getInstance();
    private static final WeakHashMap<Entity, Object> collidedEntities = new WeakHashMap();
    public static boolean isRenderingEntityNormally = false;
    public static boolean isRenderingEntityProjection = false;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(IPGlobal.PostClientTickEvent.class, postClientTickEvent -> CrossPortalEntityRenderer.onClientTick());
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> CrossPortalEntityRenderer.cleanUp());
        NeoForge.EVENT_BUS.addListener(DimensionEvents.CLIENT_DIMENSION_DYNAMIC_REMOVE_EVENT.class, postClientTickEvent -> CrossPortalEntityRenderer.cleanUp());
    }

    private static void cleanUp() {
        collidedEntities.clear();
    }

    private static void onClientTick() {
        collidedEntities.entrySet().removeIf(entry -> {
            Entity entity = (Entity)entry.getKey();
            return entity.isRemoved() || !((IEEntity)entity).ip_isCollidingWithPortal();
        });
    }

    public static void onEntityTickClient(Entity entity) {
        if (entity instanceof Portal) {
            return;
        }
        if (((IEEntity)entity).ip_isCollidingWithPortal()) {
            collidedEntities.put(entity, null);
        }
    }

    public static void onBeginRenderingEntitiesAndBlockEntities(Matrix4f modelView) {
        isRenderingEntityNormally = true;
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), modelView, 0.0);
        }
    }

    private static boolean isCrossPortalRenderingEnabled() {
        if (IrisInterface.invoker.isIrisPresent()) {
            return false;
        }
        return IPGlobal.correctCrossPortalEntityRendering;
    }

    public static void onEndRenderingEntitiesAndBlockEntities(PoseStack matrixStack) {
        isRenderingEntityNormally = false;
        FrontClipping.disableClipping();
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        CrossPortalEntityRenderer.renderEntityProjections(matrixStack);
    }

    public static void beforeRenderingEntity(Entity entity, PoseStack matrixStack) {
        PortalCollisionHandler collisionHandler;
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity) && (collisionHandler = ((IEEntity)entity).ip_getPortalCollisionHandler()) != null) {
            for (PortalCollisionEntry e : collisionHandler.portalCollisions) {
                Portal collidingPortal = e.portal;
                client.renderBuffers().bufferSource().endBatch();
                FrontClipping.setupOuterClipping(matrixStack, collidingPortal);
            }
        }
    }

    public static void afterRenderingEntity(Entity entity) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity)) {
            client.renderBuffers().bufferSource().endBatch();
            FrontClipping.disableClipping();
        }
    }

    private static void renderEntityProjections(PoseStack matrixStack) {
        if (!CrossPortalEntityRenderer.isCrossPortalRenderingEnabled()) {
            return;
        }
        ResourceKey clientDim = CrossPortalEntityRenderer.client.level.dimension();
        for (Entity entity : collidedEntities.keySet()) {
            PortalCollisionHandler collisionHandler = ((IEEntity)entity).ip_getPortalCollisionHandler();
            if (collisionHandler == null) continue;
            for (PortalCollisionEntry e : collisionHandler.portalCollisions) {
                ResourceKey<Level> projectionDimension;
                Portal collidingPortal = e.portal;
                if (collidingPortal instanceof Mirror || clientDim != (projectionDimension = collidingPortal.getDestDim())) continue;
                CrossPortalEntityRenderer.renderProjectedEntity(entity, collidingPortal, matrixStack);
            }
        }
    }

    public static boolean hasIntersection(Vec3 outerPlanePos, Vec3 outerPlaneNormal, Vec3 entityPos, Vec3 collidingPortalNormal) {
        return entityPos.subtract(outerPlanePos).dot(outerPlaneNormal) > 0.01 && outerPlanePos.subtract(entityPos).dot(collidingPortalNormal) > 0.01;
    }

    private static void renderProjectedEntity(Entity entity, Portal collidingPortal, PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            if (renderingPortal instanceof Portal && !Portal.isFlippedPortal(renderingPortal, collidingPortal) && !Portal.isReversePortal(renderingPortal, collidingPortal)) {
                boolean isHidden;
                Vec3 cameraPos = CrossPortalEntityRenderer.client.gameRenderer.getMainCamera().getPosition();
                Plane innerClipping = collidingPortal.getInnerClipping();
                boolean bl = isHidden = innerClipping != null && !innerClipping.isPointOnPositiveSide(cameraPos);
                if (renderingPortal == collidingPortal || !isHidden) {
                    CrossPortalEntityRenderer.renderEntity(entity, collidingPortal, matrixStack);
                }
            }
        } else {
            FrontClipping.disableClipping();
            client.renderBuffers().bufferSource().endBatch();
            FrontClipping.setupInnerClipping(collidingPortal.getInnerClipping(), matrixStack.last().pose(), 0.0);
            CrossPortalEntityRenderer.renderEntity(entity, collidingPortal, matrixStack);
            FrontClipping.disableClipping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderEntity(Entity entity, Portal transformingPortal, PoseStack matrixStack) {
        Vec3 cameraPos = CrossPortalEntityRenderer.client.gameRenderer.getMainCamera().getPosition();
        ClientLevel newWorld = ClientWorldLoader.getWorld(transformingPortal.getDestDim());
        Vec3 entityPos = entity.position();
        Vec3 entityEyePos = McHelper.getEyePos(entity);
        Vec3 entityLastTickPos = McHelper.lastTickPosOf(entity);
        Vec3 entityLastTickEyePos = McHelper.getLastTickEyePos(entity);
        Level oldWorld = entity.level();
        Vec3 newEyePos = transformingPortal.transformPoint(entityEyePos);
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            Vec3 transformedEntityPos = newEyePos.subtract(McHelper.getEyeOffset(entity));
            AABB transformedBoundingBox = McHelper.getBoundingBoxWithMovedPosition(entity, transformedEntityPos);
            boolean intersects = PortalManipulation.isOtherSideBoxInside(transformedBoundingBox, renderingPortal);
            if (!intersects) {
                return;
            }
        }
        if (entity instanceof LocalPlayer) {
            if (!IPGlobal.renderYourselfInPortal) {
                return;
            }
            if (!transformingPortal.getDoRenderPlayer()) {
                return;
            }
            if (CrossPortalEntityRenderer.client.options.getCameraType().isFirstPerson()) {
                double dis = newEyePos.distanceTo(cameraPos);
                double valve = 0.5 + entityLastTickPos.distanceTo(entityPos);
                if (transformingPortal.getScaling() > 1.0) {
                    valve *= transformingPortal.getScaling();
                }
                if (dis < valve) {
                    return;
                }
                AABB transformedBoundingBox = Helper.transformBox(RenderStates.originalPlayerBoundingBox, transformingPortal::transformPoint);
                if (transformedBoundingBox.contains(CHelper.getCurrentCameraPos())) {
                    return;
                }
            }
        }
        isRenderingEntityProjection = true;
        matrixStack.pushPose();
        try {
            Vec3 entityInstantPos = entityLastTickPos.lerp(entityPos, (double)RenderStates.getPartialTick());
            Vec3 newEntityInstantPos = transformingPortal.transformPoint(entityInstantPos);
            Vec3 newCameraPos = entityInstantPos.subtract(newEntityInstantPos).add(cameraPos);
            CrossPortalEntityRenderer.setupEntityProjectionRenderingTransformation(transformingPortal, matrixStack, entityPos, entityLastTickPos, newCameraPos);
            MultiBufferSource.BufferSource consumers = client.renderBuffers().bufferSource();
            ((IEWorldRenderer)CrossPortalEntityRenderer.client.levelRenderer).ip_myRenderEntity(entity, newCameraPos.x, newCameraPos.y, newCameraPos.z, RenderStates.getPartialTick(), matrixStack, (MultiBufferSource)consumers);
            consumers.endBatch();
        }
        finally {
            matrixStack.popPose();
            isRenderingEntityProjection = false;
        }
    }

    private static void setupEntityProjectionRenderingTransformation(Portal portal, PoseStack matrixStack, Vec3 entityPos, Vec3 entityLastTickPos, Vec3 cameraPos) {
        if (portal.getScaling() == 1.0 && portal.getRotation() == null) {
            return;
        }
        Vec3 anchor = entityLastTickPos.lerp(entityPos, (double)RenderStates.getPartialTick()).subtract(cameraPos);
        matrixStack.translate(anchor.x, anchor.y, anchor.z);
        float scaling = (float)portal.getScaling();
        matrixStack.scale(scaling, scaling, scaling);
        if (portal.getRotation() != null) {
            matrixStack.mulPose(portal.getRotation().toMcQuaternion());
        }
        matrixStack.translate(-anchor.x, -anchor.y, -anchor.z);
    }

    public static boolean shouldRenderPlayerDefault() {
        Portal renderingPortal;
        if (!IPGlobal.renderYourselfInPortal) {
            return false;
        }
        if (!WorldRenderInfo.isRendering()) {
            return false;
        }
        LocalPlayer player = CrossPortalEntityRenderer.client.player;
        assert (player != null);
        if (PortalRendering.isRendering() && (renderingPortal = PortalRendering.getRenderingPortal()) instanceof Mirror) {
            float width = player.getBbWidth();
            if (renderingPortal.getDistanceToNearestPointInPortal(player.getEyePosition()) < (double)width * 0.8) {
                return false;
            }
        }
        return CrossPortalEntityRenderer.client.level == player.level();
    }

    public static boolean shouldRenderEntityNow(Entity entity) {
        Validate.notNull((Object)entity);
        if (IrisInterface.invoker.isRenderingShadowMap()) {
            return true;
        }
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            Portal collidingPortal = ((IEEntity)entity).ip_getCollidingPortal();
            if (entity instanceof Player && !renderingPortal.getDoRenderPlayer()) {
                return false;
            }
            if (collidingPortal != null && !(entity instanceof LocalPlayer) && renderingPortal instanceof Portal && !Portal.isReversePortal(collidingPortal, renderingPortal)) {
                boolean isHidden;
                Vec3 cameraPos = PortalRenderer.client.gameRenderer.getMainCamera().getPosition();
                boolean bl = isHidden = cameraPos.subtract(collidingPortal.getOriginPos()).dot(collidingPortal.getNormal()) < 0.0;
                if (isHidden) {
                    return false;
                }
            }
            return renderingPortal.isOnDestinationSide(CrossPortalEntityRenderer.getRenderingCameraPos(entity), -0.01);
        }
        return true;
    }

    public static boolean shouldRenderPlayerNormally(Entity entity) {
        if (!CrossPortalEntityRenderer.client.options.getCameraType().isFirstPerson()) {
            return true;
        }
        if (RenderStates.originalPlayerBoundingBox.contains(CHelper.getCurrentCameraPos())) {
            return false;
        }
        double distanceToCamera = CrossPortalEntityRenderer.getRenderingCameraPos(entity).distanceTo(CrossPortalEntityRenderer.client.gameRenderer.getMainCamera().getPosition());
        return distanceToCamera > 1.0 || PortalRendering.isRenderingOddNumberOfMirrors();
    }

    public static Vec3 getRenderingCameraPos(Entity entity) {
        if (entity instanceof LocalPlayer) {
            return RenderStates.originalPlayerPos.add(McHelper.getEyeOffset(entity));
        }
        return entity.getEyePosition(RenderStates.getPartialTick());
    }
}

