/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.portal.shape.RectangularPortalShape;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public final class SpecialFlatPortalShape
implements PortalShape {
    @NotNull
    public final Mesh2D mesh;

    public SpecialFlatPortalShape(@NotNull Mesh2D mesh) {
        this.mesh = mesh;
        this.mesh.enableTriangleLookup();
    }

    public static void init() {
        PortalShapeSerialization.addSerializer(new PortalShapeSerialization.Serializer<SpecialFlatPortalShape>("specialFlat", SpecialFlatPortalShape.class, SpecialFlatPortalShape::serialize, SpecialFlatPortalShape::deserialize));
    }

    @NotNull
    private CompoundTag serialize() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("shape", (Tag)this.mesh.toTag());
        return compoundTag;
    }

    @Nullable
    private static SpecialFlatPortalShape deserialize(CompoundTag tag) {
        Mesh2D m = Mesh2D.fromTag(tag.getCompound("shape"));
        if (m == null) {
            return null;
        }
        return new SpecialFlatPortalShape(m);
    }

    @Override
    public boolean isPlanar() {
        return true;
    }

    @Override
    public AABB getBoundingBox(UnilateralPortalState portalState, boolean limitSize, double boxExpand) {
        return RectangularPortalShape.INSTANCE.getBoundingBox(portalState, limitSize, boxExpand);
    }

    @Override
    public double roughDistanceToPortalShape(UnilateralPortalState portalState, Vec3 pos) {
        return RectangularPortalShape.INSTANCE.roughDistanceToPortalShape(portalState, pos);
    }

    @Override
    @Nullable
    public RayTraceResult raytracePortalShapeByLocalPos(UnilateralPortalState portalState, Vec3 localFrom, Vec3 localTo, double leniency) {
        double ny;
        RayTraceResult roughRayTrace = RectangularPortalShape.INSTANCE.raytracePortalShapeByLocalPos(portalState, localFrom, localTo, leniency);
        if (roughRayTrace == null) {
            return null;
        }
        double localX = roughRayTrace.hitPos().x();
        double localY = roughRayTrace.hitPos().y();
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        double nx = localX / halfWidth;
        double boxR = Math.max(leniency, 1.0E-5);
        boolean intersectWithMesh = this.mesh.boxIntersects(nx - boxR, (ny = localY / halfHeight) - boxR, nx + boxR, ny + boxR);
        if (intersectWithMesh) {
            return roughRayTrace;
        }
        return null;
    }

    @Override
    public Plane getOuterClipping(UnilateralPortalState portalState) {
        return RectangularPortalShape.INSTANCE.getOuterClipping(portalState);
    }

    @Override
    public Plane getInnerClipping(UnilateralPortalState thisSideState, UnilateralPortalState otherSideState, Portal portal) {
        return RectangularPortalShape.INSTANCE.getInnerClipping(thisSideState, otherSideState, portal);
    }

    @Override
    public PortalShape getFlipped() {
        Mesh2D newMesh = new Mesh2D();
        for (int ti = 0; ti < this.mesh.getStoredTriangleNum(); ++ti) {
            if (!this.mesh.isTriangleValid(ti)) continue;
            int p0Index = this.mesh.trianglePointIndexes.getInt(ti * 3);
            int p1Index = this.mesh.trianglePointIndexes.getInt(ti * 3 + 1);
            int p2Index = this.mesh.trianglePointIndexes.getInt(ti * 3 + 2);
            newMesh.addTriangle(-this.mesh.pointCoords.getDouble(p0Index * 2), this.mesh.pointCoords.getDouble(p0Index * 2 + 1), -this.mesh.pointCoords.getDouble(p1Index * 2), this.mesh.pointCoords.getDouble(p1Index * 2 + 1), -this.mesh.pointCoords.getDouble(p2Index * 2), this.mesh.pointCoords.getDouble(p2Index * 2 + 1));
        }
        return new SpecialFlatPortalShape(newMesh);
    }

    @Override
    public PortalShape getReverse() {
        return this.getFlipped();
    }

    @Override
    public void renderViewAreaMesh(Vec3 portalOriginRelativeToCamera, UnilateralPortalState portalState, TriangleConsumer vertexOutput, boolean isGlobalPortal) {
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        Vec3 localXAxis = portalState.getAxisW().scale(halfWidth);
        Vec3 localYAxis = portalState.getAxisH().scale(halfHeight);
        for (int ti = 0; ti < this.mesh.getStoredTriangleNum(); ++ti) {
            if (!this.mesh.isTriangleValid(ti)) continue;
            int p0Index = this.mesh.getTrianglePointIndex(ti, 0);
            int p1Index = this.mesh.getTrianglePointIndex(ti, 1);
            int p2Index = this.mesh.getTrianglePointIndex(ti, 2);
            double p0x = this.mesh.getPointX(p0Index);
            double p0y = this.mesh.getPointY(p0Index);
            double p1x = this.mesh.getPointX(p1Index);
            double p1y = this.mesh.getPointY(p1Index);
            double p2x = this.mesh.getPointX(p2Index);
            double p2y = this.mesh.getPointY(p2Index);
            ViewAreaRenderer.outputTriangle(vertexOutput, portalOriginRelativeToCamera, localXAxis, localYAxis, p0x, p0y, p1x, p1y, p2x, p2y);
        }
    }

    @Override
    public boolean canCollideWith(Portal portal, UnilateralPortalState portalState, Vec3 entityEyePos, AABB entityBoundingBox) {
        boolean inFrontOfPortal = portal.isInFrontOfPortal(entityEyePos);
        if (!inFrontOfPortal) {
            return false;
        }
        return this.isBoxInPortalProjection(portalState, entityBoundingBox);
    }

    @Override
    public boolean isLocalBoxInPortalProjection(UnilateralPortalState portalState, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        boolean roughTest = RectangularPortalShape.INSTANCE.isLocalBoxInPortalProjection(portalState, minX, minY, minZ, maxX, maxY, maxZ);
        if (!roughTest) {
            return false;
        }
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        return this.mesh.boxIntersects(minX / halfWidth, minY / halfHeight, maxX / halfWidth, maxY / halfHeight);
    }

    @Override
    public Vec3 getMovementForPushingEntityOutOfPortal(Portal portal, UnilateralPortalState portalState, Entity entity, Vec3 attemptedMove) {
        return RectangularPortalShape.INSTANCE.getMovementForPushingEntityOutOfPortal(portal, portalState, entity, attemptedMove);
    }

    @Override
    public PortalShape cloneIfNecessary() {
        return new SpecialFlatPortalShape(this.mesh.copy());
    }

    @Override
    public boolean roughTestVisibility(UnilateralPortalState portalState, Vec3 cameraPos, boolean isIrisShaderOn) {
        return RectangularPortalShape.INSTANCE.roughTestVisibility(portalState, cameraPos, isIrisShaderOn);
    }

    public static SpecialFlatPortalShape createDefault() {
        return new SpecialFlatPortalShape(Mesh2D.createNewFullQuadMesh());
    }

    @Override
    public BoxPredicateF getInnerFrustumCullingFunc(Portal portal, Vec3 cameraPos) {
        return RectangularPortalShape.INSTANCE.getInnerFrustumCullingFunc(portal, cameraPos);
    }

    @Override
    public BoxPredicateF getOuterFrustumCullingFunc(Portal portal, Vec3 cameraPos) {
        return RectangularPortalShape.INSTANCE.getOuterFrustumCullingFunc(portal, cameraPos);
    }

    @Override
    public boolean shouldRenderInside(Portal portal, AABB box) {
        return RectangularPortalShape.INSTANCE.shouldRenderInside(portal, box);
    }

    @Override
    public VoxelShape getThisSideCollisionExclusion(UnilateralPortalState portalState) {
        return RectangularPortalShape.INSTANCE.getThisSideCollisionExclusion(portalState);
    }

    @Override
    @Nullable
    public AABB transformEntityActiveCollisionBox(Portal portal, AABB box, Entity entity) {
        return RectangularPortalShape.INSTANCE.transformEntityActiveCollisionBox(portal, box, entity);
    }
}

