/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.portal.shape.PortalShape;

public class PortalShapeSerialization {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Serializer<? extends PortalShape>> FROM_TYPE_NAME = new HashMap<String, Serializer<? extends PortalShape>>();
    private static final Map<Class<?>, Serializer<? extends PortalShape>> FROM_CLASS = new HashMap();

    public static void addSerializer(Serializer<? extends PortalShape> serializer) {
        FROM_TYPE_NAME.put(serializer.typeName(), serializer);
        FROM_CLASS.put(serializer.clazz(), serializer);
    }

    @Nullable
    public static PortalShape deserialize(CompoundTag tag) {
        String typeName = tag.getString("type");
        Serializer<? extends PortalShape> serializer = FROM_TYPE_NAME.get(typeName);
        if (serializer == null) {
            LOGGER.warn("unknown portal shape type {} {}", (Object)typeName, (Object)tag);
            return null;
        }
        return serializer.deserializer().apply(tag);
    }

    public static CompoundTag serialize(PortalShape portalShape) {
        Serializer<? extends PortalShape> serializer = FROM_CLASS.get(portalShape.getClass());
        if (serializer == null) {
            LOGGER.warn("unknown portal shape class {}", portalShape.getClass());
            return new CompoundTag();
        }
        CompoundTag tag = serializer.serializer().apply(portalShape);
        tag.putString("type", serializer.typeName());
        return tag;
    }

    public record Serializer<T extends PortalShape>(String typeName, Class<T> clazz, Function<T, CompoundTag> serializer, Function<CompoundTag, T> deserializer) {
    }
}

