/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public final class BoxPortalShape
implements PortalShape {
    public static final BoxPortalShape FACING_OUTWARDS = new BoxPortalShape(true);
    public static final BoxPortalShape FACING_INWARDS = new BoxPortalShape(false);
    public final boolean facingOutwards;

    public static void init() {
        PortalShapeSerialization.addSerializer(new PortalShapeSerialization.Serializer<BoxPortalShape>("box", BoxPortalShape.class, BoxPortalShape::serialize, BoxPortalShape::deserialize));
    }

    private static BoxPortalShape deserialize(CompoundTag tag) {
        boolean facingOutwards1 = tag.getBoolean("facingOutwards");
        if (facingOutwards1) {
            return FACING_OUTWARDS;
        }
        return FACING_INWARDS;
    }

    public static CompoundTag serialize(BoxPortalShape boxShape) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putBoolean("facingOutwards", boxShape.facingOutwards);
        return compoundTag;
    }

    private BoxPortalShape(boolean facingOutwards) {
        this.facingOutwards = facingOutwards;
    }

    @Override
    public boolean isPlanar() {
        return false;
    }

    @Override
    public AABB getBoundingBox(UnilateralPortalState portalState, boolean limitSize, double boxExpand) {
        double halfW = portalState.width() / 2.0 + boxExpand;
        double halfH = portalState.height() / 2.0 + boxExpand;
        double halfT = portalState.thickness() / 2.0 + boxExpand;
        if (limitSize) {
            halfW = Math.min(halfW, 32.0);
            halfH = Math.min(halfH, 32.0);
            halfT = Math.min(halfT, 32.0);
        }
        return Helper.boundingBoxOfPoints(new Vec3[]{portalState.transformLocalToGlobal(-halfW, -halfH, -halfT), portalState.transformLocalToGlobal(-halfW, -halfH, halfT), portalState.transformLocalToGlobal(-halfW, halfH, -halfT), portalState.transformLocalToGlobal(-halfW, halfH, halfT), portalState.transformLocalToGlobal(halfW, -halfH, -halfT), portalState.transformLocalToGlobal(halfW, -halfH, halfT), portalState.transformLocalToGlobal(halfW, halfH, -halfT), portalState.transformLocalToGlobal(halfW, halfH, halfT)});
    }

    @Override
    public double roughDistanceToPortalShape(UnilateralPortalState portalState, Vec3 pos) {
        Vec3 localPos = portalState.transformGlobalToLocal(pos);
        double dx = Helper.getDistanceToRange(-portalState.width() / 2.0, portalState.width() / 2.0, localPos.x());
        double dy = Helper.getDistanceToRange(-portalState.height() / 2.0, portalState.height() / 2.0, localPos.y());
        double dz = Helper.getDistanceToRange(-portalState.thickness() / 2.0, portalState.thickness() / 2.0, localPos.z());
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    @Nullable
    public RayTraceResult raytracePortalShapeByLocalPos(UnilateralPortalState portalState, Vec3 localFrom, Vec3 localTo, double leniency) {
        Vec3 lineVec = localTo.subtract(localFrom);
        RayTraceResult rayTraceResult = Helper.raytraceAABB(this.facingOutwards, -portalState.width() / 2.0, -portalState.height() / 2.0, -portalState.thickness() / 2.0, portalState.width() / 2.0, portalState.height() / 2.0, portalState.thickness() / 2.0, localFrom.x(), localFrom.y(), localFrom.z(), lineVec.x(), lineVec.y(), lineVec.z());
        return rayTraceResult;
    }

    @Override
    @Nullable
    public Plane getOuterClipping(UnilateralPortalState portalState) {
        return null;
    }

    @Override
    @Nullable
    public Plane getInnerClipping(UnilateralPortalState thisSideState, UnilateralPortalState otherSideState, Portal portal) {
        return null;
    }

    @Override
    public PortalShape getFlipped() {
        if (this.facingOutwards) {
            return FACING_INWARDS;
        }
        return FACING_OUTWARDS;
    }

    @Override
    public PortalShape getReverse() {
        return this.getFlipped();
    }

    @Override
    public boolean roughTestVisibility(UnilateralPortalState portalState, Vec3 cameraPos, boolean isIrisShaderOn) {
        boolean in;
        if (isIrisShaderOn) {
            return true;
        }
        Vec3 localPos = portalState.transformGlobalToLocal(cameraPos);
        boolean bl = in = localPos.x() > -portalState.width() / 2.0 && localPos.x() < portalState.width() / 2.0 && localPos.y() > -portalState.height() / 2.0 && localPos.y() < portalState.height() / 2.0 && localPos.z() > -portalState.thickness() / 2.0 && localPos.z() < portalState.thickness() / 2.0;
        if (this.facingOutwards) {
            return !in;
        }
        return in;
    }

    @Override
    public void renderViewAreaMesh(Vec3 portalOriginRelativeToCamera, UnilateralPortalState portalState, TriangleConsumer vertexOutput, boolean isGlobalPortal) {
        Vec3 localHX = portalState.getAxisW().scale(portalState.width() / 2.0);
        Vec3 localHY = portalState.getAxisH().scale(portalState.height() / 2.0);
        Vec3 localHZ = portalState.getNormal().scale(portalState.thickness() / 2.0);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.add(localHX), this.facingOutwards ? localHY : localHZ, this.facingOutwards ? localHZ : localHY);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.subtract(localHX), this.facingOutwards ? localHZ : localHY, this.facingOutwards ? localHY : localHZ);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.add(localHY), this.facingOutwards ? localHZ : localHX, this.facingOutwards ? localHX : localHZ);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.subtract(localHY), this.facingOutwards ? localHX : localHZ, this.facingOutwards ? localHZ : localHX);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.add(localHZ), this.facingOutwards ? localHX : localHY, this.facingOutwards ? localHY : localHX);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera.subtract(localHZ), this.facingOutwards ? localHY : localHX, this.facingOutwards ? localHX : localHY);
    }

    @Override
    public boolean canCollideWith(Portal portal, UnilateralPortalState portalState, Vec3 entityEyePos, AABB entityBoundingBox) {
        AABB expandedBox = this.getBoundingBox(portalState, false, 2.0);
        return expandedBox.intersects(entityBoundingBox);
    }

    @Override
    public boolean isLocalBoxInPortalProjection(UnilateralPortalState portalState, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Range.rangeIntersects(-portalState.width() / 2.0, portalState.width() / 2.0, minX, maxX) && Range.rangeIntersects(-portalState.height() / 2.0, portalState.height() / 2.0, minY, maxY) && Range.rangeIntersects(-portalState.thickness() / 2.0, portalState.thickness() / 2.0, minZ, maxZ);
    }

    @Override
    public Vec3 getMovementForPushingEntityOutOfPortal(Portal portal, UnilateralPortalState portalState, Entity entity, Vec3 attemptedMove) {
        AABB entityLocalBox = Helper.transformBox(entity.getBoundingBox(), portalState::transformGlobalToLocal);
        Vec3 localMove = portalState.transformVecGlobalToLocal(attemptedMove);
        AABB movedEntityLocalBox = entityLocalBox.move(localMove);
        AABB portalLocalBox = new AABB(-portalState.width() / 2.0, -portalState.height() / 2.0, -portalState.thickness() / 2.0, portalState.width() / 2.0, portalState.height() / 2.0, portalState.thickness() / 2.0);
        Vec3 offset = this.facingOutwards ? PortalCollisionHandler.getOffsetForPushingBoxOutOfAABB(movedEntityLocalBox, portalLocalBox, localMove) : PortalCollisionHandler.getOffsetForConfiningBoxInsideAABB(movedEntityLocalBox, portalLocalBox);
        return portalState.transformVecLocalToGlobal(localMove.add(offset));
    }

    @Override
    public PortalShape cloneIfNecessary() {
        return this;
    }

    @Override
    @Nullable
    public AABB transformEntityActiveCollisionBox(Portal portal, AABB box, Entity entity) {
        Vec3 eyePos = entity.getEyePosition(1.0f);
        UnilateralPortalState thisSideState = portal.getThisSideState();
        Vec3 localEyePos = thisSideState.transformGlobalToLocal(eyePos);
        AABB currBox = box;
        if (currBox != null && localEyePos.x() < -thisSideState.width() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new Vec3(-thisSideState.width() / 2.0, 0.0, 0.0)), thisSideState.transformVecLocalToGlobal(new Vec3(-1.0, 0.0, 0.0)));
        }
        if (currBox != null && localEyePos.x() > thisSideState.width() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new Vec3(thisSideState.width() / 2.0, 0.0, 0.0)), thisSideState.transformVecLocalToGlobal(new Vec3(1.0, 0.0, 0.0)));
        }
        if (currBox != null && localEyePos.y() < -thisSideState.height() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new Vec3(0.0, -thisSideState.height() / 2.0, 0.0)), thisSideState.transformVecLocalToGlobal(new Vec3(0.0, -1.0, 0.0)));
        }
        if (currBox != null && localEyePos.y() > thisSideState.height() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new Vec3(0.0, thisSideState.height() / 2.0, 0.0)), thisSideState.transformVecLocalToGlobal(new Vec3(0.0, 1.0, 0.0)));
        }
        if (currBox != null && localEyePos.z() < -thisSideState.thickness() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new Vec3(0.0, 0.0, -thisSideState.thickness() / 2.0)), thisSideState.transformVecLocalToGlobal(new Vec3(0.0, 0.0, -1.0)));
        }
        if (currBox != null && localEyePos.z() > thisSideState.thickness() / 2.0) {
            currBox = CollisionHelper.clipBox(currBox, thisSideState.transformLocalToGlobal(new Vec3(0.0, 0.0, thisSideState.thickness() / 2.0)), thisSideState.transformVecLocalToGlobal(new Vec3(0.0, 0.0, 1.0)));
        }
        return currBox;
    }

    @Override
    @Nullable
    public SectionPos getModifiedVisibleSectionIterationOrigin(Portal portal, Vec3 innerCameraPos) {
        if (!IPGlobal.boxPortalSpecialIteration) {
            return null;
        }
        if (!this.facingOutwards) {
            return null;
        }
        InnerSectionRange r = this.getInnerSectionRange(portal);
        SectionPos cameraPosSection = SectionPos.of((Position)innerCameraPos);
        int secX = Mth.clamp((int)cameraPosSection.x(), (int)r.l().x(), (int)r.hInclusive().x());
        int secY = Mth.clamp((int)cameraPosSection.y(), (int)r.l().y(), (int)r.hInclusive().y());
        int secZ = Mth.clamp((int)cameraPosSection.z(), (int)r.l().z(), (int)r.hInclusive().z());
        return SectionPos.of((int)secX, (int)secY, (int)secZ);
    }

    @Override
    public boolean shouldRenderInside(Portal portal, AABB box) {
        return true;
    }

    private InnerSectionRange getInnerSectionRange(Portal portal) {
        AABB otherSideBoundingBox = this.getReverse().getBoundingBox(portal.getOtherSideState(), false, 0.0);
        IntBox otherSideIntBox = IntBox.fromRealNumberBox(otherSideBoundingBox);
        SectionPos lSectionPos = SectionPos.of((BlockPos)otherSideIntBox.l);
        SectionPos hSectionPos = SectionPos.of((BlockPos)otherSideIntBox.h);
        return new InnerSectionRange(lSectionPos, hSectionPos);
    }

    @Override
    @Nullable
    public BoxPredicateF getInnerFrustumCullingFunc(Portal portal, Vec3 cameraPos) {
        if (!IPGlobal.boxPortalSpecialIteration) {
            return null;
        }
        if (!this.facingOutwards) {
            return null;
        }
        InnerSectionRange innerSectionRange = this.getInnerSectionRange(portal);
        float lx = (float)((double)(innerSectionRange.l.x() * 16) - cameraPos.x);
        float ly = (float)((double)(innerSectionRange.l.y() * 16) - cameraPos.y);
        float lz = (float)((double)(innerSectionRange.l.z() * 16) - cameraPos.z);
        float hx = (float)((double)((innerSectionRange.hInclusive.x() + 1) * 16) - cameraPos.x);
        float hy = (float)((double)((innerSectionRange.hInclusive.y() + 1) * 16) - cameraPos.y);
        float hz = (float)((double)((innerSectionRange.hInclusive.z() + 1) * 16) - cameraPos.z);
        return (minX, minY, minZ, maxX, maxY, maxZ) -> {
            float midX = (minX + maxX) / 2.0f;
            float midY = (minY + maxY) / 2.0f;
            float midZ = (minZ + maxZ) / 2.0f;
            return !(midX > lx && midX < hx && midY > ly && midY < hy && midZ > lz && midZ < hz);
        };
    }

    private record InnerSectionRange(SectionPos l, SectionPos hInclusive) {
    }
}

