/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.nether_portal.BlockTraverse;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class NetherPortalMatcher {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static boolean isAir(LevelAccessor world, BlockPos pos) {
        return world.isEmptyBlock(pos);
    }

    static IntBox findVerticalPortalPlacement(BlockPos areaSize, LevelAccessor world, BlockPos searchingCenter) {
        int maxY = McHelper.getMaxContentYExclusive(world);
        int minY = McHelper.getMinY(world);
        IntBox airCube = NetherPortalMatcher.getAirCubeOnGround(areaSize, new BlockPos(6, 0, 6), world, searchingCenter, 8, true, 64, maxY);
        if (airCube == null) {
            airCube = NetherPortalMatcher.getAirCubeOnGround(areaSize, new BlockPos(2, 0, 2), world, searchingCenter, 10, true, 64, maxY);
        }
        if (airCube == null) {
            airCube = NetherPortalMatcher.getAirCubeOnGround(areaSize, new BlockPos(2, 0, 2), world, searchingCenter, 10, false, minY, maxY);
        }
        if (airCube == null) {
            LOGGER.info("Cannot Find Portal Placement on Solid Surface");
            return null;
        }
        if (world.getBlockState(airCube.l.below()).isSolid()) {
            LOGGER.info("Generated Portal On Ground");
            return NetherPortalMatcher.pushDownBox(world, airCube.getSubBoxInCenter(areaSize));
        }
        LOGGER.info("Generated Portal On Non Solid Surface");
        return NetherPortalMatcher.levitateBox(world, airCube.getSubBoxInCenter(areaSize), 40);
    }

    private static IntBox expandFromBottomCenter(IntBox box, BlockPos spacing) {
        BlockPos boxSize = box.getSize();
        return box.getAdjusted(-spacing.getX() / 2, 0, -spacing.getZ() / 2, spacing.getX() / 2, spacing.getY(), spacing.getZ() / 2);
    }

    private static IntBox getAirCubeOnGround(BlockPos areaSize, BlockPos ambientSpaceReserved, LevelAccessor world, BlockPos searchingCenter, int findingRadius, boolean solidGround, int startY, int endY) {
        Predicate<BlockPos> isAirOnGroundPredicate = blockPos -> solidGround ? NetherPortalMatcher.isAirOnSolidGround(world, blockPos) : NetherPortalMatcher.isAirOnGround(world, blockPos);
        return BlockTraverse.searchColumned(searchingCenter.getX(), searchingCenter.getZ(), findingRadius, startY, endY, mutable -> {
            IntBox box;
            IntBox expanded;
            if (isAirOnGroundPredicate.test((BlockPos)mutable) && NetherPortalMatcher.isAirCubeMediumPlace(world, expanded = NetherPortalMatcher.expandFromBottomCenter(box = IntBox.fromBasePointAndSize(mutable, areaSize), ambientSpaceReserved))) {
                if (solidGround) {
                    if (BlockTraverse.boxAllMatch(box.getSurfaceLayer(Direction.DOWN), isAirOnGroundPredicate) && isAirOnGroundPredicate.test(expanded.l)) {
                        return box;
                    }
                } else {
                    return box;
                }
            }
            return null;
        });
    }

    static IntBox findHorizontalPortalPlacement(BlockPos areaSize, LevelAccessor world, BlockPos searchingCenter) {
        IntBox result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 30, 12);
        if (result == null) {
            result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 10, 12);
        }
        if (result == null) {
            result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 1, 12);
        }
        return result;
    }

    private static IntBox findHorizontalPortalPlacementWithVerticalSpaceReserved(BlockPos areaSize, LevelAccessor world, BlockPos searchingCenter, int verticalSpaceReserve, int findingRadius) {
        BlockPos growVertically = new BlockPos(areaSize.getX(), verticalSpaceReserve, areaSize.getZ());
        IntBox foundCubeArea = NetherPortalMatcher.findCubeAirAreaAtAnywhere(growVertically, world, searchingCenter, findingRadius);
        if (foundCubeArea == null) {
            return null;
        }
        return foundCubeArea.getSubBoxInCenter(areaSize);
    }

    public static boolean isSolidGroundBlock(BlockState blockState) {
        return blockState.isSolid();
    }

    public static boolean isGroundBlock(BlockState blockState) {
        return !blockState.isAir();
    }

    private static boolean isAirOnSolidGround(LevelAccessor world, BlockPos blockPos) {
        return world.isEmptyBlock(blockPos) && NetherPortalMatcher.isSolidGroundBlock(world.getBlockState(blockPos.offset(0, -1, 0)));
    }

    private static boolean isAirOnGround(LevelAccessor world, BlockPos blockPos) {
        return world.isEmptyBlock(blockPos) && NetherPortalMatcher.isGroundBlock(world.getBlockState(blockPos.offset(0, -1, 0)));
    }

    public static IntBox findCubeAirAreaAtAnywhere(BlockPos areaSize, LevelAccessor world, BlockPos searchingCenter, int findingRadius) {
        return BlockTraverse.searchColumned(searchingCenter.getX() - areaSize.getX() / 2, searchingCenter.getZ() - areaSize.getZ() / 2, findingRadius, 1 + McHelper.getMinY(world), McHelper.getMaxYExclusive(world) - 1, mutable -> {
            IntBox box = IntBox.fromBasePointAndSize(mutable, areaSize);
            if (NetherPortalMatcher.isAirCubeMediumPlace(world, box)) {
                return box;
            }
            return null;
        });
    }

    public static boolean isAirCubeMediumPlace(LevelAccessor world, IntBox box) {
        if (box.h.getY() + 1 >= McHelper.getMaxContentYExclusive(world)) {
            return false;
        }
        if (box.l.getY() - 1 <= McHelper.getMinY(world)) {
            return false;
        }
        return NetherPortalMatcher.isAllAir(world, box);
    }

    public static boolean isAllAir(LevelAccessor world, IntBox box) {
        boolean roughTest = Arrays.stream(box.getEightVertices()).allMatch(blockPos -> NetherPortalMatcher.isAir(world, blockPos));
        if (!roughTest) {
            return false;
        }
        return box.stream().allMatch(blockPos -> NetherPortalMatcher.isAir(world, blockPos));
    }

    public static IntBox levitateBox(LevelAccessor world, IntBox airCube, int maxOffset) {
        Integer maxUpShift = Helper.getLastSatisfying(IntStream.range(1, maxOffset * 3 / 2).boxed(), upShift -> NetherPortalMatcher.isAirCubeMediumPlace(world, airCube.getMoved(new Vec3i(0, upShift.intValue(), 0))));
        if (maxUpShift == null) {
            maxUpShift = 0;
        }
        return airCube.getMoved(new Vec3i(0, maxUpShift * 2 / 3, 0));
    }

    public static IntBox pushDownBox(LevelAccessor world, IntBox airCube) {
        Integer downShift = Helper.getLastSatisfying(IntStream.range(0, 40).boxed(), i -> NetherPortalMatcher.isAirCubeMediumPlace(world, airCube.getMoved(new Vec3i(0, -i.intValue(), 0))));
        if (downShift == null) {
            downShift = 0;
        }
        return airCube.getMoved(new Vec3i(0, -downShift.intValue(), 0));
    }
}

