/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.nether_portal.FastBlockAccess;
import qouteall.q_misc_util.MiscHelper;

public class FrameSearching {
    public static <T> void startSearchingPortalFrameAsync(FastBlockAccess region, int regionRadius, BlockPos centerPoint, Predicate<BlockState> framePredicate, FrameSearchingFunc<T> matchShape, Consumer<T> onFound, Runnable onNotFound) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = FrameSearching.searchPortalFrame(region, regionRadius, centerPoint, framePredicate, matchShape);
                MiscHelper.getServer().execute(() -> {
                    if (result != null) {
                        onFound.accept(result);
                    } else {
                        onNotFound.run();
                    }
                });
            }
            catch (Throwable oops) {
                oops.printStackTrace();
                onNotFound.run();
            }
        }, Util.backgroundExecutor());
    }

    @Nullable
    public static <T> T searchPortalFrame(FastBlockAccess region, int regionRadius, BlockPos centerPoint, Predicate<BlockState> framePredicate, FrameSearchingFunc<T> matchShape) {
        List<ChunkPos> chunks = FrameSearching.getChunksFromNearToFar(region, centerPoint, regionRadius);
        int minSectionY = region.minSectionY();
        int maxSectionYExclusive = region.maxSectionYExclusive();
        return FrameSearching.searchPortalFrameWithYRange(region, framePredicate, matchShape, chunks, minSectionY, McHelper.getMinY((LevelAccessor)region.world()), McHelper.getMaxYExclusive((LevelAccessor)region.world()));
    }

    @Nullable
    private static <T> T searchPortalFrameWithYRange(FastBlockAccess fastBlockAccess, Predicate<BlockState> framePredicate, FrameSearchingFunc<T> matchShape, List<ChunkPos> chunkPoses, int minSectionY, int yRangeStart, int yRangeEnd) {
        for (ChunkPos chunkPos : chunkPoses) {
            for (int cy = fastBlockAccess.minSectionY(); cy < fastBlockAccess.maxSectionYExclusive(); ++cy) {
                LevelChunkSection chunkSection = fastBlockAccess.getSection(chunkPos.x, cy, chunkPos.z);
                if (chunkSection == null || chunkSection.hasOnlyAir()) continue;
                int localYStart = Math.max(0, yRangeStart - cy * 16);
                int localYEnd = Math.min(16, yRangeEnd - cy * 16);
                for (int localY = localYStart; localY < localYEnd; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        for (int localX = 0; localX < 16; ++localX) {
                            int worldZ;
                            int worldY;
                            int worldX;
                            T result;
                            BlockState blockState = chunkSection.getBlockState(localX, localY, localZ);
                            if (!framePredicate.test(blockState) || (result = matchShape.searchAt(fastBlockAccess, worldX = localX + chunkPos.getMinBlockX(), worldY = localY + cy * 16, worldZ = localZ + chunkPos.getMinBlockZ())) == null) continue;
                            return result;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static List<ChunkPos> getChunksFromNearToFar(FastBlockAccess region, BlockPos centerPoint, int regionRadius) {
        return region.chunkPoses().sorted(Comparator.comparingDouble(chunk -> chunk.getWorldPosition().distSqr((Vec3i)centerPoint))).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface FrameSearchingFunc<T> {
        public T searchAt(FastBlockAccess var1, int var2, int var3, int var4);
    }
}

