/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.TriIntPredicate;

public record FastBlockPortalShape(int basePosX, int basePosY, int basePosZ, Direction.Axis axis, int[] localAreaBlockCoords, int[] localFrameWithoutCornerBlockCoords, int[] localFrameCornerBlockCoords, IntBox innerAreaBox, IntBox totalAreaBox) {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static int toLocalA(Direction.Axis axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> y;
            case Direction.Axis.Y -> x;
            case Direction.Axis.Z -> x;
        };
    }

    public static int toLocalB(Direction.Axis axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> z;
            case Direction.Axis.Y -> z;
            case Direction.Axis.Z -> y;
        };
    }

    public static int toWorldX(Direction.Axis axis, int coordOnAxis, int a, int b) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> coordOnAxis;
            case Direction.Axis.Y -> a;
            case Direction.Axis.Z -> a;
        };
    }

    public static int toWorldY(Direction.Axis axis, int coordOnAxis, int a, int b) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> a;
            case Direction.Axis.Y -> coordOnAxis;
            case Direction.Axis.Z -> b;
        };
    }

    public static int toWorldZ(Direction.Axis axis, int coordOnAxis, int a, int b) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> b;
            case Direction.Axis.Y -> b;
            case Direction.Axis.Z -> coordOnAxis;
        };
    }

    public static BlockPos toWorldBlockPos(Direction.Axis axis, int coordOnAxis, int a, int b) {
        return new BlockPos(FastBlockPortalShape.toWorldX(axis, coordOnAxis, a, b), FastBlockPortalShape.toWorldY(axis, coordOnAxis, a, b), FastBlockPortalShape.toWorldZ(axis, coordOnAxis, a, b));
    }

    public static long assemble(int a, int b) {
        return ChunkPos.asLong((int)a, (int)b);
    }

    public static int getAFromAssemble(long l) {
        return ChunkPos.getX((long)l);
    }

    public static int getBFromAssemble(long l) {
        return ChunkPos.getZ((long)l);
    }

    public static FastBlockPortalShape create(Direction.Axis axis, int[] areaBlockCoords, int coordOnAxis) {
        int b;
        int a;
        int i;
        Validate.isTrue((areaBlockCoords.length % 2 == 0 ? 1 : 0) != 0);
        Validate.isTrue((areaBlockCoords.length != 0 ? 1 : 0) != 0);
        int areaBlockNum = areaBlockCoords.length / 2;
        LongOpenHashSet area = new LongOpenHashSet();
        for (int i2 = 0; i2 < areaBlockNum; ++i2) {
            int a2 = areaBlockCoords[i2 * 2];
            int b2 = areaBlockCoords[i2 * 2 + 1];
            area.add(FastBlockPortalShape.assemble(a2, b2));
        }
        LongOpenHashSet frame = new LongOpenHashSet();
        LongOpenHashSet frameCorner = new LongOpenHashSet();
        for (i = 0; i < areaBlockNum; ++i) {
            a = areaBlockCoords[i * 2];
            b = areaBlockCoords[i * 2 + 1];
            if (!area.contains(FastBlockPortalShape.assemble(a + 1, b))) {
                frame.add(FastBlockPortalShape.assemble(a + 1, b));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a - 1, b))) {
                frame.add(FastBlockPortalShape.assemble(a - 1, b));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a, b + 1))) {
                frame.add(FastBlockPortalShape.assemble(a, b + 1));
            }
            if (area.contains(FastBlockPortalShape.assemble(a, b - 1))) continue;
            frame.add(FastBlockPortalShape.assemble(a, b - 1));
        }
        for (i = 0; i < areaBlockNum; ++i) {
            a = areaBlockCoords[i * 2];
            b = areaBlockCoords[i * 2 + 1];
            if (!area.contains(FastBlockPortalShape.assemble(a + 1, b + 1)) && !frame.contains(FastBlockPortalShape.assemble(a + 1, b + 1))) {
                frameCorner.add(FastBlockPortalShape.assemble(a + 1, b + 1));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a + 1, b - 1)) && !frame.contains(FastBlockPortalShape.assemble(a + 1, b - 1))) {
                frameCorner.add(FastBlockPortalShape.assemble(a + 1, b - 1));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a - 1, b + 1)) && !frame.contains(FastBlockPortalShape.assemble(a - 1, b + 1))) {
                frameCorner.add(FastBlockPortalShape.assemble(a - 1, b + 1));
            }
            if (area.contains(FastBlockPortalShape.assemble(a - 1, b - 1)) || frame.contains(FastBlockPortalShape.assemble(a - 1, b - 1))) continue;
            frameCorner.add(FastBlockPortalShape.assemble(a - 1, b - 1));
        }
        int minA = areaBlockCoords[0];
        int maxA = areaBlockCoords[0];
        int minB = areaBlockCoords[1];
        int maxB = areaBlockCoords[1];
        for (int i3 = 1; i3 < areaBlockNum; ++i3) {
            int a3 = areaBlockCoords[i3 * 2];
            int b3 = areaBlockCoords[i3 * 2 + 1];
            if (a3 < minA) {
                minA = a3;
            }
            if (a3 > maxA) {
                maxA = a3;
            }
            if (b3 < minB) {
                minB = b3;
            }
            if (b3 <= maxB) continue;
            maxB = b3;
        }
        IntBox innerAreaBox = new IntBox(FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, minA, minB), FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, maxA, maxB));
        IntBox totalAreaBox = new IntBox(FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, minA - 1, minB - 1), FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, maxA + 1, maxB + 1));
        long firstFramePosAssemble = frame.iterator().nextLong();
        int baseA = FastBlockPortalShape.getAFromAssemble(firstFramePosAssemble);
        int baseB = FastBlockPortalShape.getBFromAssemble(firstFramePosAssemble);
        BlockPos firstFramePos = FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, baseA, baseB);
        int[] localAreaBlockCoords = new int[areaBlockNum * 2];
        for (int i4 = 0; i4 < areaBlockNum; ++i4) {
            int a4 = areaBlockCoords[i4 * 2];
            int b4 = areaBlockCoords[i4 * 2 + 1];
            localAreaBlockCoords[i4 * 2] = a4 - baseA;
            localAreaBlockCoords[i4 * 2 + 1] = b4 - baseB;
        }
        int[] localFrameWithoutCornerBlockCoords = new int[frame.size() * 2];
        LongIterator framePosIter = frame.longIterator();
        for (int i5 = 0; i5 < frame.size(); ++i5) {
            long l = framePosIter.nextLong();
            int a5 = FastBlockPortalShape.getAFromAssemble(l);
            int b5 = FastBlockPortalShape.getBFromAssemble(l);
            localFrameWithoutCornerBlockCoords[i5 * 2] = a5 - baseA;
            localFrameWithoutCornerBlockCoords[i5 * 2 + 1] = b5 - baseB;
        }
        int[] localFrameCornerBlockCoords = new int[frameCorner.size() * 2];
        LongIterator frameCornerPosIter = frameCorner.longIterator();
        for (int i6 = 0; i6 < frameCorner.size(); ++i6) {
            long l = frameCornerPosIter.nextLong();
            int a6 = FastBlockPortalShape.getAFromAssemble(l);
            int b6 = FastBlockPortalShape.getBFromAssemble(l);
            localFrameCornerBlockCoords[i6 * 2] = a6 - baseA;
            localFrameCornerBlockCoords[i6 * 2 + 1] = b6 - baseB;
        }
        return new FastBlockPortalShape(firstFramePos.getX(), firstFramePos.getY(), firstFramePos.getZ(), axis, localAreaBlockCoords, localFrameWithoutCornerBlockCoords, localFrameCornerBlockCoords, innerAreaBox, totalAreaBox);
    }

    @Nullable
    public static FastBlockPortalShape fromTag(CompoundTag tag) {
        int axisInt = tag.getInt("axis");
        if (axisInt < 0 || axisInt > 2) {
            LOGGER.error("invalid axis {}", (Object)tag);
            return null;
        }
        Direction.Axis axis = Direction.Axis.values()[axisInt];
        ListTag positions = tag.getList("poses", 3);
        int numNum = positions.size();
        if (numNum == 0 || numNum % 3 != 0) {
            LOGGER.error("invalid poses tag {}", (Object)tag);
            return null;
        }
        int positionNum = numNum / 3;
        int firstPointX = positions.getInt(0);
        int firstPointY = positions.getInt(1);
        int firstPointZ = positions.getInt(2);
        IntArrayList areaBlockCoords = new IntArrayList();
        if (axis != Direction.Axis.X) {
            areaBlockCoords.add(firstPointX);
        }
        if (axis != Direction.Axis.Y) {
            areaBlockCoords.add(firstPointY);
        }
        if (axis != Direction.Axis.Z) {
            areaBlockCoords.add(firstPointZ);
        }
        int coordOnAxis = axis.choose(firstPointX, firstPointY, firstPointZ);
        for (int i = 1; i < positionNum; ++i) {
            int z;
            int y;
            int x = positions.getInt(i * 3);
            if (axis.choose(x, y = positions.getInt(i * 3 + 1), z = positions.getInt(i * 3 + 2)) != coordOnAxis) {
                LOGGER.error("invalid block position in {} at {}", (Object)tag, (Object)i);
                return null;
            }
            if (axis != Direction.Axis.X) {
                areaBlockCoords.add(x);
            }
            if (axis != Direction.Axis.Y) {
                areaBlockCoords.add(y);
            }
            if (axis == Direction.Axis.Z) continue;
            areaBlockCoords.add(z);
        }
        return FastBlockPortalShape.create(axis, areaBlockCoords.toIntArray(), coordOnAxis);
    }

    public CompoundTag toTag() {
        int coordOnAxis = this.axis.choose(this.basePosX, this.basePosY, this.basePosZ);
        CompoundTag tag = new CompoundTag();
        tag.putInt("axis", this.axis.ordinal());
        ListTag positions = new ListTag();
        for (int i = 0; i < this.localAreaBlockCoords.length / 2; ++i) {
            int a = this.localAreaBlockCoords[i * 2];
            int b = this.localAreaBlockCoords[i * 2 + 1];
            positions.add((Object)IntTag.valueOf((int)(FastBlockPortalShape.toWorldX(this.axis, 0, a, b) + this.basePosX)));
            positions.add((Object)IntTag.valueOf((int)(FastBlockPortalShape.toWorldY(this.axis, 0, a, b) + this.basePosY)));
            positions.add((Object)IntTag.valueOf((int)(FastBlockPortalShape.toWorldZ(this.axis, 0, a, b) + this.basePosZ)));
        }
        tag.put("poses", (Tag)positions);
        return tag;
    }

    public static FastBlockPortalShape fromBlockPortalShape(BlockPortalShape blockPortalShape) {
        return FastBlockPortalShape.fromTag(blockPortalShape.toTag());
    }

    public BlockPortalShape toBlockPortalShape() {
        return BlockPortalShape.fromTag(this.toTag());
    }

    public boolean matchShape(int newBaseX, int newBaseY, int newBaseZ, TriIntPredicate framePredicate, TriIntPredicate areaPredicate) {
        int z;
        int y;
        int x;
        int b;
        int a;
        for (int frameI = 0; frameI < this.localFrameWithoutCornerBlockCoords.length / 2; ++frameI) {
            a = this.localFrameWithoutCornerBlockCoords[frameI * 2];
            b = this.localFrameWithoutCornerBlockCoords[frameI * 2 + 1];
            x = FastBlockPortalShape.toWorldX(this.axis, 0, a, b) + newBaseX;
            if (framePredicate.test(x, y = FastBlockPortalShape.toWorldY(this.axis, 0, a, b) + newBaseY, z = FastBlockPortalShape.toWorldZ(this.axis, 0, a, b) + newBaseZ)) continue;
            return false;
        }
        for (int areaI = 0; areaI < this.localAreaBlockCoords.length / 2; ++areaI) {
            a = this.localAreaBlockCoords[areaI * 2];
            b = this.localAreaBlockCoords[areaI * 2 + 1];
            x = FastBlockPortalShape.toWorldX(this.axis, 0, a, b) + newBaseX;
            if (areaPredicate.test(x, y = FastBlockPortalShape.toWorldY(this.axis, 0, a, b) + newBaseY, z = FastBlockPortalShape.toWorldZ(this.axis, 0, a, b) + newBaseZ)) continue;
            return false;
        }
        return true;
    }

    public FastBlockPortalShape withNewBase(int newBaseX, int newBaseY, int newBaseZ) {
        return new FastBlockPortalShape(newBaseX, newBaseY, newBaseZ, this.axis, this.localAreaBlockCoords, this.localFrameWithoutCornerBlockCoords, this.localFrameCornerBlockCoords, this.innerAreaBox, this.totalAreaBox);
    }
}

