/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Mesh2D;

public class BlockPortalShape {
    public static int defaultLengthLimit = 64;
    public BlockPos anchor;
    public Set<BlockPos> area;
    public IntBox innerAreaBox;
    public IntBox totalAreaBox;
    public Direction.Axis axis;
    public Set<BlockPos> frameAreaWithoutCorner;
    public Set<BlockPos> frameAreaWithCorner;
    public BlockPos firstFramePos;

    public BlockPortalShape(Set<BlockPos> area, Direction.Axis axis) {
        this.area = area;
        this.axis = axis;
        this.calcAnchor();
        this.calcFrameArea();
        this.calcAreaBox();
    }

    public BlockPortalShape(CompoundTag tag) {
        this(BlockPortalShape.readArea(tag.getList("poses", 3)), Direction.Axis.values()[tag.getInt("axis")]);
    }

    private static Set<BlockPos> readArea(ListTag list) {
        int size = list.size();
        Validate.isTrue((size % 3 == 0 ? 1 : 0) != 0);
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int i = 0; i < size / 3; ++i) {
            result.add(new BlockPos(list.getInt(i * 3), list.getInt(i * 3 + 1), list.getInt(i * 3 + 2)));
        }
        return result;
    }

    public static BlockPortalShape fromTag(CompoundTag tag) {
        return new BlockPortalShape(tag);
    }

    public CompoundTag toTag() {
        CompoundTag data = new CompoundTag();
        ListTag list = new ListTag();
        this.area.forEach(blockPos -> {
            list.add(list.size(), (Tag)IntTag.valueOf((int)blockPos.getX()));
            list.add(list.size(), (Tag)IntTag.valueOf((int)blockPos.getY()));
            list.add(list.size(), (Tag)IntTag.valueOf((int)blockPos.getZ()));
        });
        data.put("poses", (Tag)list);
        data.putInt("axis", this.axis.ordinal());
        return data;
    }

    public void calcAnchor() {
        this.anchor = this.area.stream().min(Comparator.comparingInt(Vec3i::getX).thenComparingInt(Vec3i::getY).thenComparingInt(Vec3i::getZ)).get();
        Validate.notNull((Object)this.anchor);
    }

    public void calcAreaBox() {
        this.innerAreaBox = Helper.reduce(new IntBox(this.anchor, this.anchor), this.area.stream(), IntBox::getExpanded);
        this.totalAreaBox = Helper.reduce(new IntBox(this.anchor, this.anchor), this.frameAreaWithoutCorner.stream(), IntBox::getExpanded);
    }

    public void calcFrameArea() {
        Direction[] directions = Helper.getAnotherFourDirections(this.axis);
        this.frameAreaWithoutCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.offset(directions[0].getNormal()), blockPos.offset(directions[1].getNormal()), blockPos.offset(directions[2].getNormal()), blockPos.offset(directions[3].getNormal()))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        BlockPos[] cornerOffsets = new BlockPos[]{new BlockPos(directions[0].getNormal()).offset(directions[1].getNormal()), new BlockPos(directions[1].getNormal()).offset(directions[2].getNormal()), new BlockPos(directions[2].getNormal()).offset(directions[3].getNormal()), new BlockPos(directions[3].getNormal()).offset(directions[0].getNormal())};
        this.frameAreaWithCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.offset((Vec3i)cornerOffsets[0]), blockPos.offset((Vec3i)cornerOffsets[1]), blockPos.offset((Vec3i)cornerOffsets[2]), blockPos.offset((Vec3i)cornerOffsets[3]))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        this.frameAreaWithCorner.addAll(this.frameAreaWithoutCorner);
        this.firstFramePos = this.frameAreaWithoutCorner.iterator().next();
    }

    @Nullable
    public static BlockPortalShape findArea(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian) {
        return BlockPortalShape.findArea(startingPos, axis, isAir, isObsidian, defaultLengthLimit);
    }

    @Nullable
    public static BlockPortalShape findArea(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, int lengthLimit) {
        if (!isAir.test(startingPos)) {
            return null;
        }
        return BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, isAir, isObsidian, lengthLimit);
    }

    @Nullable
    public static BlockPortalShape findShapeWithoutRegardingStartingPos(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian) {
        return BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, isAir, isObsidian, defaultLengthLimit);
    }

    @Nullable
    private static BlockPortalShape findShapeWithoutRegardingStartingPos(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, int lengthLimit) {
        startingPos = startingPos.immutable();
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        area.add(startingPos);
        Direction[] directions = Helper.getAnotherFourDirections(axis);
        boolean isNormalFrame = BlockPortalShape.findAreaBreadthFirst(startingPos, isAir, isObsidian, directions, area, startingPos, lengthLimit);
        if (!isNormalFrame) {
            return null;
        }
        BlockPortalShape result = new BlockPortalShape(area, axis);
        BlockPos innerSize = result.innerAreaBox.getSize();
        if (innerSize.getX() > lengthLimit || innerSize.getY() > lengthLimit || innerSize.getZ() > lengthLimit) {
            return null;
        }
        return result;
    }

    private static boolean findAreaBreadthFirst(BlockPos startingPos, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, Direction[] directions, Set<BlockPos> foundArea, BlockPos initialPos, int lengthLimit) {
        ArrayDeque<BlockPos> newlyAdded = new ArrayDeque<BlockPos>();
        newlyAdded.addLast(startingPos);
        while (!newlyAdded.isEmpty()) {
            if (foundArea.size() > lengthLimit * lengthLimit) {
                return false;
            }
            BlockPos last = (BlockPos)newlyAdded.pollFirst();
            for (Direction direction : directions) {
                BlockPos curr = last.relative(direction).immutable();
                if (foundArea.contains(curr)) continue;
                if (isAir.test(curr)) {
                    newlyAdded.addLast(curr);
                    foundArea.add(curr);
                    continue;
                }
                if (isObsidian.test(curr)) continue;
                return false;
            }
            BlockPos delta = initialPos.subtract((Vec3i)startingPos);
            if (Math.abs(delta.getX()) <= lengthLimit && Math.abs(delta.getY()) <= lengthLimit && Math.abs(delta.getZ()) <= lengthLimit) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockPortalShape matchShape(Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, BlockPos newAnchor, BlockPos.MutableBlockPos temp) {
        if (!isAir.test(newAnchor)) {
            return null;
        }
        boolean testFrame = this.testFrameWithoutCorner(isObsidian, newAnchor, temp);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.set(blockPos.getX() - this.anchor.getX() + newAnchor.getX(), blockPos.getY() - this.anchor.getY() + newAnchor.getY(), blockPos.getZ() - this.anchor.getZ() + newAnchor.getZ())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        return this.getShapeWithMovedAnchor(newAnchor);
    }

    private boolean testFrameWithoutCorner(Predicate<BlockPos> isObsidian, BlockPos newAnchor, BlockPos.MutableBlockPos temp) {
        Function<BlockPos, BlockPos.MutableBlockPos> mapper = blockPos -> temp.set(blockPos.getX() - this.anchor.getX() + newAnchor.getX(), blockPos.getY() - this.anchor.getY() + newAnchor.getY(), blockPos.getZ() - this.anchor.getZ() + newAnchor.getZ());
        if (!isObsidian.test((BlockPos)mapper.apply(this.firstFramePos))) {
            return false;
        }
        return this.frameAreaWithoutCorner.stream().map(mapper).allMatch(isObsidian);
    }

    public BlockPortalShape getShapeWithMovedAnchor(BlockPos newAnchor) {
        BlockPos offset = newAnchor.subtract((Vec3i)this.anchor);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.offset((Vec3i)offset)).collect(Collectors.toSet()), this.axis);
    }

    public boolean isFrameIntact(Predicate<BlockPos> isObsidian) {
        return this.frameAreaWithoutCorner.stream().allMatch(isObsidian);
    }

    public boolean isPortalIntact(Predicate<BlockPos> isPortalBlock, Predicate<BlockPos> isObsidian) {
        return this.isFrameIntact(isObsidian) && this.area.stream().allMatch(isPortalBlock);
    }

    public void initPortalPosAxisShape(Portal portal, Direction.AxisDirection axisDirection) {
        Vec3 center = this.innerAreaBox.getCenterVec();
        portal.setPos(center.x, center.y, center.z);
        this.initPortalAxisShape(portal, center, Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)axisDirection));
    }

    public void initPortalAxisShape(Portal portal, Vec3 center, Direction facing) {
        Validate.isTrue((facing.getAxis() == this.axis ? 1 : 0) != 0);
        Tuple<Direction, Direction> perpendicularDirections = Helper.getPerpendicularDirections(facing);
        Direction wDirection = (Direction)perpendicularDirections.getA();
        Direction hDirection = (Direction)perpendicularDirections.getB();
        portal.setAxisW(Vec3.atLowerCornerOf((Vec3i)wDirection.getNormal()));
        portal.setAxisH(Vec3.atLowerCornerOf((Vec3i)hDirection.getNormal()));
        portal.setWidth(Helper.getCoordinate((Vec3i)this.innerAreaBox.getSize(), wDirection.getAxis()));
        portal.setHeight(Helper.getCoordinate((Vec3i)this.innerAreaBox.getSize(), hDirection.getAxis()));
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).getNormal()).scale(0.5);
        if (this.isRectangle()) {
            portal.setPortalShapeToDefault();
        } else {
            Mesh2D mesh2D = new Mesh2D();
            double halfWidth = portal.getWidth() / 2.0;
            double halfHeight = portal.getHeight() / 2.0;
            Vec3 axisW = portal.getAxisW();
            Vec3 axisH = portal.getAxisH();
            this.area.forEach(part -> {
                Vec3 p1 = Vec3.atLowerCornerOf((Vec3i)part).add(offset);
                Vec3 p2 = Vec3.atLowerCornerOf((Vec3i)part).add(1.0, 1.0, 1.0).add(offset);
                double p1LocalX = p1.subtract(center).dot(axisW);
                double p1LocalY = p1.subtract(center).dot(axisH);
                double p2LocalX = p2.subtract(center).dot(axisW);
                double p2LocalY = p2.subtract(center).dot(axisH);
                mesh2D.addQuad(p1LocalX / halfWidth, p1LocalY / halfHeight, p2LocalX / halfWidth, p2LocalY / halfHeight);
            });
            mesh2D.simplify();
            portal.setPortalShape(new SpecialFlatPortalShape(mesh2D));
        }
    }

    public BlockPortalShape matchShapeWithMovedFirstFramePos(Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, BlockPos newFirstObsidianPos, BlockPos.MutableBlockPos temp) {
        boolean testFrame = this.frameAreaWithoutCorner.stream().map(blockPos1 -> temp.set(blockPos1.getX() - this.firstFramePos.getX() + newFirstObsidianPos.getX(), blockPos1.getY() - this.firstFramePos.getY() + newFirstObsidianPos.getY(), blockPos1.getZ() - this.firstFramePos.getZ() + newFirstObsidianPos.getZ())).allMatch(isObsidian);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.set(blockPos.getX() - this.firstFramePos.getX() + newFirstObsidianPos.getX(), blockPos.getY() - this.firstFramePos.getY() + newFirstObsidianPos.getY(), blockPos.getZ() - this.firstFramePos.getZ() + newFirstObsidianPos.getZ())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        BlockPos offset = newFirstObsidianPos.subtract((Vec3i)this.firstFramePos);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.offset((Vec3i)offset)).collect(Collectors.toSet()), this.axis);
    }

    public static boolean isSquareShape(BlockPortalShape shape, int length) {
        Tuple<Direction.Axis, Direction.Axis> xs;
        BlockPos areaSize = shape.innerAreaBox.getSize();
        return Helper.getCoordinate((Vec3i)areaSize, (Direction.Axis)(xs = Helper.getAnotherTwoAxis(shape.axis)).getA()) == length && Helper.getCoordinate((Vec3i)areaSize, (Direction.Axis)xs.getB()) == length && shape.area.size() == length * length;
    }

    public static BlockPortalShape getSquareShapeTemplate(Direction.Axis axis, int length) {
        Tuple<Direction, Direction> perpendicularDirections = Helper.getPerpendicularDirections(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                area.add(BlockPos.ZERO.relative((Direction)perpendicularDirections.getA(), i).relative((Direction)perpendicularDirections.getB(), j));
            }
        }
        return new BlockPortalShape(area, axis);
    }

    public BlockPortalShape getShapeWithMovedTotalAreaBox(IntBox newTotalAreaBox) {
        Validate.isTrue((boolean)this.totalAreaBox.getSize().equals((Object)newTotalAreaBox.getSize()));
        return this.getShapeWithMovedAnchor(newTotalAreaBox.l.subtract((Vec3i)this.totalAreaBox.l).offset((Vec3i)this.anchor));
    }

    public int getShapeInnerLength() {
        BlockPos size = this.innerAreaBox.getSize();
        return Math.max(size.getX(), Math.max(size.getY(), size.getZ()));
    }

    public boolean isRectangle() {
        BlockPos size = this.innerAreaBox.getSize();
        return size.getX() * size.getY() * size.getZ() == this.area.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPortalShape that = (BlockPortalShape)o;
        return this.area.equals(that.area) && this.axis == that.axis;
    }

    public int hashCode() {
        return Objects.hash(this.area, this.axis);
    }
}

