/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class VerticalConnectingPortal
extends GlobalTrackedPortal {
    public static final EntityType<VerticalConnectingPortal> ENTITY_TYPE = VerticalConnectingPortal.createPortalEntityType(VerticalConnectingPortal::new);

    private static Predicate<Portal> getPredicate(ConnectorType connectorType) {
        switch (connectorType.ordinal()) {
            case 1: {
                return portal -> portal instanceof VerticalConnectingPortal && portal.getNormal().y > 0.0;
            }
        }
        return portal -> portal instanceof VerticalConnectingPortal && portal.getNormal().y < 0.0;
    }

    public VerticalConnectingPortal(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    public static void connect(ResourceKey<Level> from, ConnectorType connectorType, ResourceKey<Level> to) {
        VerticalConnectingPortal.connect(from, connectorType, to, false);
    }

    public static void connect(ResourceKey<Level> from, ConnectorType connectorType, ResourceKey<Level> to, boolean respectSpaceRatio) {
        VerticalConnectingPortal.removeConnectingPortal(connectorType, from);
        ServerLevel fromWorld = MiscHelper.getServer().getLevel(from);
        ServerLevel toWorld = MiscHelper.getServer().getLevel(to);
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal(fromWorld, connectorType, toWorld, respectSpaceRatio ? fromWorld.dimensionType().coordinateScale() / toWorld.dimensionType().coordinateScale() : 1.0, false, 0.0, McHelper.getMinY((LevelAccessor)fromWorld), McHelper.getMaxContentYExclusive((LevelAccessor)fromWorld), McHelper.getMinY((LevelAccessor)toWorld), McHelper.getMaxContentYExclusive((LevelAccessor)toWorld));
        GlobalPortalStorage storage = GlobalPortalStorage.get(fromWorld);
        storage.addPortal(connectingPortal);
    }

    public static void connectMutually(ResourceKey<Level> up, ResourceKey<Level> down, boolean respectSpaceRatio) {
        VerticalConnectingPortal.connect(up, ConnectorType.floor, down, respectSpaceRatio);
        VerticalConnectingPortal.connect(down, ConnectorType.ceil, up, respectSpaceRatio);
    }

    public static VerticalConnectingPortal createConnectingPortal(ServerLevel fromWorld, ConnectorType connectorType, ServerLevel toWorld, double scaling, boolean inverted, double rotationAlongYDegrees, int fromWorldMinY, int fromWorldMaxY, int toWorldMinY, int toWorldMaxY) {
        VerticalConnectingPortal verticalConnectingPortal = new VerticalConnectingPortal(ENTITY_TYPE, (Level)fromWorld);
        verticalConnectingPortal.setDestDim((ResourceKey<Level>)toWorld.dimension());
        verticalConnectingPortal.setWidth(2.3333333333E10);
        verticalConnectingPortal.setHeight(2.3333333333E10);
        switch (connectorType.ordinal()) {
            case 1: {
                verticalConnectingPortal.setPos(0.0, fromWorldMinY, 0.0);
                verticalConnectingPortal.setAxisW(new Vec3(0.0, 0.0, 1.0));
                verticalConnectingPortal.setAxisH(new Vec3(1.0, 0.0, 0.0));
                break;
            }
            case 0: {
                verticalConnectingPortal.setPos(0.0, fromWorldMaxY, 0.0);
                verticalConnectingPortal.setAxisW(new Vec3(1.0, 0.0, 0.0));
                verticalConnectingPortal.setAxisH(new Vec3(0.0, 0.0, 1.0));
            }
        }
        if (!inverted) {
            switch (connectorType.ordinal()) {
                case 1: {
                    verticalConnectingPortal.setDestination(new Vec3(0.0, (double)toWorldMaxY, 0.0));
                    break;
                }
                case 0: {
                    verticalConnectingPortal.setDestination(new Vec3(0.0, (double)toWorldMinY, 0.0));
                }
            }
        } else {
            switch (connectorType.ordinal()) {
                case 1: {
                    verticalConnectingPortal.setDestination(new Vec3(0.0, (double)toWorldMinY, 0.0));
                    break;
                }
                case 0: {
                    verticalConnectingPortal.setDestination(new Vec3(0.0, (double)toWorldMaxY, 0.0));
                }
            }
        }
        DQuaternion inversionRotation = inverted ? DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), 180.0) : null;
        DQuaternion additionalRotation = rotationAlongYDegrees != 0.0 ? DQuaternion.rotationByDegrees(new Vec3(0.0, 1.0, 0.0), rotationAlongYDegrees) : null;
        DQuaternion rotation = Helper.combineNullable(inversionRotation, additionalRotation, DQuaternion::hamiltonProduct);
        verticalConnectingPortal.setRotation(rotation);
        if (scaling != 1.0) {
            verticalConnectingPortal.setScaling(scaling);
            verticalConnectingPortal.setTeleportChangesScale(false);
            PortalExtension.get((Portal)verticalConnectingPortal).adjustPositionAfterTeleport = false;
        }
        return verticalConnectingPortal;
    }

    public static void removeConnectingPortal(ConnectorType connectorType, ResourceKey<Level> dimension) {
        VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.getPredicate(connectorType), dimension);
    }

    private static void removeConnectingPortal(Predicate<Portal> predicate, ResourceKey<Level> dimension) {
        ServerLevel endWorld = MiscHelper.getServer().getLevel(dimension);
        GlobalPortalStorage storage = GlobalPortalStorage.get(endWorld);
        storage.removePortals(portal -> portal instanceof VerticalConnectingPortal && predicate.test((Portal)portal));
    }

    public static VerticalConnectingPortal getConnectingPortal(Level world, ConnectorType type) {
        return GlobalPortalStorage.getGlobalPortals(world).stream().filter(VerticalConnectingPortal.getPredicate(type)).findFirst().orElse(null);
    }

    public static enum ConnectorType {
        ceil,
        floor;

    }
}

