/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.Helper;

public final class GlobalPortalStorageClient {
    private GlobalPortalStorageClient() {
    }

    public static void onClientCleanup() {
        if (ClientWorldLoader.getIsInitialized()) {
            for (ClientLevel clientWorld : ClientWorldLoader.getClientWorlds()) {
                for (Portal globalPortal : GlobalPortalStorage.getGlobalPortals((Level)clientWorld)) {
                    globalPortal.remove(Entity.RemovalReason.UNLOADED_TO_CHUNK);
                }
            }
        }
    }

    public static void receiveGlobalPortalSync(ResourceKey<Level> dimension, CompoundTag compoundTag) {
        ClientLevel world = ClientWorldLoader.getWorld(dimension);
        List<Portal> oldGlobalPortals = ((IEClientWorld)world).ip_getGlobalPortals();
        if (oldGlobalPortals != null) {
            for (Portal p : oldGlobalPortals) {
                p.remove(Entity.RemovalReason.KILLED);
            }
        }
        List<Portal> newPortals = GlobalPortalStorage.getPortalsFromTag(compoundTag, (Level)world);
        for (Portal p : newPortals) {
            p.myUnsetRemoved();
            p.isGlobalPortal = true;
            Validate.isTrue((boolean)p.isPortalValid());
            ClientWorldLoader.getWorld(p.getDestDim());
        }
        ((IEClientWorld)world).ip_setGlobalPortals(newPortals);
        Helper.log("Global Portals Updated " + String.valueOf(dimension.location()));
    }
}

