/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.ClientCleanupEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorageClient;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class GlobalPortalStorage
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public List<Portal> data;
    public final WeakReference<ServerLevel> world;
    private int version = 1;
    private boolean shouldReSync = false;
    @Nullable
    public BlockState bedrockReplacement;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> event.getServer().getAllLevels().forEach(world1 -> {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world1);
            gps.tick();
        }));
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> {
            MinecraftServer s = event.getServer();
            for (ServerLevel world : s.getAllLevels()) {
                GlobalPortalStorage.get(world).onServerClose();
            }
        });
        if (!O_O.isDedicatedServer()) {
            GlobalPortalStorage.initClient();
        }
    }

    public static GlobalPortalStorage get(ServerLevel world) {
        return (GlobalPortalStorage)world.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> {
            LOGGER.info("Global portal storage initialized {}", (Object)world.dimension().location());
            return new GlobalPortalStorage(world);
        }, (nbt, holderLookup) -> {
            GlobalPortalStorage globalPortalStorage = new GlobalPortalStorage(world);
            globalPortalStorage.fromNbt((CompoundTag)nbt);
            return globalPortalStorage;
        }, null), "global_portal");
    }

    private static void initClient() {
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> GlobalPortalStorageClient.onClientCleanup());
    }

    public GlobalPortalStorage(ServerLevel world_) {
        this.world = new WeakReference<ServerLevel>(world_);
        this.data = new ArrayList<Portal>();
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        MiscHelper.getServer().getAllLevels().forEach(world -> {
            GlobalPortalStorage storage = GlobalPortalStorage.get(world);
            if (!storage.data.isEmpty()) {
                Packet<ClientCommonPacketListener> packet = GlobalPortalStorage.createSyncPacket(world, storage);
                player.connection.send(packet);
            }
        });
    }

    public static Packet<ClientCommonPacketListener> createSyncPacket(ServerLevel world, GlobalPortalStorage storage) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new ImmPtlNetworking.GlobalPortalSyncPacket(PortalAPI.serverDimKeyToInt(world.getServer(), (ResourceKey<Level>)world.dimension()), storage.save(new CompoundTag(), (HolderLookup.Provider)world.registryAccess())));
    }

    public void onDataChanged() {
        this.setDirty(true);
        this.shouldReSync = true;
    }

    public void removePortal(Portal portal) {
        this.data.remove(portal);
        portal.remove(Entity.RemovalReason.KILLED);
        this.onDataChanged();
    }

    public void addPortal(Portal portal) {
        Validate.isTrue((!this.data.contains(portal) ? 1 : 0) != 0);
        Validate.isTrue((boolean)portal.isPortalValid());
        portal.isGlobalPortal = true;
        portal.myUnsetRemoved();
        this.data.add(portal);
        this.onDataChanged();
    }

    public void removePortals(Predicate<Portal> predicate) {
        this.data.removeIf(portal -> {
            boolean shouldRemove = predicate.test((Portal)portal);
            if (shouldRemove) {
                portal.remove(Entity.RemovalReason.KILLED);
            }
            return shouldRemove;
        });
        this.onDataChanged();
    }

    private void syncToAllPlayers() {
        ServerLevel currWorld = (ServerLevel)this.world.get();
        Validate.notNull((Object)currWorld);
        Packet<ClientCommonPacketListener> packet = GlobalPortalStorage.createSyncPacket(currWorld, this);
        McHelper.getRawPlayerList().forEach(player -> player.connection.send(packet));
    }

    public void fromNbt(CompoundTag tag) {
        ServerLevel currWorld = (ServerLevel)this.world.get();
        Validate.notNull((Object)currWorld, (String)"world is null", (Object[])new Object[0]);
        List<Portal> newData = GlobalPortalStorage.getPortalsFromTag(tag, (Level)currWorld);
        this.data = newData;
        if (tag.contains("version")) {
            this.version = tag.getInt("version");
        }
        this.bedrockReplacement = tag.contains("bedrockReplacement") ? NbtUtils.readBlockState((HolderGetter)currWorld.holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("bedrockReplacement")) : null;
        this.clearAbnormalPortals(currWorld.getServer());
    }

    static List<Portal> getPortalsFromTag(CompoundTag tag, Level currWorld) {
        ListTag listTag = tag.getList("data", 10);
        ArrayList<Portal> newData = new ArrayList<Portal>();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompound(i);
            Portal e = GlobalPortalStorage.readPortalFromTag(currWorld, compoundTag);
            if (e != null) {
                newData.add(e);
                continue;
            }
            Helper.err("error reading portal" + String.valueOf(compoundTag));
        }
        return newData;
    }

    private static Portal readPortalFromTag(Level currWorld, CompoundTag compoundTag) {
        ResourceLocation entityId = McHelper.newResourceLocation(compoundTag.getString("entity_type"));
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
        Entity e = entityType.create(currWorld);
        e.load(compoundTag);
        ((Portal)e).isGlobalPortal = true;
        ((Portal)e).updateCache();
        return (Portal)e;
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.data == null) {
            return tag;
        }
        ListTag listTag = new ListTag();
        ServerLevel currWorld = (ServerLevel)this.world.get();
        Validate.notNull((Object)currWorld, (String)"world is null", (Object[])new Object[0]);
        for (Portal portal : this.data) {
            Validate.isTrue((portal.level() == currWorld ? 1 : 0) != 0);
            CompoundTag portalTag = new CompoundTag();
            portal.saveWithoutId(portalTag);
            portalTag.putString("entity_type", EntityType.getKey((EntityType)portal.getType()).toString());
            listTag.add((Object)portalTag);
        }
        tag.put("data", (Tag)listTag);
        tag.putInt("version", this.version);
        if (this.bedrockReplacement != null) {
            tag.put("bedrockReplacement", (Tag)NbtUtils.writeBlockState((BlockState)this.bedrockReplacement));
        }
        return tag;
    }

    public void tick() {
        if (this.shouldReSync) {
            this.syncToAllPlayers();
            this.shouldReSync = false;
        }
        if (this.version <= 1) {
            GlobalPortalStorage.upgradeData((ServerLevel)this.world.get());
            this.version = 2;
            this.setDirty(true);
        }
    }

    public void clearAbnormalPortals(MinecraftServer server) {
        this.data.removeIf(e -> {
            ResourceKey<Level> dimensionTo = e.getDestDim();
            if (server.getLevel(dimensionTo) == null) {
                LOGGER.error("Missing Dimension for global portal {}", (Object)dimensionTo.location());
                return true;
            }
            return false;
        });
    }

    private static void upgradeData(ServerLevel world) {
    }

    public static void convertNormalPortalIntoGlobalPortal(Portal portal) {
        Validate.isTrue((!portal.getIsGlobal() ? 1 : 0) != 0);
        Validate.isTrue((!portal.level().isClientSide() ? 1 : 0) != 0);
        portal.setPortalShapeToDefault();
        portal.remove(Entity.RemovalReason.KILLED);
        Portal newPortal = McHelper.copyEntity(portal);
        GlobalPortalStorage.get((ServerLevel)portal.level()).addPortal(newPortal);
    }

    public static void convertGlobalPortalIntoNormalPortal(Portal portal) {
        Validate.isTrue((boolean)portal.getIsGlobal());
        Validate.isTrue((!portal.level().isClientSide() ? 1 : 0) != 0);
        GlobalPortalStorage.get((ServerLevel)portal.level()).removePortal(portal);
        Portal newPortal = McHelper.copyEntity(portal);
        McHelper.spawnServerEntity(newPortal);
    }

    private void onServerClose() {
        for (Portal portal : this.data) {
            portal.remove(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        }
    }

    @NotNull
    public static List<Portal> getGlobalPortals(Level world) {
        List<Portal> result = world.isClientSide() ? CHelper.getClientGlobalPortal(world) : (world instanceof ServerLevel ? GlobalPortalStorage.get((ServerLevel)((ServerLevel)world)).data : null);
        return result != null ? result : Collections.emptyList();
    }
}

