/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class FlippingFloorSquareForm
extends PortalGenForm {
    public static final Codec<List<Block>> blockListCodec = BuiltInRegistries.BLOCK.byNameCodec().listOf();
    public static final MapCodec<FlippingFloorSquareForm> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("length").forGetter(o -> o.length), (App)SimpleBlockPredicate.CODEC.fieldOf("frame_block").forGetter(o -> o.frameBlock), (App)SimpleBlockPredicate.CODEC.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)SimpleBlockPredicate.CODEC.optionalFieldOf("up_frame_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.upFrameBlock), (App)SimpleBlockPredicate.CODEC.optionalFieldOf("bottom_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.bottomBlock)).apply((Applicative)instance, instance.stable(FlippingFloorSquareForm::new)));
    public final int length;
    public final SimpleBlockPredicate frameBlock;
    public final SimpleBlockPredicate areaBlock;
    public final SimpleBlockPredicate upFrameBlock;
    public final SimpleBlockPredicate bottomBlock;

    public FlippingFloorSquareForm(int length, SimpleBlockPredicate frameBlock, SimpleBlockPredicate areaBlock, SimpleBlockPredicate upFrameBlock, SimpleBlockPredicate bottomBlock) {
        this.length = length;
        this.frameBlock = frameBlock;
        this.areaBlock = areaBlock;
        this.upFrameBlock = upFrameBlock;
        this.bottomBlock = bottomBlock;
    }

    @Override
    public MapCodec<? extends PortalGenForm> getCodec() {
        return CODEC;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerLevel fromWorld, BlockPos startingPos, ServerLevel toWorld, @Nullable Entity triggeringEntity) {
        SimpleBlockPredicate areaPredicate = this.areaBlock;
        SimpleBlockPredicate framePredicate = this.frameBlock;
        SimpleBlockPredicate bottomPredicate = this.bottomBlock;
        if (!areaPredicate.test(fromWorld.getBlockState(startingPos))) {
            return false;
        }
        if (!bottomPredicate.test(fromWorld.getBlockState(startingPos.below()))) {
            return false;
        }
        BlockPortalShape fromShape = BlockPortalShape.findArea(startingPos, Direction.Axis.Y, blockPos -> areaPredicate.test(fromWorld.getBlockState(blockPos)), blockPos -> framePredicate.test(fromWorld.getBlockState(blockPos)));
        if (fromShape == null) {
            return false;
        }
        if (!this.checkFromShape(fromWorld, fromShape)) {
            return false;
        }
        BlockPos areaSize = fromShape.innerAreaBox.getSize();
        BlockPos toPos = cpg.mapPosition(fromShape.innerAreaBox.l, fromWorld, toWorld);
        IntBox placingBox = FlippingFloorSquareForm.findPortalPlacement(toWorld, areaSize, toPos);
        BlockPos offset = placingBox.l.subtract((Vec3i)fromShape.innerAreaBox.l);
        BlockPortalShape toShape = fromShape.getShapeWithMovedAnchor(fromShape.anchor.offset((Vec3i)offset));
        fromShape.frameAreaWithoutCorner.forEach(fromWorldPos -> {
            BlockPos toWorldPos = fromWorldPos.offset((Vec3i)offset);
            toWorld.setBlockAndUpdate(toWorldPos, fromWorld.getBlockState(fromWorldPos));
            toWorld.setBlockAndUpdate(toWorldPos.above(), fromWorld.getBlockState(fromWorldPos.above()));
        });
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, toShape);
        Portal[] portals = FlippingFloorSquareForm.createPortals(fromWorld, toWorld, fromShape, toShape);
        cpg.onPortalsGenerated(portals);
        return true;
    }

    public boolean checkFromShape(ServerLevel fromWorld, BlockPortalShape fromShape) {
        boolean areaSizeTest = BlockPortalShape.isSquareShape(fromShape, this.length);
        if (!areaSizeTest) {
            return false;
        }
        return fromShape.frameAreaWithoutCorner.stream().allMatch(blockPos -> this.upFrameBlock.test(fromWorld.getBlockState(blockPos.above()))) && fromShape.area.stream().allMatch(blockPos -> this.bottomBlock.test(fromWorld.getBlockState(blockPos.below())));
    }

    public static IntBox findPortalPlacement(ServerLevel toWorld, BlockPos areaSize, BlockPos toPos) {
        return IntStream.range(toPos.getX() - 8, toPos.getX() + 8).boxed().flatMap(x -> IntStream.range(toPos.getZ() - 8, toPos.getZ() + 8).boxed().flatMap(z -> IntStream.range(McHelper.getMinY((LevelAccessor)toWorld) + 5, McHelper.getMaxContentYExclusive((LevelAccessor)toWorld) - 5).map(y -> McHelper.getMaxContentYExclusive((LevelAccessor)toWorld) - y).mapToObj(y -> new BlockPos(x.intValue(), y, z.intValue())))).map(blockPos -> IntBox.fromBasePointAndSize(blockPos, areaSize)).filter(intBox -> intBox.stream().allMatch(pos -> {
            BlockState blockState = toWorld.getBlockState(pos);
            return !blockState.isSolidRender((BlockGetter)toWorld, pos) && blockState.getBlock() != PortalPlaceholderBlock.instance && blockState.getFluidState().isEmpty();
        })).filter(intBox -> intBox.getSurfaceLayer(Direction.DOWN).getMoved(Direction.DOWN.getNormal()).stream().allMatch(blockPos -> {
            BlockState blockState = toWorld.getBlockState(blockPos);
            return !blockState.isAir() && blockState.getBlock() != PortalPlaceholderBlock.instance;
        })).findFirst().orElseGet(() -> IntBox.fromBasePointAndSize(toPos, areaSize)).getMoved(Direction.DOWN.getNormal());
    }

    public static GeneralBreakablePortal[] createPortals(ServerLevel fromWorld, ServerLevel toWorld, BlockPortalShape fromShape, BlockPortalShape toShape) {
        GeneralBreakablePortal pa = (GeneralBreakablePortal)GeneralBreakablePortal.ENTITY_TYPE.create((Level)fromWorld);
        fromShape.initPortalPosAxisShape(pa, Direction.AxisDirection.POSITIVE);
        pa.setDestination(toShape.innerAreaBox.getCenterVec());
        pa.setDestDim((ResourceKey<Level>)toWorld.dimension());
        pa.setRotation(DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), 180.0));
        GeneralBreakablePortal pb = PortalManipulation.createReversePortal(pa, GeneralBreakablePortal.ENTITY_TYPE);
        pa.blockPortalShape = fromShape;
        pb.blockPortalShape = toShape;
        pa.reversePortalId = pb.getUUID();
        pb.reversePortalId = pa.getUUID();
        PortalExtension.get((Portal)pa).motionAffinity = 0.1;
        PortalExtension.get((Portal)pb).motionAffinity = 0.1;
        McHelper.spawnServerEntity(pa);
        McHelper.spawnServerEntity(pb);
        return new GeneralBreakablePortal[]{pa, pb};
    }
}

