/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.DiligentMatcher;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.FrameSearching;

public abstract class AbstractDiligentForm
extends NetherPortalLikeForm {
    public AbstractDiligentForm(boolean generateFrameIfNotFound) {
        super(generateFrameIfNotFound);
    }

    @Override
    public FrameSearching.FrameSearchingFunc<PortalGenInfo> getFrameMatchingFunc(ServerLevel fromWorld, ServerLevel toWorld, BlockPortalShape fromShape) {
        List<DiligentMatcher.TransformedShape> matchableShapeVariants = DiligentMatcher.getMatchableShapeVariants(fromShape, BlockPortalShape.defaultLengthLimit);
        Predicate<BlockState> areaPredicate = this.getAreaPredicate();
        Predicate<BlockState> otherSideFramePredicate = this.getOtherSideFramePredicate();
        BlockPos.MutableBlockPos temp2 = new BlockPos.MutableBlockPos();
        return (region, x, y, z) -> {
            BlockPos blockPos = new BlockPos(x, y, z);
            for (DiligentMatcher.TransformedShape matchableShapeVariant : matchableShapeVariants) {
                BlockPortalShape template = matchableShapeVariant.transformedShape;
                BlockPortalShape matched = template.matchShapeWithMovedFirstFramePos(pos -> areaPredicate.test(region.getBlockState(pos.getX(), pos.getY(), pos.getZ())), pos -> otherSideFramePredicate.test(region.getBlockState(pos.getX(), pos.getY(), pos.getZ())), blockPos, temp2);
                if (matched == null || fromWorld == toWorld && fromShape.anchor.equals((Object)matched.anchor)) continue;
                return new PortalGenInfo((ResourceKey<Level>)fromWorld.dimension(), (ResourceKey<Level>)toWorld.dimension(), fromShape, matched, matchableShapeVariant.rotation.toQuaternion(), matchableShapeVariant.scale);
            }
            return null;
        };
    }
}

