/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockPredicate
implements Predicate<BlockState> {
    public static final SimpleBlockPredicate pass = new SimpleBlockPredicate();
    public final String name;
    @Nullable
    private final TagKey<Block> tag;
    @Nullable
    private final Holder<Block> blockHolder;
    public static final Codec<SimpleBlockPredicate> CODEC = new SimpleBlockPredicateCodec();

    public SimpleBlockPredicate(String name, @NotNull TagKey<Block> tag) {
        this.name = name;
        this.tag = tag;
        this.blockHolder = null;
    }

    public SimpleBlockPredicate(String name, @NotNull Holder<Block> blockHolder) {
        this.name = name;
        this.blockHolder = blockHolder;
        this.tag = null;
    }

    private SimpleBlockPredicate() {
        this.tag = null;
        this.blockHolder = null;
        this.name = "imm_ptl:pass";
    }

    @Override
    public boolean test(BlockState blockState) {
        if (this.tag != null) {
            return blockState.is(this.tag);
        }
        if (this.blockHolder != null) {
            return blockState.getBlock() == this.blockHolder.value();
        }
        return true;
    }

    private static class SimpleBlockPredicateCodec
    implements Codec<SimpleBlockPredicate> {
        private SimpleBlockPredicateCodec() {
        }

        public <T> DataResult<Pair<SimpleBlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
            if (!(ops instanceof RegistryOps)) {
                return DataResult.error(() -> "To deserialize SimpleBlockPredicate, the DynamicOps must be RegistryOps");
            }
            RegistryOps registryOps = (RegistryOps)ops;
            DataResult stringValue = ops.getStringValue(input);
            if (stringValue.result().isEmpty()) {
                return DataResult.error(() -> "SimpleBlockPredicate should be string");
            }
            String str = (String)stringValue.result().get();
            Optional optionalGetter = registryOps.getter(Registries.BLOCK);
            if (optionalGetter.isEmpty()) {
                return DataResult.error(() -> "Missing block registry");
            }
            HolderGetter getter = (HolderGetter)optionalGetter.get();
            if (str.startsWith("#")) {
                String blockTagIdStr = str.substring(1);
                DataResult bockTagRl = ResourceLocation.read((String)blockTagIdStr);
                if (bockTagRl.result().isEmpty()) {
                    return DataResult.error(() -> "Invalid block tag intId:" + blockTagIdStr);
                }
                ResourceLocation resourceLocation = (ResourceLocation)bockTagRl.result().get();
                TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
                return DataResult.success((Object)Pair.of((Object)new SimpleBlockPredicate(str, (TagKey<Block>)tagKey), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
            }
            DataResult rl = ResourceLocation.read((String)str);
            if (rl.result().isEmpty()) {
                return DataResult.error(() -> "Invalid resource location:" + str);
            }
            ResourceLocation resourceLocation = (ResourceLocation)rl.result().get();
            if (resourceLocation.toString().equals("minecraft:air")) {
                return DataResult.success((Object)Pair.of((Object)new AirPredicate(), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
            }
            Optional blockRef = getter.get(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation));
            if (blockRef.isEmpty()) {
                TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
                return DataResult.success((Object)Pair.of((Object)new SimpleBlockPredicate(str, (TagKey<Block>)tagKey), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
            }
            return DataResult.success((Object)Pair.of((Object)new SimpleBlockPredicate(str, (Holder<Block>)((Holder)blockRef.get())), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
        }

        public <T> DataResult<T> encode(SimpleBlockPredicate input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)ops.createString(input.name), (Lifecycle)Lifecycle.stable());
        }
    }

    public static class AirPredicate
    extends SimpleBlockPredicate {
        public AirPredicate() {
            super("minecraft:air", (Holder<Block>)Blocks.AIR.builtInRegistryHolder());
        }

        @Override
        public boolean test(BlockState blockState) {
            return blockState.isAir();
        }
    }
}

