/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import qouteall.imm_ptl.core.McHelper;

public abstract class PortalGenTrigger {
    public static final Codec<PortalGenTrigger> triggerCodec;
    public static final Registry<MapCodec<? extends PortalGenTrigger>> codecRegistry;
    public static final MapCodec<UseItemTrigger> useItemTriggerCodec;
    public static final MapCodec<ThrowItemTrigger> throwItemTriggerCodec;
    public static final MapCodec<ConventionalDimensionChangeTrigger> conventionalDimensionChangeCodec;

    public abstract MapCodec<? extends PortalGenTrigger> getCodec();

    static {
        useItemTriggerCodec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(o -> o.item), (App)Codec.BOOL.optionalFieldOf("consume", (Object)false).forGetter(o -> o.consume)).apply((Applicative)instance, instance.stable(UseItemTrigger::new)));
        throwItemTriggerCodec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(o -> o.item)).apply((Applicative)instance, instance.stable(ThrowItemTrigger::new)));
        conventionalDimensionChangeCodec = MapCodec.unit(ConventionalDimensionChangeTrigger::new);
        codecRegistry = new MappedRegistry(ResourceKey.createRegistryKey((ResourceLocation)McHelper.newResourceLocation("imm_ptl:custom_portal_gen_trigger")), Lifecycle.stable());
        Registry.register(codecRegistry, (ResourceLocation)McHelper.newResourceLocation("imm_ptl:use_item"), useItemTriggerCodec);
        Registry.register(codecRegistry, (ResourceLocation)McHelper.newResourceLocation("imm_ptl:throw_item"), throwItemTriggerCodec);
        Registry.register(codecRegistry, (ResourceLocation)McHelper.newResourceLocation("imm_ptl:conventional_dimension_change"), (Object)ConventionalDimensionChangeTrigger.conventionalDimensionChangeCodec);
        triggerCodec = codecRegistry.byNameCodec().dispatchStable(PortalGenTrigger::getCodec, Function.identity());
    }

    public static class ThrowItemTrigger
    extends PortalGenTrigger {
        public final Item item;

        public ThrowItemTrigger(Item item) {
            this.item = item;
        }

        @Override
        public MapCodec<? extends PortalGenTrigger> getCodec() {
            return throwItemTriggerCodec;
        }
    }

    public static class UseItemTrigger
    extends PortalGenTrigger {
        public final Item item;
        public final boolean consume;

        public UseItemTrigger(Item item, boolean consume) {
            this.item = item;
            this.consume = consume;
        }

        public boolean shouldConsume(UseOnContext context) {
            if (!this.consume) {
                return false;
            }
            Player player = context.getPlayer();
            if (player != null) {
                return !player.isCreative();
            }
            return true;
        }

        @Override
        public MapCodec<? extends PortalGenTrigger> getCodec() {
            return useItemTriggerCodec;
        }
    }

    public static class ConventionalDimensionChangeTrigger
    extends PortalGenTrigger {
        @Override
        public MapCodec<? extends PortalGenTrigger> getCodec() {
            return conventionalDimensionChangeCodec;
        }
    }
}

