/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class CustomPortalGeneration {
    public static final ResourceKey<Level> THE_SAME_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)McHelper.newResourceLocation("imm_ptl:the_same_dimension"));
    public static final ResourceKey<Level> ANY_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)McHelper.newResourceLocation("imm_ptl:any_dimension"));
    public static final Codec<List<ResourceKey<Level>>> DIMENSION_LIST_CODEC = Level.RESOURCE_KEY_CODEC.listOf();
    public static final Codec<List<String>> STRING_LIST_CODEC = Codec.STRING.listOf();
    public static final Codec<List<List<String>>> STRING_LIST_LIST_CODEC = STRING_LIST_CODEC.listOf();
    public static final ResourceKey<Registry<MapCodec<CustomPortalGeneration>>> SCHEMA_KEY = ResourceKey.createRegistryKey((ResourceLocation)McHelper.newResourceLocation("imm_ptl:custom_portal_gen_schema"));
    public static final ResourceKey<Registry<CustomPortalGeneration>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)McHelper.newResourceLocation("immersive_portals:custom_portal_generation"));
    public static final ResourceKey<Registry<CustomPortalGeneration>> LEGACY_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)McHelper.newResourceLocation("custom_portal_generation"));
    public static final MapCodec<CustomPortalGeneration> codecV1 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DIMENSION_LIST_CODEC.fieldOf("from").forGetter(o -> o.fromDimensions), (App)Level.RESOURCE_KEY_CODEC.fieldOf("to").forGetter(o -> o.toDimension), (App)Codec.INT.optionalFieldOf("space_ratio_from", (Object)1).forGetter(o -> o.spaceRatioFrom), (App)Codec.INT.optionalFieldOf("space_ratio_to", (Object)1).forGetter(o -> o.spaceRatioTo), (App)Codec.BOOL.optionalFieldOf("reversible", (Object)true).forGetter(o -> o.reversible), (App)PortalGenForm.GENERAL_CODEC.fieldOf("form").forGetter(o -> o.form), (App)PortalGenTrigger.triggerCodec.fieldOf("trigger").forGetter(o -> o.trigger), (App)STRING_LIST_CODEC.optionalFieldOf("post_invoke_commands", Collections.emptyList()).forGetter(o -> o.postInvokeCommands), (App)STRING_LIST_LIST_CODEC.optionalFieldOf("commands_on_generated", Collections.emptyList()).forGetter(o -> o.commandsOnGenerated)).apply((Applicative)instance, instance.stable(CustomPortalGeneration::new)));
    private static final MappedRegistry<MapCodec<CustomPortalGeneration>> SCHEMA_REGISTRY = (MappedRegistry)Util.make(() -> {
        MappedRegistry registry = new MappedRegistry(SCHEMA_KEY, Lifecycle.stable());
        Registry.register((Registry)registry, (ResourceLocation)McHelper.newResourceLocation("imm_ptl:v1"), codecV1);
        return registry;
    });
    public static final MapCodec<CustomPortalGeneration> MAP_CODEC = SCHEMA_REGISTRY.byNameCodec().dispatchMap("schema_version", e -> codecV1, Function.identity());
    public static final Codec<CustomPortalGeneration> CODEC = MAP_CODEC.codec();
    public final List<ResourceKey<Level>> fromDimensions;
    public final ResourceKey<Level> toDimension;
    public final int spaceRatioFrom;
    public final int spaceRatioTo;
    public final boolean reversible;
    public final PortalGenForm form;
    public final PortalGenTrigger trigger;
    public final List<String> postInvokeCommands;
    public final List<List<String>> commandsOnGenerated;
    public ResourceLocation identifier = null;

    public CustomPortalGeneration(List<ResourceKey<Level>> fromDimensions, ResourceKey<Level> toDimension, int spaceRatioFrom, int spaceRatioTo, boolean reversible, PortalGenForm form, PortalGenTrigger trigger, List<String> postInvokeCommands, List<List<String>> commandsOnGenerated) {
        this.fromDimensions = fromDimensions;
        this.toDimension = toDimension;
        this.spaceRatioFrom = spaceRatioFrom;
        this.spaceRatioTo = spaceRatioTo;
        this.reversible = reversible;
        this.form = form;
        this.trigger = trigger;
        this.postInvokeCommands = postInvokeCommands;
        this.commandsOnGenerated = commandsOnGenerated;
    }

    @Nullable
    public CustomPortalGeneration getReverse() {
        if (this.toDimension == THE_SAME_DIMENSION) {
            return new CustomPortalGeneration(this.fromDimensions, THE_SAME_DIMENSION, this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands, this.commandsOnGenerated);
        }
        if (!this.fromDimensions.isEmpty()) {
            return new CustomPortalGeneration(Lists.newArrayList((Object[])new ResourceKey[]{this.toDimension}), this.fromDimensions.get(0), this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands, this.commandsOnGenerated);
        }
        Helper.err("Cannot get reverse custom portal gen");
        return null;
    }

    public BlockPos mapPosition(BlockPos from, ServerLevel fromWorld, ServerLevel toWorld) {
        BlockPos newPosition = Helper.divide((Vec3i)Helper.scale((Vec3i)from, this.spaceRatioTo), this.spaceRatioFrom);
        boolean withinBounds = toWorld.getWorldBorder().isWithinBounds(newPosition);
        if (!withinBounds) {
            Helper.log("Tries to spawn a portal outside of world border");
            BlockPos clamped = toWorld.getWorldBorder().clampToBounds((double)newPosition.getX(), (double)newPosition.getY(), (double)newPosition.getZ());
            newPosition = new BlockPos((int)((double)clamped.getX() * 0.9), clamped.getY(), (int)((double)clamped.getZ() * 0.9));
        }
        return newPosition;
    }

    public InitializationResult initAndCheck(MinecraftServer server) {
        ResourceKey<Level> toDimension = this.toDimension;
        if (toDimension != THE_SAME_DIMENSION && server.getLevel(toDimension) == null) {
            return new NotLoadedBecauseOfDstDimensionInvalid(toDimension);
        }
        Set effectiveSrcDimensions = this.fromDimensions.stream().filter(dim -> dim == ANY_DIMENSION || server.getLevel(dim) != null).collect(Collectors.toSet());
        if (effectiveSrcDimensions.isEmpty()) {
            return new NotLoadedBecauseNoSrcDimensionValid(this.fromDimensions);
        }
        return new InitializationOk();
    }

    public String toString() {
        return McHelper.serializeToJson(this, MAP_CODEC.codec());
    }

    public boolean perform(ServerLevel world, BlockPos startPos, @Nullable Entity triggeringEntity) {
        ServerLevel toWorld;
        if (!this.fromDimensions.contains(world.dimension()) && this.fromDimensions.get(0) != ANY_DIMENSION) {
            return false;
        }
        if (!world.hasChunkAt(startPos)) {
            Helper.log("Skip custom portal generation because chunk not loaded");
            return false;
        }
        ResourceKey destDimension = this.toDimension;
        if (destDimension == THE_SAME_DIMENSION) {
            destDimension = world.dimension();
        }
        if ((toWorld = MiscHelper.getServer().getLevel(destDimension)) == null) {
            Helper.err("Missing dimension " + String.valueOf(destDimension.location()));
            return false;
        }
        world.getProfiler().push("custom_portal_gen_perform");
        boolean result = this.form.perform(this, world, startPos, toWorld, triggeringEntity);
        world.getProfiler().pop();
        return result;
    }

    public void onPortalsGenerated(Portal[] portals) {
        for (int i = 0; i < portals.length; ++i) {
            Portal portal = portals[i];
            if (this.identifier != null) {
                portal.portalTag = this.identifier.toString();
            }
            if (!this.postInvokeCommands.isEmpty()) {
                McHelper.invokeCommandAs(portal, this.postInvokeCommands);
            }
            if (i >= this.commandsOnGenerated.size()) continue;
            List<String> commandsForThisPortal = this.commandsOnGenerated.get(i);
            McHelper.invokeCommandAs(portal, commandsForThisPortal);
        }
    }

    public record NotLoadedBecauseOfDstDimensionInvalid(ResourceKey<Level> dimId) implements InitializationResult
    {
        @Override
        public String toString() {
            return "Destination dimension %s not loaded".formatted(this.dimId.location());
        }
    }

    public record NotLoadedBecauseNoSrcDimensionValid(Collection<ResourceKey<Level>> srcDimIds) implements InitializationResult
    {
        @Override
        public String toString() {
            return "No source dimension is loaded %s".formatted(this.srcDimIds.stream().map(ResourceKey::location).collect(Collectors.toList()));
        }
    }

    public record InitializationOk() implements InitializationResult
    {
    }

    public static sealed interface InitializationResult
    permits InitializationOk, NotLoadedBecauseOfDstDimensionInvalid, NotLoadedBecauseNoSrcDimensionValid {
    }
}

