/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenTrigger;
import qouteall.q_misc_util.my_util.WithDim;

public class CustomPortalGenManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Multimap<Item, CustomPortalGeneration> useItemGen = HashMultimap.create();
    private final Multimap<Item, CustomPortalGeneration> throwItemGen = HashMultimap.create();
    private final ArrayList<CustomPortalGeneration> convGen = new ArrayList();
    private final Map<UUID, WithDim<Vec3>> playerPosBeforeTravel = new HashMap<UUID, WithDim<Vec3>>();

    public static void init(IEventBus eventBus) {
        eventBus.addListener(DataPackRegistryEvent.NewRegistry.class, newRegistryEvent -> {
            newRegistryEvent.dataPackRegistry(CustomPortalGeneration.REGISTRY_KEY, CustomPortalGeneration.CODEC);
            newRegistryEvent.dataPackRegistry(CustomPortalGeneration.LEGACY_REGISTRY_KEY, CustomPortalGeneration.CODEC);
        });
        NeoForge.EVENT_BUS.addListener(ServerStartedEvent.class, e -> CustomPortalGenManager.onDataPackReloaded(e.getServer()));
    }

    private static void onDataPackReloaded(MinecraftServer server) {
        if (!IPGlobal.enableDatapackPortalGen) {
            return;
        }
        LOGGER.info("Processing custom portal generation");
        CustomPortalGenManager manager = new CustomPortalGenManager();
        Registry registry = server.registryAccess().registryOrThrow(CustomPortalGeneration.REGISTRY_KEY);
        Registry legacyRegistry = server.registryAccess().registryOrThrow(CustomPortalGeneration.LEGACY_REGISTRY_KEY);
        for (Map.Entry entry : registry.entrySet()) {
            manager.addEntry(server, (ResourceKey<CustomPortalGeneration>)((ResourceKey)entry.getKey()), (CustomPortalGeneration)entry.getValue());
        }
        for (Map.Entry entry : legacyRegistry.entrySet()) {
            manager.addEntry(server, (ResourceKey<CustomPortalGeneration>)((ResourceKey)entry.getKey()), (CustomPortalGeneration)entry.getValue());
        }
        IPPerServerInfo perServerInfo = IPPerServerInfo.of(server);
        perServerInfo.customPortalGenManager = manager;
    }

    private void addEntry(MinecraftServer server, ResourceKey<CustomPortalGeneration> key, CustomPortalGeneration gen) {
        gen.identifier = key.location();
        CustomPortalGeneration.InitializationResult r1 = gen.initAndCheck(server);
        if (!(r1 instanceof CustomPortalGeneration.InitializationOk)) {
            LOGGER.info("Custom portal generation is not activated: {}\n{}", (Object)r1, (Object)gen.toString());
            return;
        }
        LOGGER.info("Loaded Custom Portal Generation {}", (Object)key.location());
        this.load(gen);
        if (gen.reversible) {
            CustomPortalGeneration reverse = gen.getReverse();
            if (reverse != null) {
                reverse.identifier = key.location();
                CustomPortalGeneration.InitializationResult r2 = reverse.initAndCheck(server);
                if (!(r2 instanceof CustomPortalGeneration.InitializationOk)) {
                    LOGGER.info("Reverse custom portal generation is not activated: {}\n{}", (Object)r2, (Object)reverse.toString());
                    return;
                }
            } else {
                McHelper.sendMessageToFirstLoggedPlayer(server, (Component)Component.literal((String)("Cannot create reverse generation of " + String.valueOf(gen))));
            }
        }
    }

    private void load(CustomPortalGeneration gen) {
        PortalGenTrigger trigger = gen.trigger;
        if (trigger instanceof PortalGenTrigger.UseItemTrigger) {
            this.useItemGen.put((Object)((PortalGenTrigger.UseItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ThrowItemTrigger) {
            this.throwItemGen.put((Object)((PortalGenTrigger.ThrowItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ConventionalDimensionChangeTrigger) {
            this.convGen.add(gen);
        }
    }

    public void onItemUse(UseOnContext context, InteractionResult actionResult) {
        if (context.getLevel().isClientSide()) {
            return;
        }
        MinecraftServer server = context.getLevel().getServer();
        Item item = context.getItemInHand().getItem();
        if (this.useItemGen.containsKey((Object)item)) {
            ServerTaskList.of(server).addTask(() -> {
                for (CustomPortalGeneration gen : this.useItemGen.get((Object)item)) {
                    PortalGenTrigger.UseItemTrigger trigger;
                    boolean result = gen.perform((ServerLevel)context.getLevel(), context.getClickedPos().relative(context.getClickedFace()), (Entity)context.getPlayer());
                    if (!result) continue;
                    PortalGenTrigger patt0$temp = gen.trigger;
                    if (!(patt0$temp instanceof PortalGenTrigger.UseItemTrigger) || !(trigger = (PortalGenTrigger.UseItemTrigger)patt0$temp).shouldConsume(context)) break;
                    context.getItemInHand().shrink(1);
                    break;
                }
                return true;
            });
        }
    }

    public void onItemTick(ItemEntity entity) {
        Validate.isTrue((!entity.level().isClientSide() ? 1 : 0) != 0);
        if (!entity.hasPickUpDelay()) {
            return;
        }
        Item item = entity.getItem().getItem();
        Collection gens = this.throwItemGen.get((Object)item);
        if (gens.isEmpty()) {
            return;
        }
        ServerTaskList.of(entity.getServer()).addTask(() -> {
            for (CustomPortalGeneration gen : gens) {
                boolean result = gen.perform((ServerLevel)entity.level(), entity.blockPosition(), (Entity)entity);
                if (!result) continue;
                entity.getItem().shrink(1);
                break;
            }
            return true;
        });
    }

    public void onBeforeConventionalDimensionChange(ServerPlayer player) {
        this.playerPosBeforeTravel.put(player.getUUID(), new WithDim<Vec3>((ResourceKey<Level>)player.level().dimension(), player.position()));
    }

    public void onAfterConventionalDimensionChange(ServerPlayer player) {
        UUID uuid = player.getUUID();
        if (this.playerPosBeforeTravel.containsKey(uuid)) {
            WithDim<Vec3> startCoord = this.playerPosBeforeTravel.get(uuid);
            ServerLevel startWorld = player.server.getLevel(startCoord.dimension());
            if (startWorld == null) {
                LOGGER.error("Cannot find world {}", startCoord.dimension());
                return;
            }
            BlockPos startPos = BlockPos.containing((Position)((Position)startCoord.value()));
            for (CustomPortalGeneration gen : this.convGen) {
                boolean succeeded = gen.perform(startWorld, startPos, (Entity)player);
                if (!succeeded) continue;
                this.playerPosBeforeTravel.remove(uuid);
                return;
            }
        }
        this.playerPosBeforeTravel.remove(uuid);
    }
}

