/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.animation.Animated;

public record UnilateralPortalState(ResourceKey<Level> dimension, Vec3 position, DQuaternion orientation, double width, double height, double thickness, Matrix3dc orientationMatrix, Matrix3dc orientationMatrixReverse) {
    public static final Animated.TypeInfo<UnilateralPortalState> ANIMATION_TYPE_INFO = new Animated.TypeInfo<UnilateralPortalState>(){

        @Override
        public UnilateralPortalState interpolate(UnilateralPortalState start, UnilateralPortalState end, double progress) {
            if (start.dimension() != end.dimension()) {
                return end;
            }
            Pair<RectInvariant, UnilateralPortalState> p = start.turnToClosestTo(end.orientation());
            start = (UnilateralPortalState)p.getSecond();
            return new UnilateralPortalState(start.dimension(), start.position().lerp(end.position(), progress), DQuaternion.interpolate(start.orientation(), end.orientation(), progress), Mth.lerp((double)progress, (double)start.width(), (double)end.width()), Mth.lerp((double)progress, (double)start.height(), (double)end.height()), Mth.lerp((double)progress, (double)start.thickness(), (double)end.thickness()));
        }

        @Override
        public boolean isClose(UnilateralPortalState a, UnilateralPortalState b) {
            return a.dimension() == b.dimension() && a.position().distanceToSqr(b.position()) < 1.0E-4 && DQuaternion.isClose(a.orientation(), b.orientation()) && Math.abs(a.width() - b.width()) < 0.001 && Math.abs(a.height() - b.height()) < 0.001 && Math.abs(a.thickness() - b.thickness()) < 0.001;
        }
    };

    public UnilateralPortalState(ResourceKey<Level> dimension, Vec3 position, DQuaternion orientation, double width, double height) {
        this(dimension, position, orientation, width, height, 0.0);
    }

    public UnilateralPortalState(ResourceKey<Level> dimension, Vec3 position, DQuaternion orientation, double width, double height, double thickness) {
        this(dimension, position, orientation, width, height, thickness, (Matrix3dc)new Matrix3d().set((Quaternionfc)orientation.toMcQuaternion()), (Matrix3dc)new Matrix3d().set((Quaternionfc)orientation.toMcQuaternion().conjugate()));
    }

    public static UnilateralPortalState extractThisSide(PortalState portalState) {
        return new UnilateralPortalState(portalState.fromWorld, portalState.fromPos, portalState.orientation, portalState.width, portalState.height, portalState.thickness);
    }

    public static UnilateralPortalState extractOtherSide(PortalState portalState) {
        DQuaternion otherSideOrientation = portalState.rotation.hamiltonProduct(portalState.orientation).hamiltonProduct(portalState.isMirror ? DQuaternion.identity : PortalManipulation.flipAxisW);
        return new UnilateralPortalState(portalState.toWorld, portalState.toPos, otherSideOrientation, portalState.width * portalState.scaling, portalState.height * portalState.scaling, portalState.thickness * portalState.scaling);
    }

    public static PortalState combine(UnilateralPortalState thisSide, UnilateralPortalState otherSide) {
        DQuaternion otherSideOrientation = otherSide.orientation;
        DQuaternion thisSideOrientation = thisSide.orientation;
        DQuaternion rotation = PortalManipulation.computeDeltaTransformation(thisSideOrientation, otherSideOrientation);
        double scale = otherSide.width / thisSide.width;
        PortalState result = new PortalState(thisSide.dimension, thisSide.position, otherSide.dimension, otherSide.position, scale, rotation, thisSide.orientation, thisSide.width, thisSide.height, thisSide.thickness, false);
        return result;
    }

    public static UnilateralPortalState interpolate(UnilateralPortalState from, UnilateralPortalState to, double progress) {
        return new UnilateralPortalState(from.dimension, Helper.interpolatePos(from.position, to.position, progress), DQuaternion.interpolate(from.orientation, to.orientation, progress), Mth.lerp((double)progress, (double)from.width, (double)to.width), Mth.lerp((double)progress, (double)from.height, (double)to.height), Mth.lerp((double)progress, (double)from.thickness, (double)to.thickness));
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("dimension", this.dimension.location().toString());
        Helper.putVec3d(tag, "position", this.position);
        tag.put("orientation", this.orientation.toTag());
        tag.putDouble("width", this.width);
        tag.putDouble("height", this.height);
        tag.putDouble("thickness", this.thickness);
        return tag;
    }

    public static UnilateralPortalState fromTag(CompoundTag tag) {
        ResourceKey<Level> dimension = Helper.dimIdToKey(tag.getString("dimension"));
        Vec3 point = Helper.getVec3d(tag, "position");
        DQuaternion orientation = DQuaternion.fromTag((Tag)tag.getCompound("orientation"));
        double width = tag.getDouble("width");
        double height = tag.getDouble("height");
        double thickness = tag.getDouble("thickness");
        return new UnilateralPortalState(dimension, point, orientation, width, height, thickness);
    }

    public DeltaUnilateralPortalState subtract(UnilateralPortalState other) {
        return DeltaUnilateralPortalState.fromDiff(other, this);
    }

    public UnilateralPortalState apply(DeltaUnilateralPortalState thisSideDelta) {
        return new Builder().from(this).apply(thisSideDelta).build();
    }

    public Vec3 getAxisW() {
        return new Vec3(this.orientationMatrix.m00(), this.orientationMatrix.m01(), this.orientationMatrix.m02());
    }

    public Vec3 getAxisH() {
        return new Vec3(this.orientationMatrix.m10(), this.orientationMatrix.m11(), this.orientationMatrix.m12());
    }

    public Vec3 getNormal() {
        return new Vec3(this.orientationMatrix.m20(), this.orientationMatrix.m21(), this.orientationMatrix.m22());
    }

    public Vec3 pointOnPlane(double x, double y) {
        return this.transformLocalToGlobal(x, y, 0.0);
    }

    public Vec3 transformLocalToGlobal(double x, double y, double z) {
        Vector3d v = new Vector3d(x, y, z);
        this.orientationMatrix.transform(v);
        v.add(this.position.x(), this.position.y(), this.position.z());
        return new Vec3(v.x, v.y, v.z);
    }

    public Vec3 transformLocalToGlobal(Vec3 vec3) {
        return this.transformLocalToGlobal(vec3.x, vec3.y, vec3.z);
    }

    public Vec3 transformGlobalToLocal(double x, double y, double z) {
        Vector3d v = new Vector3d(x, y, z);
        v.sub(this.position.x(), this.position.y(), this.position.z());
        this.orientationMatrixReverse.transform(v);
        return new Vec3(v.x, v.y, v.z);
    }

    public Vec3 transformGlobalToLocal(Vec3 vec3) {
        return this.transformGlobalToLocal(vec3.x, vec3.y, vec3.z);
    }

    public Vec3 transformVecLocalToGlobal(Vec3 vec3) {
        Vector3d v = new Vector3d(vec3.x, vec3.y, vec3.z);
        this.orientationMatrix.transform(v);
        return new Vec3(v.x, v.y, v.z);
    }

    public Vec3 transformVecGlobalToLocal(Vec3 vec3) {
        Vector3d v = new Vector3d(vec3.x, vec3.y, vec3.z);
        this.orientationMatrixReverse.transform(v);
        return new Vec3(v.x, v.y, v.z);
    }

    public Pair<RectInvariant, UnilateralPortalState> turnToClosestTo(DQuaternion targetOrientation) {
        return Arrays.stream(RectInvariant.values()).map(inv -> Pair.of((Object)inv, (Object)inv.getVariantOf(this))).min(Comparator.comparingDouble(p -> DQuaternion.distanceSq(((UnilateralPortalState)p.getSecond()).orientation(), targetOrientation))).orElseThrow();
    }

    public static class Builder {
        public ResourceKey<Level> dimension;
        public Vec3 position;
        public DQuaternion orientation;
        public double width;
        public double height;
        public double thickness;

        public UnilateralPortalState build() {
            Validate.notNull(this.dimension, (String)"dimension is null", (Object[])new Object[0]);
            Validate.notNull((Object)this.position, (String)"position is null", (Object[])new Object[0]);
            Validate.notNull((Object)this.orientation, (String)"orientation is null", (Object[])new Object[0]);
            Validate.isTrue((this.width > 0.0 ? 1 : 0) != 0, (String)"invalid width %s", (double)this.width);
            Validate.isTrue((this.height > 0.0 ? 1 : 0) != 0, (String)"invalid height %s", (double)this.height);
            return new UnilateralPortalState(this.dimension, this.position, this.orientation, this.width, this.height, this.thickness);
        }

        public Builder dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder position(Vec3 point) {
            this.position = point;
            return this;
        }

        public Builder orientation(DQuaternion orientation) {
            this.orientation = orientation;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        public Builder thickness(double thickness) {
            this.thickness = thickness;
            return this;
        }

        @NotNull
        public Builder from(UnilateralPortalState other) {
            this.dimension = other.dimension;
            this.position = other.position;
            this.orientation = other.orientation;
            this.width = other.width;
            this.height = other.height;
            this.thickness = other.thickness;
            return this;
        }

        public Builder offset(Vec3 offset) {
            this.position = this.position.add(offset);
            return this;
        }

        public Builder rotate(DQuaternion rotation) {
            this.orientation = rotation.hamiltonProduct(this.orientation);
            return this;
        }

        public Builder scaleWidth(double scale) {
            this.width *= scale;
            return this;
        }

        public Builder scaleHeight(double scale) {
            this.height *= scale;
            return this;
        }

        public Builder scaleThickness(double scale) {
            this.thickness *= scale;
            return this;
        }

        public Builder apply(DeltaUnilateralPortalState delta) {
            if (delta.offset() != null) {
                this.position = this.position.add(delta.offset());
            }
            if (delta.rotation() != null) {
                this.orientation = delta.rotation().hamiltonProduct(this.orientation);
            }
            if (delta.sizeScaling() != null) {
                this.width *= delta.sizeScaling().x();
                this.height *= delta.sizeScaling().y();
                this.thickness *= delta.sizeScaling().z();
            }
            return this;
        }
    }

    public static enum RectInvariant {
        IDENTITY,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270,
        FLIP_X,
        FLIP_X_ROTATE_90,
        FLIP_X_ROTATE_180,
        FLIP_X_ROTATE_270;


        public UnilateralPortalState getVariantOf(UnilateralPortalState state) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> state;
                case 1 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 90.0)), state.height, state.width);
                case 2 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 180.0)), state.width, state.height);
                case 3 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 270.0)), state.height, state.width);
                case 4 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), 180.0)), state.width, state.height);
                case 5 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 90.0)).hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), 180.0)), state.height, state.width);
                case 6 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 180.0)).hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), 180.0)), state.width, state.height);
                case 7 -> new UnilateralPortalState(state.dimension, state.position, state.orientation.hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(0.0, 0.0, 1.0), 270.0)).hamiltonProduct(DQuaternion.rotationByDegrees(new Vec3(1.0, 0.0, 0.0), 180.0)), state.height, state.width);
            };
        }

        public boolean switchesWidthAndHeight() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2, 4, 6 -> false;
                case 1, 3, 5, 7 -> true;
            };
        }
    }
}

