/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.q_misc_util.Helper;

public interface PortalAnimationDriver {
    public static final Map<ResourceLocation, Function<CompoundTag, PortalAnimationDriver>> deserializerRegistry = new HashMap<ResourceLocation, Function<CompoundTag, PortalAnimationDriver>>();

    public static void registerDeserializer(ResourceLocation key, Function<CompoundTag, PortalAnimationDriver> deserializer) {
        deserializerRegistry.put(key, deserializer);
    }

    @Nullable
    public static PortalAnimationDriver fromTag(CompoundTag tag) {
        String type = tag.getString("type");
        Function<CompoundTag, PortalAnimationDriver> deserializer = deserializerRegistry.get(McHelper.newResourceLocation(type));
        if (deserializer == null) {
            Helper.err("Unknown animation type " + type);
            return null;
        }
        try {
            return deserializer.apply(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompoundTag toTag();

    @NotNull
    public AnimationResult getAnimationResult(long var1, float var3, AnimationContext var4);

    @Nullable
    public DeltaUnilateralPortalState getEndingResult(long var1, AnimationContext var3);

    default public PortalAnimationDriver getFlippedVersion() {
        return this;
    }

    default public Component getInfo() {
        return Component.literal((String)"Unknown Animation");
    }
}

