/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.DefaultPortalAnimation;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;

public class PortalAnimation {
    @NotNull
    public DefaultPortalAnimation defaultAnimation = DefaultPortalAnimation.createDefault();
    @NotNull
    public List<PortalAnimationDriver> thisSideAnimations = new ArrayList<PortalAnimationDriver>();
    @NotNull
    public List<PortalAnimationDriver> otherSideAnimations = new ArrayList<PortalAnimationDriver>();
    public long pauseTime = 0L;
    public long timeOffset = 0L;
    @Nullable
    public UnilateralPortalState thisSideReferenceState;
    @Nullable
    public UnilateralPortalState otherSideReferenceState;
    @Nullable
    private UnilateralPortalState pausedThisSideState;
    @Nullable
    private UnilateralPortalState pausedOtherSideState;
    @Nullable
    public PortalState lastTickAnimatedState;
    @Nullable
    public PortalState thisTickAnimatedState;
    public long updateCounter;
    @Nullable
    public PortalState clientLastFramePortalState;
    public long clientLastFramePortalStateCounter = -1L;
    @Nullable
    public PortalState clientCurrentFramePortalState;
    public long clientCurrentFramePortalStateCounter = -1L;

    public void readFromTag(CompoundTag tag) {
        ListTag listTag;
        this.defaultAnimation = tag.contains("animation") ? DefaultPortalAnimation.fromNbt(tag.getCompound("animation")) : (tag.contains("defaultAnimation") ? DefaultPortalAnimation.fromNbt(tag.getCompound("defaultAnimation")) : DefaultPortalAnimation.createDefault());
        if (tag.contains("thisSideAnimations")) {
            listTag = tag.getList("thisSideAnimations", 10);
            this.thisSideAnimations = Helper.listTagToList(listTag, PortalAnimationDriver::fromTag);
        } else {
            this.thisSideAnimations.clear();
        }
        if (tag.contains("otherSideAnimations")) {
            listTag = tag.getList("otherSideAnimations", 10);
            this.otherSideAnimations = Helper.listTagToList(listTag, PortalAnimationDriver::fromTag);
        } else {
            this.otherSideAnimations.clear();
        }
        this.pauseTime = tag.contains("pauseTime") ? tag.getLong("pauseTime") : 0L;
        this.timeOffset = tag.contains("timeOffset") ? tag.getLong("timeOffset") : 0L;
        this.thisSideReferenceState = tag.contains("thisSideReferenceState") ? UnilateralPortalState.fromTag(tag.getCompound("thisSideReferenceState")) : null;
        this.otherSideReferenceState = tag.contains("otherSideReferenceState") ? UnilateralPortalState.fromTag(tag.getCompound("otherSideReferenceState")) : null;
        this.pausedThisSideState = tag.contains("pausedThisSideState") ? UnilateralPortalState.fromTag(tag.getCompound("pausedThisSideState")) : null;
        this.pausedOtherSideState = tag.contains("pausedOtherSideState") ? UnilateralPortalState.fromTag(tag.getCompound("pausedOtherSideState")) : null;
    }

    public void writeToTag(CompoundTag tag) {
        tag.put("defaultAnimation", (Tag)this.defaultAnimation.toNbt());
        if (!this.thisSideAnimations.isEmpty()) {
            tag.put("thisSideAnimations", (Tag)Helper.listToListTag(this.thisSideAnimations, PortalAnimationDriver::toTag));
        }
        if (!this.otherSideAnimations.isEmpty()) {
            tag.put("otherSideAnimations", (Tag)Helper.listToListTag(this.otherSideAnimations, PortalAnimationDriver::toTag));
        }
        if (this.pauseTime != 0L) {
            tag.putLong("pauseTime", this.pauseTime);
        }
        if (this.timeOffset != 0L) {
            tag.putLong("timeOffset", this.timeOffset);
        }
        if (this.thisSideReferenceState != null) {
            tag.put("thisSideReferenceState", (Tag)this.thisSideReferenceState.toTag());
        }
        if (this.otherSideReferenceState != null) {
            tag.put("otherSideReferenceState", (Tag)this.otherSideReferenceState.toTag());
        }
        if (this.pausedThisSideState != null) {
            tag.put("pausedThisSideState", (Tag)this.pausedThisSideState.toTag());
        }
        if (this.pausedOtherSideState != null) {
            tag.put("pausedOtherSideState", (Tag)this.pausedOtherSideState.toTag());
        }
    }

    public boolean isRoughlyRunningAnimation() {
        return this.lastTickAnimatedState != null || this.thisTickAnimatedState != null || this.hasRunningAnimationDriver();
    }

    public boolean hasRunningAnimationDriver() {
        return !this.isPaused() && this.hasAnimationDriver();
    }

    public boolean hasAnimationDriver() {
        return !this.thisSideAnimations.isEmpty() || !this.otherSideAnimations.isEmpty();
    }

    public boolean isPaused() {
        return this.pauseTime != 0L;
    }

    public void setPaused(Portal portal, boolean paused) {
        if (paused == this.isPaused()) {
            return;
        }
        if (paused) {
            this.pauseTime = portal.level().getGameTime();
            PortalState portalState = portal.getPortalState();
            assert (portalState != null);
            this.pausedThisSideState = portalState.getThisSideState();
            this.pausedOtherSideState = portalState.getOtherSideState();
        } else {
            this.timeOffset -= portal.level().getGameTime() - this.pauseTime;
            this.pauseTime = 0L;
            if (this.pausedThisSideState != null && this.pausedOtherSideState != null) {
                PortalState currentState = portal.getPortalState();
                assert (currentState != null);
                UnilateralPortalState currentThisSideState = currentState.getThisSideState();
                UnilateralPortalState currentOtherSideState = currentState.getOtherSideState();
                DeltaUnilateralPortalState thisSideDelta = currentThisSideState.subtract(this.pausedThisSideState);
                DeltaUnilateralPortalState otherSideDelta = currentOtherSideState.subtract(this.pausedOtherSideState);
                if (this.thisSideReferenceState != null) {
                    this.thisSideReferenceState = this.thisSideReferenceState.apply(thisSideDelta);
                }
                if (this.otherSideReferenceState != null) {
                    this.otherSideReferenceState = this.otherSideReferenceState.apply(otherSideDelta);
                }
                this.pausedThisSideState = null;
                this.pausedOtherSideState = null;
            }
        }
        PortalExtension.forClusterPortals(portal, Portal::reloadAndSyncToClientNextTick);
    }

    public void setBackToPausingState(Portal portal) {
        if (this.pausedThisSideState != null && this.pausedOtherSideState != null) {
            portal.setPortalState(UnilateralPortalState.combine(this.pausedThisSideState, this.pausedOtherSideState));
        }
    }

    public long getEffectiveTime(long gameTime) {
        return (this.isPaused() ? this.pauseTime : gameTime) + this.timeOffset;
    }

    public void tick(Portal portal) {
        this.swapTickRelativeStateIfNeeded(portal);
        if (!portal.level().isClientSide()) {
            this.updateAnimationDriver(portal, portal.animation, portal.level().getGameTime(), 1.0f, true, true);
            if (this.thisSideAnimations.isEmpty()) {
                this.thisSideReferenceState = null;
            }
            if (this.otherSideAnimations.isEmpty()) {
                this.otherSideReferenceState = null;
            }
            if (!this.hasAnimationDriver()) {
                this.setPaused(portal, false);
            }
        } else if (this.hasAnimationDriver() && !this.isPaused()) {
            PortalAnimation.markRequiresClientAnimationUpdate(portal);
        }
    }

    public void swapTickRelativeStateIfNeeded(Portal portal) {
        int counter = portal.tickCount;
        if ((long)counter != this.updateCounter) {
            this.lastTickAnimatedState = this.thisTickAnimatedState;
            this.thisTickAnimatedState = null;
            this.updateCounter = counter;
        }
    }

    private void provideThisTickState(Portal portal, PortalState portalState) {
        this.swapTickRelativeStateIfNeeded(portal);
        if (this.thisTickAnimatedState != null && !portal.level().isClientSide()) {
            Helper.log("Conflicting animation in " + String.valueOf(portal));
            portal.clearAnimationDrivers(true, true);
            this.thisTickAnimatedState = null;
            return;
        }
        this.thisTickAnimatedState = portalState;
    }

    private static void markRequiresClientAnimationUpdate(Portal portal) {
        ClientPortalAnimationManagement.markRequiresCustomAnimationUpdate(portal);
    }

    public void updateAnimationDriver(Portal portal, PortalAnimation animation, long gameTime, float partialTicks, boolean isTicking, boolean canRemoveAnimation) {
        if (!this.hasAnimationDriver()) {
            return;
        }
        if (this.isPaused()) {
            return;
        }
        PortalState portalState = portal.getPortalState();
        if (portalState == null) {
            return;
        }
        this.initializeReferenceStates(portalState);
        assert (this.thisSideReferenceState != null);
        assert (this.otherSideReferenceState != null);
        long effectiveGameTime = animation.getEffectiveTime(gameTime);
        float effectivePartialTicks = animation.isPaused() ? 0.0f : partialTicks;
        UnilateralPortalState.Builder thisSideState = new UnilateralPortalState.Builder().from(this.thisSideReferenceState);
        UnilateralPortalState.Builder otherSideState = new UnilateralPortalState.Builder().from(this.otherSideReferenceState);
        int originalThisSideAnimationCount = this.thisSideAnimations.size();
        int originalOtherSideAnimationCount = this.otherSideAnimations.size();
        AnimationContext context = new AnimationContext(portal.level().isClientSide(), isTicking);
        this.thisSideAnimations.removeIf(animationDriver -> {
            boolean animationRemoved;
            AnimationResult animationResult = animationDriver.getAnimationResult(effectiveGameTime, effectivePartialTicks, context);
            if (animationResult.delta() != null) {
                thisSideState.apply(animationResult.delta());
            }
            boolean bl = animationRemoved = canRemoveAnimation && animationResult.isFinished();
            if (animationRemoved && animationResult.delta() != null) {
                assert (this.thisSideReferenceState != null);
                this.thisSideReferenceState = new UnilateralPortalState.Builder().from(this.thisSideReferenceState).apply(animationResult.delta()).build();
            }
            return animationRemoved;
        });
        this.otherSideAnimations.removeIf(animationDriver -> {
            boolean animationRemoved;
            AnimationResult animationResult = animationDriver.getAnimationResult(effectiveGameTime, effectivePartialTicks, context);
            if (animationResult.delta() != null) {
                otherSideState.apply(animationResult.delta());
            }
            boolean bl = animationRemoved = canRemoveAnimation && animationResult.isFinished();
            if (animationRemoved && animationResult.delta() != null) {
                assert (this.otherSideReferenceState != null);
                this.otherSideReferenceState = new UnilateralPortalState.Builder().from(this.otherSideReferenceState).apply(animationResult.delta()).build();
            }
            return animationRemoved;
        });
        if (thisSideState.dimension != portalState.fromWorld || otherSideState.dimension != portalState.toWorld) {
            Helper.err("Portal animation driver cannot change dimension");
            if (!portal.level().isClientSide()) {
                portal.clearAnimationDrivers(true, true);
            }
            return;
        }
        UnilateralPortalState newThisSideState = thisSideState.build();
        UnilateralPortalState newOtherSideState = otherSideState.build();
        PortalState newPortalState = UnilateralPortalState.combine(newThisSideState, newOtherSideState);
        portal.setPortalState(newPortalState);
        if (isTicking) {
            this.provideThisTickState(portal, newPortalState);
        }
        portal.rectifyClusterPortals(false);
        if (isTicking) {
            PortalExtension.forConnectedPortals(portal, p -> p.animation.provideThisTickState((Portal)p, p.getPortalState()));
        }
        if (!(portal.level().isClientSide() || this.thisSideAnimations.size() == originalThisSideAnimationCount && this.otherSideAnimations.size() == originalOtherSideAnimationCount)) {
            PortalExtension.forClusterPortals(portal, p -> p.reloadAndSyncToClientWithTickDelay(1));
        }
    }

    public void initializeReferenceStates(PortalState portalState) {
        if (this.thisSideReferenceState == null) {
            this.thisSideReferenceState = UnilateralPortalState.extractThisSide(portalState);
        }
        if (this.otherSideReferenceState == null) {
            this.otherSideReferenceState = UnilateralPortalState.extractOtherSide(portalState);
        }
    }

    public void resetReferenceState(Portal portal, boolean thisSide, boolean otherSide) {
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        if (thisSide && this.thisSideReferenceState != null) {
            this.thisSideReferenceState = UnilateralPortalState.extractThisSide(portalState);
        }
        if (otherSide && this.otherSideReferenceState != null) {
            this.otherSideReferenceState = UnilateralPortalState.extractOtherSide(portalState);
        }
    }

    public void clearAnimationDrivers(Portal portal, boolean clearThisSide, boolean clearOtherSide) {
        Validate.isTrue((!portal.level().isClientSide() ? 1 : 0) != 0);
        this.setPaused(portal, false);
        if (this.thisSideAnimations.isEmpty() && this.otherSideAnimations.isEmpty()) {
            return;
        }
        AnimationContext context = new AnimationContext(portal.level().isClientSide(), true);
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        UnilateralPortalState.Builder from = new UnilateralPortalState.Builder().from(UnilateralPortalState.extractThisSide(portalState));
        UnilateralPortalState.Builder to = new UnilateralPortalState.Builder().from(UnilateralPortalState.extractOtherSide(portalState));
        this.applyEndingState(portal, clearThisSide, clearOtherSide, context, from, to);
        if (clearThisSide) {
            this.thisSideReferenceState = null;
            this.thisSideAnimations.clear();
        }
        if (clearOtherSide) {
            this.otherSideReferenceState = null;
            this.otherSideAnimations.clear();
        }
        PortalState newState = UnilateralPortalState.combine(from.build(), to.build());
        portal.setPortalState(newState);
        PortalExtension.get(portal).rectifyClusterPortals(portal, true);
    }

    private void applyEndingState(Portal portal, boolean includeThisSide, boolean includeOtherSide, AnimationContext context, UnilateralPortalState.Builder from, UnilateralPortalState.Builder to) {
        DeltaUnilateralPortalState endingResult;
        long effectiveGameTime = portal.level().getGameTime() + this.timeOffset;
        if (includeThisSide) {
            for (PortalAnimationDriver animationDriver : this.thisSideAnimations) {
                endingResult = animationDriver.getEndingResult(effectiveGameTime, context);
                if (endingResult == null) continue;
                from.apply(endingResult);
            }
        }
        if (includeOtherSide) {
            for (PortalAnimationDriver animationDriver : this.otherSideAnimations) {
                endingResult = animationDriver.getEndingResult(effectiveGameTime, context);
                if (endingResult == null) continue;
                to.apply(endingResult);
            }
        }
    }

    public PortalState getAnimationEndingState(Portal portal) {
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        this.initializeReferenceStates(portalState);
        assert (this.thisSideReferenceState != null);
        assert (this.otherSideReferenceState != null);
        UnilateralPortalState.Builder from = new UnilateralPortalState.Builder().from(this.thisSideReferenceState);
        UnilateralPortalState.Builder to = new UnilateralPortalState.Builder().from(this.otherSideReferenceState);
        this.applyEndingState(portal, true, true, new AnimationContext(portal.level().isClientSide(), true), from, to);
        return UnilateralPortalState.combine(from.build(), to.build());
    }

    public void updateClientState(Portal portal, long currentTeleportationCounter) {
        if (currentTeleportationCounter == this.clientCurrentFramePortalStateCounter) {
            return;
        }
        if (this.isRoughlyRunningAnimation()) {
            this.clientLastFramePortalState = this.clientCurrentFramePortalState;
            this.clientLastFramePortalStateCounter = this.clientCurrentFramePortalStateCounter;
            this.clientCurrentFramePortalState = portal.getPortalState();
            this.clientCurrentFramePortalStateCounter = currentTeleportationCounter;
        }
    }

    public Component getInfo(Portal portal, boolean reverse) {
        PortalAnimationDriver animation;
        int i;
        MutableComponent component = Component.literal((String)"");
        List<PortalAnimationDriver> l1 = reverse ? this.otherSideAnimations : this.thisSideAnimations;
        List<PortalAnimationDriver> l2 = reverse ? this.thisSideAnimations : this.otherSideAnimations;
        component.append((Component)Component.literal((String)"This Side:\n"));
        for (i = 0; i < l1.size(); ++i) {
            animation = l1.get(i);
            component.append((Component)Component.literal((String)"[%d]: ".formatted(i)).withStyle(ChatFormatting.GOLD).append(animation.getInfo()).append("\n"));
        }
        component.append((Component)Component.literal((String)"Other Side:\n"));
        for (i = 0; i < l2.size(); ++i) {
            animation = l2.get(i);
            component.append((Component)Component.literal((String)"[%d]: ".formatted(i)).withStyle(ChatFormatting.GOLD).append(animation.getInfo()).append("\n"));
        }
        return component;
    }
}

