/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import com.mojang.logging.LogUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.q_misc_util.Helper;

@Deprecated
public record OscillationAnimation(Vec3 vec, double frequency, long startGameTime, long cycleCount) implements PortalAnimationDriver
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        PortalAnimationDriver.registerDeserializer(McHelper.newResourceLocation("imm_ptl:oscillation"), OscillationAnimation::fromTag);
    }

    public static OscillationAnimation fromTag(CompoundTag tag) {
        Vec3 vec = Helper.vec3FromListTag(tag.get("vec"));
        if (vec == null) {
            LOGGER.error("Invalid oscillation animation {}", (Object)tag);
            return null;
        }
        double frequency = tag.getDouble("frequency");
        long startGameTime = tag.getLong("startGameTime");
        long cycleCount = tag.getLong("cycleCount");
        return new OscillationAnimation(vec, frequency, startGameTime, cycleCount);
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "imm_ptl:oscillation");
        tag.put("vec", (Tag)Helper.vec3ToListTag(this.vec));
        tag.putDouble("frequency", this.frequency);
        tag.putLong("startGameTime", this.startGameTime);
        tag.putLong("cycleCount", this.cycleCount);
        return tag;
    }

    @Override
    @NotNull
    public AnimationResult getAnimationResult(long tickTime, float partialTicks, AnimationContext context) {
        double deltaTicks = (double)(tickTime - this.startGameTime) + (double)partialTicks;
        double deltaSeconds = deltaTicks / 20.0;
        double deltaCycles = deltaSeconds * this.frequency;
        if (deltaCycles > (double)this.cycleCount) {
            return new AnimationResult(null, true);
        }
        double v = Math.sin(deltaCycles * Math.PI * 2.0);
        throw new NotImplementedException();
    }

    @Override
    public DeltaUnilateralPortalState getEndingResult(long tickTime, AnimationContext context) {
        return DeltaUnilateralPortalState.identity;
    }
}

