/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Vec2d;

public class NormalAnimation
implements PortalAnimationDriver {
    public static final int INFINITE_THRESHOLD = 100000;
    public final List<Phase> phases;
    public final long startingGameTime;
    public final int loopCount;
    public final boolean isBuilding;
    private final long ticksPerRound;

    public static void init() {
        PortalAnimationDriver.registerDeserializer(McHelper.newResourceLocation("imm_ptl:normal"), NormalAnimation::deserialize);
    }

    public NormalAnimation(List<Phase> phases, long startingGameTime, int loopCount, boolean isBuilding) {
        this.phases = phases;
        this.startingGameTime = startingGameTime;
        this.loopCount = loopCount;
        this.isBuilding = isBuilding;
        long totalTicks = 0L;
        for (Phase phase : phases) {
            totalTicks += phase.durationTicks;
        }
        this.ticksPerRound = totalTicks;
    }

    private static NormalAnimation deserialize(CompoundTag compoundTag) {
        UnilateralPortalState initialState = UnilateralPortalState.fromTag(compoundTag.getCompound("initialState"));
        ArrayList<Phase> phases = Helper.listTagToList(Helper.getCompoundList(compoundTag, "phases"), Phase::fromTag);
        long startingGameTime = compoundTag.getLong("startingGameTime");
        int loopCount = compoundTag.getInt("loopCount");
        boolean isBuilding = compoundTag.getBoolean("isBuilding");
        if (!isBuilding && (phases.isEmpty() || loopCount < 0)) {
            throw new RuntimeException("invalid NormalAnimation");
        }
        return new NormalAnimation(phases, startingGameTime, loopCount, isBuilding);
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "imm_ptl:normal");
        tag.put("phases", (Tag)Helper.listToListTag(this.phases, Phase::toTag));
        tag.putLong("startingGameTime", this.startingGameTime);
        tag.putInt("loopCount", this.loopCount);
        tag.putBoolean("isBuilding", this.isBuilding);
        return tag;
    }

    private long getTotalDuration() {
        if (this.loopCount >= 100000) {
            return Long.MAX_VALUE;
        }
        return this.ticksPerRound * (long)this.loopCount;
    }

    @Override
    @NotNull
    public AnimationResult getAnimationResult(long tickTime, float partialTicks, AnimationContext context) {
        if (this.isBuilding) {
            return new AnimationResult(null, false);
        }
        if (this.ticksPerRound == 0L || this.phases.isEmpty()) {
            Helper.err("No phase");
            return new AnimationResult(null, true);
        }
        double passedTicks = (double)(tickTime - 1L - this.startingGameTime) + (double)partialTicks;
        long totalDuration = this.getTotalDuration();
        boolean ends = false;
        if (passedTicks >= (double)totalDuration) {
            passedTicks = totalDuration;
            ends = true;
        }
        if (passedTicks < 0.0) {
            return new AnimationResult(null, false);
        }
        double passedTicksInThisRound = ends ? (double)this.ticksPerRound : passedTicks % (double)this.ticksPerRound;
        long roundIndex = Math.floorDiv((long)passedTicks, this.ticksPerRound);
        long traversedTicks = 0L;
        DeltaUnilateralPortalState lastDelta = DeltaUnilateralPortalState.identity;
        for (Phase phase : this.phases) {
            if (phase.durationTicks != 0L && passedTicksInThisRound < (double)(traversedTicks + phase.durationTicks)) {
                double phaseProgress = (passedTicksInThisRound - (double)traversedTicks) / (double)phase.durationTicks;
                phaseProgress = phase.timingFunction.mapProgress(phaseProgress);
                DeltaUnilateralPortalState interpolated = DeltaUnilateralPortalState.interpolate(lastDelta, phase.delta, phaseProgress);
                return new AnimationResult(interpolated, ends);
            }
            lastDelta = phase.delta();
            traversedTicks += phase.durationTicks;
        }
        return new AnimationResult(lastDelta, ends);
    }

    @Override
    @Nullable
    public DeltaUnilateralPortalState getEndingResult(long tickTime, AnimationContext context) {
        if (this.phases.isEmpty()) {
            return null;
        }
        return this.phases.get(this.phases.size() - 1).delta();
    }

    @Override
    public PortalAnimationDriver getFlippedVersion() {
        return new NormalAnimation(this.phases.stream().map(phase -> phase.getFlippedVersion()).collect(Collectors.toList()), this.startingGameTime, this.loopCount, this.isBuilding);
    }

    public static NormalAnimation createSizeAnimation(Portal portal, Vec2d startSizeScale, Vec2d toSizeScale, long startingGameTime, long durationTicks, TimingFunction timingFunction) {
        Phase initialPhase = new Phase.Builder().durationTicks(0L).timingFunction(timingFunction).delta(new DeltaUnilateralPortalState.Builder().scaleSize(startSizeScale).build()).build();
        Phase endingPhase = new Phase.Builder().durationTicks(durationTicks).timingFunction(timingFunction).delta(new DeltaUnilateralPortalState.Builder().scaleSize(toSizeScale).build()).build();
        return new Builder().phases(List.of(initialPhase, endingPhase)).startingGameTime(startingGameTime).loopCount(1).build();
    }

    public static NormalAnimation createOscillationAnimation(Vec3 vec, int cycleTicks, long startingGameTime) {
        int partTickNum = cycleTicks / 4;
        return new Builder().startingGameTime(startingGameTime).infiniteLoop().phases(List.of(new Phase.Builder().delta(new DeltaUnilateralPortalState.Builder().offset(vec).build()).durationTicks(partTickNum).timingFunction(TimingFunction.sine).build(), new Phase.Builder().delta(DeltaUnilateralPortalState.identity).durationTicks(partTickNum).timingFunction(TimingFunction.sineFlipped).build(), new Phase.Builder().delta(new DeltaUnilateralPortalState.Builder().offset(vec.scale(-1.0)).build()).durationTicks(partTickNum).timingFunction(TimingFunction.sine).build(), new Phase.Builder().delta(DeltaUnilateralPortalState.identity).durationTicks(partTickNum).timingFunction(TimingFunction.sineFlipped).build())).build();
    }

    @Override
    public Component getInfo() {
        MutableComponent component = Component.literal((String)"Normal[\n");
        for (Phase phase : this.phases) {
            component.append(" ");
            component.append(phase.getInfo());
            component.append("\n");
        }
        component.append("] %s times".formatted(this.loopCount >= 100000 ? "\u221e" : Integer.valueOf(this.loopCount)));
        return component;
    }

    public record Phase(long durationTicks, DeltaUnilateralPortalState delta, TimingFunction timingFunction) {
        public static Phase fromTag(CompoundTag tag) {
            long durationTicks = tag.getLong("durationTicks");
            DeltaUnilateralPortalState delta = DeltaUnilateralPortalState.fromTag(tag.getCompound("delta"));
            TimingFunction timingFunction = TimingFunction.fromString(tag.getString("timingFunction"));
            return new Phase(durationTicks, delta, timingFunction);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putLong("durationTicks", this.durationTicks);
            tag.put("delta", (Tag)this.delta.toTag());
            tag.putString("timingFunction", this.timingFunction.name());
            return tag;
        }

        public Phase getFlippedVersion() {
            return new Phase(this.durationTicks, this.delta.getFlipped(), this.timingFunction);
        }

        public Component getInfo() {
            return Component.literal((String)"Phase(%d,".formatted(this.durationTicks)).append(this.delta.toString()).append(")");
        }

        public static class Builder {
            private long durationTicks = 0L;
            private DeltaUnilateralPortalState delta = DeltaUnilateralPortalState.identity;
            private TimingFunction timingFunction = TimingFunction.linear;

            public Builder durationTicks(long durationTicks) {
                this.durationTicks = durationTicks;
                return this;
            }

            public Builder delta(DeltaUnilateralPortalState delta) {
                this.delta = delta;
                return this;
            }

            public Builder timingFunction(TimingFunction timingFunction) {
                this.timingFunction = timingFunction;
                return this;
            }

            public Phase build() {
                return new Phase(this.durationTicks, this.delta, this.timingFunction);
            }
        }
    }

    public static class Builder {
        private List<Phase> phases = new ArrayList<Phase>();
        private long startingGameTime;
        private int loopCount;
        private boolean isBuilding = false;

        public Builder from(NormalAnimation animation) {
            this.phases = animation.phases;
            this.startingGameTime = animation.startingGameTime;
            this.loopCount = animation.loopCount;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = phases;
            return this;
        }

        public Builder startingGameTime(long startingGameTime) {
            this.startingGameTime = startingGameTime;
            return this;
        }

        public Builder loopCount(int loopCount) {
            this.loopCount = loopCount;
            return this;
        }

        public Builder infiniteLoop() {
            this.loopCount = 100000;
            return this;
        }

        public Builder isBuilding(boolean isBuilding) {
            this.isBuilding = isBuilding;
            return this;
        }

        public NormalAnimation build() {
            return new NormalAnimation(this.phases, this.startingGameTime, this.loopCount, this.isBuilding);
        }
    }
}

