/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;

public class PortalPlaceholderBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final VoxelShape X_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final VoxelShape Y_AABB = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape Z_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final PortalPlaceholderBlock instance = new PortalPlaceholderBlock(BlockBehaviour.Properties.of().noCollission().sound(SoundType.GLASS).strength(1.0f, 0.0f).noOcclusion().noLootTable().lightLevel(s -> 15));

    public PortalPlaceholderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos blockPos, CollisionContext shapeContext) {
        switch ((Direction.Axis)state.getValue(AXIS)) {
            case Z: {
                return Z_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return X_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public BlockState updateShape(BlockState thisState, Direction direction, BlockState neighborState, LevelAccessor worldAccess, BlockPos blockPos, BlockPos neighborPos) {
        if (!worldAccess.isClientSide() && worldAccess instanceof Level) {
            Level world = (Level)worldAccess;
            world.getProfiler().push("portal_placeholder");
            Direction.Axis axis = (Direction.Axis)thisState.getValue(AXIS);
            if (direction.getAxis() != axis) {
                McHelper.findEntitiesRough(BreakablePortalEntity.class, world, Vec3.atLowerCornerOf((Vec3i)blockPos), 2, e -> true).forEach(portal -> portal.notifyPlaceholderUpdate());
            }
            world.getProfiler().pop();
        }
        return super.updateShape(thisState, direction, neighborState, worldAccess, blockPos, neighborPos);
    }

    public static boolean isHitOnPlaceholder(HitResult hitResult, Level world) {
        if (hitResult.getType() == HitResult.Type.BLOCK && hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Block hittingBlock = world.getBlockState(blockHitResult.getBlockPos()).getBlock();
            return hittingBlock == instance;
        }
        return false;
    }

    public boolean propagatesSkylightDown(BlockState blockState_1, BlockGetter blockView_1, BlockPos blockPos_1) {
        return true;
    }

    public RenderShape getRenderShape(BlockState blockState_1) {
        return RenderShape.INVISIBLE;
    }

    public float getShadeBrightness(BlockState blockState_1, BlockGetter blockView_1, BlockPos blockPos_1) {
        return 1.0f;
    }
}

