/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;

public interface PortalLike {
    public boolean isConventionalPortal();

    public AABB getThinBoundingBox();

    public Vec3 transformPoint(Vec3 var1);

    public Vec3 transformLocalVec(Vec3 var1);

    public Vec3 transformLocalVecNonScale(Vec3 var1);

    public Vec3 inverseTransformLocalVec(Vec3 var1);

    public Vec3 inverseTransformPoint(Vec3 var1);

    public double getDistanceToNearestPointInPortal(Vec3 var1);

    public double getDestAreaRadiusEstimation();

    public Vec3 getOriginPos();

    public Vec3 getDestPos();

    public Level getOriginWorld();

    public Level getDestWorld();

    public ResourceKey<Level> getDestDim();

    public boolean isRoughlyVisibleTo(Vec3 var1);

    @Nullable
    public Plane getInnerClipping();

    @Nullable
    public DQuaternion getRotation();

    public double getScale();

    public boolean getIsGlobal();

    public boolean isVisible();

    @Nullable
    public Vec3[] getOuterFrustumCullingVertices();

    @Nullable
    public Matrix4f getAdditionalCameraTransformation();

    @Nullable
    public UUID getDiscriminator();

    public boolean cannotRenderInMe(Portal var1);

    public boolean isFuseView();

    public boolean getDoRenderPlayer();

    public boolean getHasCrossPortalCollision();

    default public boolean hasScaling() {
        return Math.abs(this.getScale() - 1.0) > 0.01;
    }

    default public ResourceKey<Level> getOriginDim() {
        return this.getOriginWorld().dimension();
    }

    default public boolean isOnDestinationSide(Vec3 entityPos, double valve) {
        Plane innerClipping = this.getInnerClipping();
        if (innerClipping == null) {
            return true;
        }
        double v = entityPos.subtract(innerClipping.pos()).dot(innerClipping.normal());
        return v > valve;
    }

    default public double getSizeEstimation() {
        Vec3 boxSize = Helper.getBoxSize(this.getThinBoundingBox());
        double maxDimension = Math.max(Math.max(boxSize.x, boxSize.y), boxSize.z);
        return maxDimension;
    }
}

