/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.ClientPortalTickEvent;
import de.nick1st.imm_ptl.events.ReadPortalDataEvent;
import de.nick1st.imm_ptl.events.ServerPortalTickEvent;
import de.nick1st.imm_ptl.events.WritePortalDataEvent;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;

public class PortalExtension {
    private static final Logger LOGGER = LogUtils.getLogger();
    public double motionAffinity = 0.0;
    public boolean adjustPositionAfterTeleport = true;
    public boolean bindCluster = true;
    @Nullable
    public UUID reversePortalId;
    @Nullable
    public UUID flippedPortalId;
    @Nullable
    public UUID parallelPortalId;
    @Nullable
    public Portal reversePortal;
    @Nullable
    public Portal flippedPortal;
    @Nullable
    public Portal parallelPortal;

    public static PortalExtension get(Portal portal) {
        if (portal.extension == null) {
            portal.extension = new PortalExtension();
        }
        return portal.extension;
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ClientPortalTickEvent.class, event -> {
            Portal portal = event.portal;
            PortalExtension.get(portal).tick(portal);
        });
        NeoForge.EVENT_BUS.addListener(ServerPortalTickEvent.class, event -> {
            Portal portal = event.portal;
            PortalExtension.get(portal).tick(portal);
        });
        NeoForge.EVENT_BUS.addListener(ReadPortalDataEvent.class, event -> {
            Portal portal = event.portal;
            CompoundTag tag = event.tag;
            PortalExtension.get(portal).readFromNbt(tag);
        });
        NeoForge.EVENT_BUS.addListener(WritePortalDataEvent.class, event -> {
            Portal portal = event.portal;
            CompoundTag tag = event.tag;
            PortalExtension.get(portal).writeToNbt(tag);
        });
    }

    private void readFromNbt(CompoundTag compoundTag) {
        this.motionAffinity = compoundTag.contains("motionAffinity") ? compoundTag.getDouble("motionAffinity") : 0.0;
        this.adjustPositionAfterTeleport = compoundTag.contains("adjustPositionAfterTeleport") ? compoundTag.getBoolean("adjustPositionAfterTeleport") : true;
        this.bindCluster = compoundTag.contains("bindCluster") ? compoundTag.getBoolean("bindCluster") : true;
        this.reversePortalId = compoundTag.hasUUID("reversePortalId") ? compoundTag.getUUID("reversePortalId") : null;
        this.flippedPortalId = compoundTag.hasUUID("flippedPortalId") ? compoundTag.getUUID("flippedPortalId") : null;
        this.parallelPortalId = compoundTag.hasUUID("parallelPortalId") ? compoundTag.getUUID("parallelPortalId") : null;
    }

    private void writeToNbt(CompoundTag compoundTag) {
        if (this.motionAffinity != 0.0) {
            compoundTag.putDouble("motionAffinity", this.motionAffinity);
        }
        compoundTag.putBoolean("adjustPositionAfterTeleport", this.adjustPositionAfterTeleport);
        compoundTag.putBoolean("bindCluster", this.bindCluster);
        if (this.reversePortalId != null) {
            compoundTag.putUUID("reversePortalId", this.reversePortalId);
        }
        if (this.flippedPortalId != null) {
            compoundTag.putUUID("flippedPortalId", this.flippedPortalId);
        }
        if (this.parallelPortalId != null) {
            compoundTag.putUUID("parallelPortalId", this.parallelPortalId);
        }
    }

    private void tick(Portal portal) {
        if (portal.level().isClientSide()) {
            this.updateClusterStatusClient(portal);
        } else {
            this.updateClusterStatusServer(portal);
        }
    }

    private void updateClusterStatusServer(Portal portal) {
        if (portal instanceof Mirror) {
            return;
        }
        boolean needsUpdate = false;
        if (this.bindCluster) {
            Portal p;
            Entity e;
            if (this.flippedPortal != null && this.flippedPortal.isRemoved()) {
                this.flippedPortal = null;
            }
            if (this.reversePortal != null && this.reversePortal.isRemoved()) {
                this.reversePortal = null;
            }
            if (this.parallelPortal != null && this.parallelPortal.isRemoved()) {
                this.parallelPortal = null;
            }
            if (this.flippedPortalId != null && this.flippedPortal == null) {
                e = (Entity)((IEWorld)portal.level()).portal_getEntityLookup().get(this.flippedPortalId);
                if (e instanceof Portal) {
                    this.flippedPortal = p = (Portal)e;
                } else {
                    this.flippedPortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.flippedPortalId == null) {
                this.flippedPortal = PortalManipulation.findFlippedPortal(portal);
                if (this.flippedPortal != null) {
                    this.flippedPortalId = this.flippedPortal.getUUID();
                    needsUpdate = true;
                }
            }
            if (this.reversePortalId != null && this.reversePortal == null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().get(this.reversePortalId);
                if (e instanceof Portal) {
                    this.reversePortal = p = (Portal)e;
                } else if (portal.isOtherSideChunkLoaded()) {
                    LOGGER.info("portal linking break {}", (Object)portal);
                    this.reversePortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.reversePortalId == null) {
                this.reversePortal = PortalManipulation.findReversePortal(portal);
                if (this.reversePortal != null) {
                    this.reversePortalId = this.reversePortal.getUUID();
                    needsUpdate = true;
                }
            }
            if (this.parallelPortalId != null && this.parallelPortal == null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().get(this.parallelPortalId);
                if (e instanceof Portal) {
                    this.parallelPortal = p = (Portal)e;
                } else if (portal.isOtherSideChunkLoaded()) {
                    LOGGER.info("portal linking break {}", (Object)portal);
                    this.parallelPortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.parallelPortalId == null) {
                this.parallelPortal = PortalManipulation.findParallelPortal(portal);
                if (this.parallelPortal != null) {
                    this.parallelPortalId = this.parallelPortal.getUUID();
                    needsUpdate = true;
                }
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
            this.flippedPortalId = null;
            this.reversePortalId = null;
            this.parallelPortalId = null;
        }
        if (this.flippedPortal != null) {
            PortalExtension.get((Portal)this.flippedPortal).bindCluster = true;
        }
        if (this.reversePortal != null) {
            PortalExtension.get((Portal)this.reversePortal).bindCluster = true;
        }
        if (this.parallelPortal != null) {
            PortalExtension.get((Portal)this.parallelPortal).bindCluster = true;
        }
        if (this.flippedPortal == portal) {
            this.flippedPortal = null;
            this.flippedPortalId = null;
            needsUpdate = true;
        }
        if (this.reversePortal == portal) {
            this.reversePortal = null;
            this.reversePortalId = null;
            needsUpdate = true;
        }
        if (this.parallelPortal == portal) {
            this.parallelPortal = null;
            this.parallelPortalId = null;
            needsUpdate = true;
        }
        if (needsUpdate) {
            portal.reloadAndSyncToClient();
        }
    }

    private void updateClusterStatusClient(Portal portal) {
        if (this.bindCluster) {
            Portal p;
            Entity e;
            if (this.flippedPortalId != null) {
                e = (Entity)((IEWorld)portal.level()).portal_getEntityLookup().get(this.flippedPortalId);
                if (e instanceof Portal) {
                    this.flippedPortal = p = (Portal)e;
                }
            } else {
                this.flippedPortal = null;
            }
            if (this.reversePortalId != null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().get(this.reversePortalId);
                if (e instanceof Portal) {
                    this.reversePortal = p = (Portal)e;
                }
            } else {
                this.reversePortal = null;
            }
            if (this.parallelPortalId != null) {
                e = (Entity)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().get(this.parallelPortalId);
                if (e instanceof Portal) {
                    this.parallelPortal = p = (Portal)e;
                }
            } else {
                this.parallelPortal = null;
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
        }
    }

    public void rectifyClusterPortals(Portal portal, boolean sync) {
        portal.animation.defaultAnimation.inverseScale = false;
        if (this.flippedPortal != null) {
            this.flippedPortal = ServerTeleportationManager.teleportRegularEntityTo(this.flippedPortal, (ResourceKey<Level>)portal.level().dimension(), portal.getOriginPos());
            this.flippedPortal.setDestDim(portal.getDestDim());
            this.flippedPortal.setOriginPos(portal.getOriginPos());
            this.flippedPortal.setDestination(portal.getDestPos());
            this.flippedPortal.setAxisW(portal.getAxisW().scale(-1.0));
            this.flippedPortal.setAxisH(portal.getAxisH());
            this.flippedPortal.setScaling(portal.getScaling());
            this.flippedPortal.setRotation(portal.getRotation());
            this.flippedPortal.setWidth(portal.getWidth());
            this.flippedPortal.setHeight(portal.getHeight());
            this.flippedPortal.setThickness(portal.getThickness());
            PortalManipulation.copyAdditionalProperties(this.flippedPortal, portal, false);
            this.flippedPortal.animation.defaultAnimation.inverseScale = false;
            this.flippedPortal.setPortalShape(portal.getPortalShape().getFlipped());
            if (sync) {
                this.flippedPortal.reloadAndSyncToClientNextTick();
            }
        }
        if (this.reversePortal != null) {
            if (portal.getDestDim() != this.reversePortal.level().dimension()) {
                LOGGER.info("Moving reverse portal across dimension {} {}", (Object)portal, (Object)this.reversePortal);
            }
            this.reversePortal = ServerTeleportationManager.teleportRegularEntityTo(this.reversePortal, portal.getDestDim(), portal.getDestPos());
            this.reversePortalId = this.reversePortal.getUUID();
            this.reversePortal.setDestDim((ResourceKey<Level>)portal.getOriginDim());
            this.reversePortal.setOriginPos(portal.getDestPos());
            this.reversePortal.setDestination(portal.getOriginPos());
            this.reversePortal.setAxisW(portal.transformLocalVecNonScale(portal.getAxisW().scale(-1.0)));
            this.reversePortal.setAxisH(portal.transformLocalVecNonScale(portal.getAxisH()));
            this.reversePortal.setScaling(1.0 / portal.getScaling());
            if (portal.getRotation() != null) {
                this.reversePortal.setRotation(portal.getRotation().getConjugated());
            } else {
                this.reversePortal.setRotation(null);
            }
            this.reversePortal.setWidth(portal.getWidth() * portal.getScale());
            this.reversePortal.setHeight(portal.getHeight() * portal.getScale());
            this.reversePortal.setThickness(portal.getThickness() * portal.getScale());
            PortalManipulation.copyAdditionalProperties(this.reversePortal, portal, false);
            this.reversePortal.animation.defaultAnimation.inverseScale = true;
            this.reversePortal.setPortalShape(portal.getPortalShape().getReverse());
            if (sync) {
                this.reversePortal.reloadAndSyncToClientNextTick();
            }
        }
        if (this.parallelPortal != null) {
            if (portal.getDestDim() != this.parallelPortal.level().dimension()) {
                LOGGER.info("Moving parallel portal across dimension {} {}", (Object)portal, (Object)this.parallelPortal);
            }
            this.parallelPortal = ServerTeleportationManager.teleportRegularEntityTo(this.parallelPortal, portal.getDestDim(), portal.getDestPos());
            this.parallelPortalId = this.parallelPortal.getUUID();
            this.parallelPortal.setDestDim((ResourceKey<Level>)portal.getOriginDim());
            this.parallelPortal.setOriginPos(portal.getDestPos());
            this.parallelPortal.setDestination(portal.getOriginPos());
            this.parallelPortal.setAxisW(portal.transformLocalVecNonScale(portal.getAxisW()));
            this.parallelPortal.setAxisH(portal.transformLocalVecNonScale(portal.getAxisH()));
            this.parallelPortal.setScaling(1.0 / portal.getScaling());
            if (portal.getRotation() != null) {
                this.parallelPortal.setRotation(portal.getRotation().getConjugated());
            } else {
                this.parallelPortal.setRotation(null);
            }
            this.parallelPortal.setWidth(portal.getWidth() * portal.getScale());
            this.parallelPortal.setHeight(portal.getHeight() * portal.getScale());
            this.parallelPortal.setThickness(portal.getThickness() * portal.getScale());
            PortalManipulation.copyAdditionalProperties(this.parallelPortal, portal, false);
            this.parallelPortal.animation.defaultAnimation.inverseScale = true;
            this.parallelPortal.setPortalShape(portal.getPortalShape().cloneIfNecessary());
            if (sync) {
                this.parallelPortal.reloadAndSyncToClientNextTick();
            }
        }
    }

    public static void initializeClusterBind(Portal f1, Portal f2, Portal t1, Portal t2) {
        PortalExtension.get((Portal)f1).bindCluster = true;
        PortalExtension.get((Portal)f2).bindCluster = true;
        PortalExtension.get((Portal)t1).bindCluster = true;
        PortalExtension.get((Portal)t2).bindCluster = true;
        PortalExtension.get((Portal)f1).flippedPortalId = f2.getUUID();
        PortalExtension.get((Portal)f2).flippedPortalId = f1.getUUID();
        PortalExtension.get((Portal)t1).flippedPortalId = t2.getUUID();
        PortalExtension.get((Portal)t2).flippedPortalId = t1.getUUID();
        PortalExtension.get((Portal)f1).reversePortalId = t1.getUUID();
        PortalExtension.get((Portal)t1).reversePortalId = f1.getUUID();
        PortalExtension.get((Portal)f2).reversePortalId = t2.getUUID();
        PortalExtension.get((Portal)t2).reversePortalId = f2.getUUID();
        PortalExtension.get((Portal)f1).parallelPortalId = t2.getUUID();
        PortalExtension.get((Portal)t2).parallelPortalId = f1.getUUID();
        PortalExtension.get((Portal)f2).parallelPortalId = t1.getUUID();
        PortalExtension.get((Portal)t1).parallelPortalId = f2.getUUID();
    }

    public static void forClusterPortals(Portal portal, Consumer<Portal> func) {
        func.accept(portal);
        PortalExtension.forConnectedPortals(portal, func);
    }

    public static void forConnectedPortals(Portal portal, Consumer<Portal> func) {
        PortalExtension extension = PortalExtension.get(portal);
        if (extension.flippedPortal != null) {
            func.accept(extension.flippedPortal);
        }
        if (extension.reversePortal != null) {
            func.accept(extension.reversePortal);
        }
        if (extension.parallelPortal != null) {
            func.accept(extension.parallelPortal);
        }
    }

    public static void forEachClusterPortal(Portal portal, Consumer<Portal> forThis, Consumer<Portal> forFlipped, Consumer<Portal> forReverse, Consumer<Portal> forParallel) {
        forThis.accept(portal);
        PortalExtension extension = PortalExtension.get(portal);
        if (extension.flippedPortal != null) {
            forFlipped.accept(extension.flippedPortal);
        }
        if (extension.reversePortal != null) {
            forReverse.accept(extension.reversePortal);
        }
        if (extension.parallelPortal != null) {
            forParallel.accept(extension.parallelPortal);
        }
    }
}

