/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.ClientPortalTickEvent;
import de.nick1st.imm_ptl.events.PortalDisposeEvent;
import de.nick1st.imm_ptl.events.ReadPortalDataEvent;
import de.nick1st.imm_ptl.events.ServerPortalTickEvent;
import de.nick1st.imm_ptl.events.WritePortalDataEvent;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.ImmPtlEntityExtension;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.mc_utils.IPEntityEventListenableEntity;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.IntraClusterRelation;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationView;
import qouteall.imm_ptl.core.portal.animation.DefaultPortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.portal.shape.RectangularPortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public class Portal
extends Entity
implements PortalLike,
IPEntityEventListenableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityType<Portal> ENTITY_TYPE = Portal.createPortalEntityType(Portal::new);
    private static final AABB NULL_BOX = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected double width = 0.0;
    protected double height = 0.0;
    protected double thickness = 0.0;
    protected Vec3 axisW;
    protected Vec3 axisH;
    public ResourceKey<Level> dimensionTo;
    protected Vec3 destination;
    protected boolean teleportable = true;
    @Nullable
    protected PortalShape portalShape;
    @Nullable
    public UUID specificPlayerId;
    @Nullable
    protected DQuaternion rotation;
    protected double scaling = 1.0;
    protected boolean teleportChangesScale = true;
    protected boolean teleportChangesGravity;
    protected boolean interactable;
    PortalExtension extension;
    @Nullable
    public String portalTag;
    public boolean isGlobalPortal;
    protected boolean fuseView;
    @Deprecated
    public boolean renderingMergable;
    protected boolean crossPortalCollisionEnabled;
    protected boolean doRenderPlayer;
    protected boolean visible;
    @Nullable
    protected List<String> commandsOnTeleported;
    PortalRenderInfo portalRenderInfo;
    public final PortalAnimation animation;
    @Nullable
    protected PortalState lastTickPortalState;
    protected boolean reloadAndSyncNextTick;
    @Nullable
    private AABB thinBoundingBoxCache;
    @Nullable
    private AABB boundingBoxCache;
    @Nullable
    private Vec3 normalCache;
    @Nullable
    private Vec3 contentDirectionCache;
    @Nullable
    private PortalState portalStateCache;
    @Nullable
    private VoxelShape thisSideCollisionExclusion;
    @Nullable
    private UnilateralPortalState thisSideStateCache;
    @Nullable
    private UnilateralPortalState otherSideStateCache;

    public static <T extends Portal> EntityType<T> createPortalEntityType(EntityType.EntityFactory<T> constructor) {
        EntityType.Builder builder = EntityType.Builder.of(constructor, (MobCategory)MobCategory.MISC).fireImmune().clientTrackingRange(96).updateInterval(20).setShouldReceiveVelocityUpdates(true);
        builder.dimensions = new EntityDimensions(1.0f, 1.0f, 0.85f, EntityAttachments.createDefault((float)1.0f, (float)1.0f), true);
        return builder.build("");
    }

    public Portal(EntityType<?> entityType, Level world) {
        super(entityType, world);
        this.teleportChangesGravity = IPConfig.getConfig().portalsChangeGravityByDefault;
        this.interactable = true;
        this.isGlobalPortal = false;
        this.fuseView = false;
        this.renderingMergable = false;
        this.crossPortalCollisionEnabled = true;
        this.doRenderPlayer = true;
        this.visible = true;
        this.animation = new PortalAnimation();
        this.reloadAndSyncNextTick = false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.width = compoundTag.getDouble("width");
        this.height = compoundTag.getDouble("height");
        this.thickness = compoundTag.getDouble("thickness");
        this.axisW = Helper.getVec3d(compoundTag, "axisW").normalize();
        this.axisH = Helper.getVec3d(compoundTag, "axisH").normalize();
        this.dimensionTo = Helper.getWorldId(compoundTag, "dimensionTo");
        this.destination = Helper.getVec3d(compoundTag, "destination");
        this.specificPlayerId = Helper.getUuid(compoundTag, "specificPlayer");
        if (compoundTag.contains("portalShape")) {
            CompoundTag portalShapeTag = compoundTag.getCompound("portalShape");
            PortalShape portalShape = PortalShapeSerialization.deserialize(portalShapeTag);
            if (portalShape == null) {
                LOGGER.error("Cannot deserialize portal shape {}", (Object)portalShapeTag);
                this.portalShape = RectangularPortalShape.INSTANCE;
            } else {
                this.portalShape = portalShape;
            }
        } else {
            boolean shapeNormalized;
            Mesh2D mesh2D = compoundTag.contains("specialShape") ? ((shapeNormalized = compoundTag.getBoolean("shapeNormalized")) ? GeometryPortalShape.readOldMeshFromTag(compoundTag.getList("specialShape", 6)) : GeometryPortalShape.readOldMeshFromTagNonNormalized(compoundTag.getList("specialShape", 6), this.width / 2.0, this.height / 2.0)) : null;
            this.portalShape = mesh2D == null ? RectangularPortalShape.INSTANCE : new SpecialFlatPortalShape(mesh2D);
        }
        if (compoundTag.contains("teleportable")) {
            this.teleportable = compoundTag.getBoolean("teleportable");
        }
        if (compoundTag.contains("rotationA")) {
            this.setRotationTransformationD(new DQuaternion(compoundTag.getFloat("rotationB"), compoundTag.getFloat("rotationC"), compoundTag.getFloat("rotationD"), compoundTag.getFloat("rotationA")));
        } else {
            this.rotation = null;
        }
        if (compoundTag.contains("interactable")) {
            this.interactable = compoundTag.getBoolean("interactable");
        }
        if (compoundTag.contains("scale")) {
            this.scaling = compoundTag.getDouble("scale");
        }
        if (compoundTag.contains("teleportChangesScale")) {
            this.teleportChangesScale = compoundTag.getBoolean("teleportChangesScale");
        }
        this.teleportChangesGravity = compoundTag.contains("teleportChangesGravity") ? compoundTag.getBoolean("teleportChangesGravity") : IPConfig.getConfig().portalsChangeGravityByDefault;
        if (compoundTag.contains("portalTag")) {
            this.portalTag = compoundTag.getString("portalTag");
        }
        if (compoundTag.contains("fuseView")) {
            this.fuseView = compoundTag.getBoolean("fuseView");
        }
        if (compoundTag.contains("renderingMergable")) {
            this.renderingMergable = compoundTag.getBoolean("renderingMergable");
        }
        if (compoundTag.contains("hasCrossPortalCollision")) {
            this.crossPortalCollisionEnabled = compoundTag.getBoolean("hasCrossPortalCollision");
        }
        if (compoundTag.contains("commandsOnTeleported")) {
            ListTag list = compoundTag.getList("commandsOnTeleported", 8);
            this.commandsOnTeleported = list.stream().map(t -> ((StringTag)t).getAsString()).collect(Collectors.toList());
        } else {
            this.commandsOnTeleported = null;
        }
        this.doRenderPlayer = compoundTag.contains("doRenderPlayer") ? compoundTag.getBoolean("doRenderPlayer") : true;
        this.visible = compoundTag.contains("isVisible") ? compoundTag.getBoolean("isVisible") : true;
        this.animation.readFromTag(compoundTag);
        NeoForge.EVENT_BUS.post((Event)new ReadPortalDataEvent(this, compoundTag));
        this.updateCache();
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putDouble("width", this.width);
        compoundTag.putDouble("height", this.height);
        compoundTag.putDouble("thickness", this.thickness);
        Helper.putVec3d(compoundTag, "axisW", this.axisW);
        Helper.putVec3d(compoundTag, "axisH", this.axisH);
        Helper.putWorldId(compoundTag, "dimensionTo", this.dimensionTo);
        Helper.putVec3d(compoundTag, "destination", this.getDestPos());
        if (this.specificPlayerId != null) {
            Helper.putUuid(compoundTag, "specificPlayer", this.specificPlayerId);
        }
        CompoundTag portalShapeTag = PortalShapeSerialization.serialize(this.getPortalShape());
        compoundTag.put("portalShape", (Tag)portalShapeTag);
        compoundTag.putBoolean("teleportable", this.teleportable);
        if (this.rotation != null) {
            compoundTag.putDouble("rotationA", this.rotation.w);
            compoundTag.putDouble("rotationB", this.rotation.x);
            compoundTag.putDouble("rotationC", this.rotation.y);
            compoundTag.putDouble("rotationD", this.rotation.z);
        }
        compoundTag.putBoolean("interactable", this.interactable);
        compoundTag.putDouble("scale", this.scaling);
        compoundTag.putBoolean("teleportChangesScale", this.teleportChangesScale);
        compoundTag.putBoolean("teleportChangesGravity", this.teleportChangesGravity);
        if (this.portalTag != null) {
            compoundTag.putString("portalTag", this.portalTag);
        }
        compoundTag.putBoolean("fuseView", this.fuseView);
        compoundTag.putBoolean("renderingMergable", this.renderingMergable);
        compoundTag.putBoolean("hasCrossPortalCollision", this.crossPortalCollisionEnabled);
        compoundTag.putBoolean("doRenderPlayer", this.doRenderPlayer);
        compoundTag.putBoolean("isVisible", this.visible);
        if (this.commandsOnTeleported != null) {
            ListTag list = new ListTag();
            for (String command : this.commandsOnTeleported) {
                list.add((Object)StringTag.valueOf((String)command));
            }
            compoundTag.put("commandsOnTeleported", (Tag)list);
        }
        this.animation.writeToTag(compoundTag);
        NeoForge.EVENT_BUS.post((Event)new WritePortalDataEvent(this, compoundTag));
    }

    @NotNull
    public PortalShape getPortalShape() {
        if (this.portalShape == null) {
            this.portalShape = RectangularPortalShape.INSTANCE;
        }
        return this.portalShape;
    }

    public void setPortalShape(PortalShape portalShape) {
        this.portalShape = portalShape;
        if (portalShape.isPlanar()) {
            this.thickness = 0.0;
        }
        this.updateCache();
    }

    public void setPortalShapeToDefault() {
        this.setPortalShape(RectangularPortalShape.INSTANCE);
    }

    @Override
    public void ip_onEntityPositionUpdated() {
        this.updateCache();
    }

    @Override
    public void ip_onRemoved(Entity.RemovalReason reason) {
        NeoForge.EVENT_BUS.post((Event)new PortalDisposeEvent(this));
    }

    @Override
    public Vec3 transformPoint(Vec3 pos) {
        Vec3 localPos = pos.subtract(this.getOriginPos());
        return this.transformLocalVec(localPos).add(this.getDestPos());
    }

    @Override
    public Vec3 transformLocalVec(Vec3 localVec) {
        return this.transformLocalVecNonScale(localVec).scale(this.scaling);
    }

    public Vec3 getNormal() {
        if (this.normalCache == null) {
            this.normalCache = this.axisW.cross(this.axisH).normalize();
        }
        return this.normalCache;
    }

    public Vec3 getContentDirection() {
        if (this.contentDirectionCache == null) {
            this.contentDirectionCache = this.transformLocalVecNonScale(this.getNormal().scale(-1.0));
        }
        return this.contentDirectionCache;
    }

    public void onEntityTeleportedOnServer(Entity entity) {
        if (this.commandsOnTeleported != null) {
            McHelper.invokeCommandAs(entity, this.commandsOnTeleported);
        }
    }

    public void reloadAndSyncToClient() {
        this.reloadAndSyncNextTick = false;
        Validate.isTrue((!this.isGlobalPortal ? 1 : 0) != 0, (String)"global portal is not synced by this", (Object[])new Object[0]);
        Validate.isTrue((!this.level().isClientSide() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.updateCache();
        ImmPtlNetworking.PortalSyncPacket packet = this.createSyncPacket();
        McHelper.sendToTrackers((Entity)this, packet);
    }

    public void reloadAndSyncToClientNextTick() {
        Validate.isTrue((!this.level().isClientSide() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.reloadAndSyncNextTick = true;
    }

    public void reloadAndSyncClusterToClientNextTick() {
        PortalExtension.forClusterPortals(this, Portal::reloadAndSyncToClientNextTick);
    }

    public void reloadAndSyncToClientWithTickDelay(int tickDelay) {
        Validate.isTrue((!this.level().isClientSide() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        ServerTaskList.of(this.getServer()).addTask(MyTaskList.withDelay(tickDelay, () -> {
            this.reloadAndSyncToClientNextTick();
            return true;
        }));
    }

    public void updateCache() {
        if (this.axisW == null || this.axisH == null) {
            return;
        }
        this.portalStateCache = null;
        this.boundingBoxCache = null;
        this.thinBoundingBoxCache = null;
        this.normalCache = null;
        this.contentDirectionCache = null;
        this.thisSideCollisionExclusion = null;
        this.thisSideStateCache = null;
        this.otherSideStateCache = null;
    }

    @NotNull
    public AABB getBoundingBox() {
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.makeBoundingBox();
        }
        return this.boundingBoxCache;
    }

    @Override
    public Vec3 getOriginPos() {
        return this.position();
    }

    @Override
    public Vec3 getDestPos() {
        return this.destination;
    }

    public void setOriginPos(Vec3 pos) {
        this.setPos(pos);
    }

    public void setDestinationDimension(ResourceKey<Level> dim) {
        this.dimensionTo = dim;
    }

    public void setDestination(Vec3 destination) {
        this.destination = destination;
        this.updateCache();
    }

    @Override
    public boolean isFuseView() {
        return this.fuseView;
    }

    @Deprecated
    public boolean isRenderingMergable() {
        return this.renderingMergable;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public Level getOriginWorld() {
        return this.level();
    }

    @Override
    public Level getDestWorld() {
        return this.getDestinationWorld();
    }

    @Override
    public ResourceKey<Level> getDestDim() {
        return this.dimensionTo;
    }

    @Override
    public double getScale() {
        return this.scaling;
    }

    @Override
    public boolean getIsGlobal() {
        return this.isGlobalPortal;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setIsVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean canTeleportEntity(Entity entity) {
        if (!this.teleportable) {
            return false;
        }
        if (entity instanceof Portal) {
            return false;
        }
        if (entity instanceof Player ? this.specificPlayerId != null && !entity.getUUID().equals(this.specificPlayerId) : this.specificPlayerId != null && !this.specificPlayerId.equals(Util.NIL_UUID)) {
            return false;
        }
        if (!O_O.allowTeleportingEntity(entity, this)) {
            return false;
        }
        return ((ImmPtlEntityExtension)entity).imm_ptl_canTeleportThroughPortal(this);
    }

    public boolean canCollideWithEntity(Entity entity) {
        return this.canTeleportEntity(entity);
    }

    public boolean isInteractableBy(Player player) {
        if (!IPConfig.getConfig().enableCrossPortalInteraction) {
            return false;
        }
        if (!this.isInteractable()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.canTeleportEntity((Entity)player);
    }

    @Override
    @Nullable
    public DQuaternion getRotation() {
        return this.rotation;
    }

    @NotNull
    public DQuaternion getRotationD() {
        return DQuaternion.fromNullable(this.getRotation());
    }

    @Override
    public boolean getDoRenderPlayer() {
        return this.doRenderPlayer;
    }

    public boolean getTeleportable() {
        return this.teleportable;
    }

    public void setTeleportable(boolean teleportable) {
        this.teleportable = teleportable;
    }

    public void setOrientationAndSize(Vec3 newAxisW, Vec3 newAxisH, double newWidth, double newHeight) {
        this.setOrientation(newAxisW, newAxisH);
        this.width = newWidth;
        this.height = newHeight;
        this.updateCache();
    }

    public void setOrientation(Vec3 newAxisW, Vec3 newAxisH) {
        this.axisW = newAxisW.normalize();
        this.axisH = newAxisH.normalize();
        this.updateCache();
    }

    public void setWidth(double newWidth) {
        this.width = newWidth;
        this.updateCache();
    }

    public void setHeight(double newHeight) {
        this.height = newHeight;
        this.updateCache();
    }

    public void setThickness(double newThickness) {
        this.thickness = newThickness;
        this.updateCache();
    }

    public void setPortalSize(double newWidth, double newHeight, double newThickness) {
        this.width = newWidth;
        this.height = newHeight;
        this.thickness = newThickness;
        this.updateCache();
    }

    public DQuaternion getOrientationRotation() {
        return PortalManipulation.getPortalOrientationQuaternion(this.axisW, this.axisH);
    }

    public void setOrientationRotation(DQuaternion quaternion) {
        DQuaternion fixed = this.level().isClientSide() ? quaternion : quaternion.fixFloatingPointErrorAccumulation();
        this.setOrientation(McHelper.getAxisWFromOrientation(fixed), McHelper.getAxisHFromOrientation(fixed));
    }

    public void setRotation(@Nullable DQuaternion quaternion) {
        this.setRotationTransformationD(quaternion);
    }

    public void setRotationTransformation(@Nullable DQuaternion quaternion) {
        this.setRotationTransformationD(quaternion);
    }

    public void setRotationTransformationD(@Nullable DQuaternion quaternion) {
        this.rotation = quaternion == null ? null : quaternion.fixFloatingPointErrorAccumulation();
        this.updateCache();
    }

    public void setOtherSideOrientation(DQuaternion otherSideOrientation) {
        this.setRotation(PortalManipulation.computeDeltaTransformation(this.getOrientationRotation(), otherSideOrientation));
    }

    public void setScaleTransformation(double newScale) {
        this.scaling = newScale;
    }

    public void renderViewAreaMesh(Vec3 portalPosRelativeToCamera, TriangleConsumer vertexOutput) {
        if (this instanceof Mirror) {
            boolean offsetFront = IrisInterface.invoker.isShaders() || IPGlobal.pureMirror;
            double mirrorOffset = offsetFront ? 0.01 : -0.01;
            portalPosRelativeToCamera = portalPosRelativeToCamera.add(((Mirror)this).getNormal().scale(mirrorOffset));
        }
        this.getPortalShape().renderViewAreaMesh(portalPosRelativeToCamera, this.getThisSideState(), vertexOutput, this.getIsGlobal());
    }

    public void sendPairingData(@NotNull ServerPlayer serverPlayer, Consumer<CustomPacketPayload> payloadConsumer) {
        payloadConsumer.accept(this.createSyncPacket());
    }

    private ImmPtlNetworking.PortalSyncPacket createSyncPacket() {
        Validate.isTrue((!this.level().isClientSide() ? 1 : 0) != 0);
        CompoundTag compoundTag = new CompoundTag();
        this.addAdditionalSaveData(compoundTag);
        return new ImmPtlNetworking.PortalSyncPacket(this.getId(), this.getUUID(), this.getType(), PortalAPI.serverDimKeyToInt(this.getServer(), (ResourceKey<Level>)this.getOriginDim()), this.getX(), this.getY(), this.getZ(), compoundTag);
    }

    public boolean broadcastToPlayer(ServerPlayer spectator) {
        if (this.specificPlayerId == null) {
            return true;
        }
        return spectator.getUUID().equals(this.specificPlayerId);
    }

    public void tick() {
        if (this.getBoundingBox().equals((Object)NULL_BOX)) {
            LOGGER.error("Abnormal bounding box {}", (Object)this);
        }
        this.lastTickPortalState = this.getThisTickPortalState();
        if (!this.level().isClientSide() && this.reloadAndSyncNextTick) {
            this.reloadAndSyncToClient();
        }
        if (this.level().isClientSide()) {
            NeoForge.EVENT_BUS.post((Event)new ClientPortalTickEvent(this));
        } else {
            if (!this.isPortalValid()) {
                LOGGER.info("Removed invalid portal {}", (Object)this);
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            NeoForge.EVENT_BUS.post((Event)new ServerPortalTickEvent(this));
        }
        this.animation.tick(this);
        super.tick();
    }

    @NotNull
    protected AABB makeBoundingBox() {
        if (this.axisW == null) {
            this.boundingBoxCache = null;
            return NULL_BOX;
        }
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.getPortalShape().getBoundingBox(this.getThisSideState(), this.shouldLimitBoundingBox(), 0.2);
        }
        return this.boundingBoxCache;
    }

    protected boolean shouldLimitBoundingBox() {
        return !this.getIsGlobal();
    }

    public void move(MoverType type, Vec3 movement) {
    }

    public boolean isPortalValid() {
        boolean valid;
        boolean bl = valid = this.dimensionTo != null && this.width != 0.0 && this.height != 0.0 && this.axisW != null && this.axisH != null && this.getDestPos() != null && this.axisW.lengthSqr() > 0.9 && this.axisH.lengthSqr() > 0.9 && this.getY() > (double)(McHelper.getMinY((LevelAccessor)this.level()) - 100);
        if (valid) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerLevel destWorld = serverLevel.getServer().getLevel(this.dimensionTo);
                if (destWorld == null) {
                    LOGGER.error("Portal Dest Dimension Missing {}", (Object)this.dimensionTo.location());
                    return false;
                }
                boolean inWorldBorder = destWorld.getWorldBorder().isWithinBounds(BlockPos.containing((Position)this.getDestPos()));
                if (!inWorldBorder) {
                    LOGGER.error("Destination out of World Border {}", (Object)this);
                    return false;
                }
            }
            if (this.level().isClientSide()) {
                return this.isPortalValidClient();
            }
            return true;
        }
        return false;
    }

    private boolean isPortalValidClient() {
        boolean contains = ClientWorldLoader.getServerDimensions().contains(this.dimensionTo);
        if (!contains) {
            LOGGER.error("Client Portal Dest Dimension Missing {}", (Object)this.dimensionTo.location());
        }
        return contains;
    }

    @Override
    @Nullable
    public UUID getDiscriminator() {
        return this.getUUID();
    }

    @NotNull
    public String toString() {
        return String.format("%s{%s,%s,(%s %.1f %.1f %.1f)->(%s %.1f %.1f %.1f)%s%s%s}", this.getClass().getSimpleName(), this.getId(), this.getApproximateFacingDirection(), this.level().dimension().location(), this.getX(), this.getY(), this.getZ(), this.dimensionTo.location(), this.getDestPos().x, this.getDestPos().y, this.getDestPos().z, this.specificPlayerId != null ? ",specificAccessor:" + this.specificPlayerId.toString() : "", this.hasScaling() ? ",scale:" + this.scaling : "", this.portalTag != null ? "," + this.portalTag : "");
    }

    public Direction getApproximateFacingDirection() {
        return Direction.getNearest((double)this.getNormal().x, (double)this.getNormal().y, (double)this.getNormal().z);
    }

    public Vec3 transformVelocityRelativeToPortal(Vec3 originalVelocityRelativeToPortal, Entity entity, Vec3 oldEntityPos) {
        Vec3 result = this.transformLocalVec(originalVelocityRelativeToPortal);
        int maxVelocity = 15;
        if (originalVelocityRelativeToPortal.length() > 15.0) {
            result = result.normalize().scale(15.0);
        }
        if (entity instanceof AbstractMinecart && result.lengthSqr() < 0.5) {
            result = result.scale(2.0);
        }
        return result;
    }

    public double getDistanceToPlane(Vec3 pos) {
        return pos.subtract(this.getOriginPos()).dot(this.getNormal());
    }

    public boolean isInFrontOfPortal(Vec3 pos) {
        return this.getDistanceToPlane(pos) > 0.0;
    }

    public Vec3 getPointInPlane(double xInPlane, double yInPlane) {
        return this.getOriginPos().add(this.getPointInPlaneLocal(xInPlane, yInPlane));
    }

    public Vec3 getPointInPlaneLocal(double xInPlane, double yInPlane) {
        return this.axisW.scale(xInPlane).add(this.axisH.scale(yInPlane));
    }

    public Vec3 getPointInPlaneLocalClamped(double xInPlane, double yInPlane) {
        return this.getPointInPlaneLocal(Mth.clamp((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0)), Mth.clamp((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0)));
    }

    public Vec3[] getFourVerticesLocal(double shrinkFactor) {
        Vec3[] vertices = new Vec3[]{this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, this.height / 2.0 - shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, this.height / 2.0 - shrinkFactor)};
        return vertices;
    }

    private Vec3[] getFourVerticesLocalRotated(double shrinkFactor) {
        Vec3[] fourVerticesLocal = this.getFourVerticesLocal(shrinkFactor);
        fourVerticesLocal[0] = this.transformLocalVec(fourVerticesLocal[0]);
        fourVerticesLocal[1] = this.transformLocalVec(fourVerticesLocal[1]);
        fourVerticesLocal[2] = this.transformLocalVec(fourVerticesLocal[2]);
        fourVerticesLocal[3] = this.transformLocalVec(fourVerticesLocal[3]);
        return fourVerticesLocal;
    }

    private Vec3[] getFourVerticesLocalCullable(double shrink) {
        double xStart = -this.width / 2.0;
        double xEnd = this.width / 2.0;
        double yStart = -this.height / 2.0;
        double yEnd = this.height / 2.0;
        Vec3[] vertices = new Vec3[]{this.getPointInPlaneLocal(xEnd - shrink, yStart + shrink), this.getPointInPlaneLocal(xStart + shrink, yStart + shrink), this.getPointInPlaneLocal(xEnd - shrink, yEnd - shrink), this.getPointInPlaneLocal(xStart + shrink, yEnd - shrink)};
        return vertices;
    }

    public final Vec3 transformPointRough(Vec3 pos) {
        Vec3 offset = this.getDestPos().subtract(this.getOriginPos());
        return pos.add(offset);
    }

    @Override
    public Vec3 transformLocalVecNonScale(Vec3 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        return this.rotation.rotate(localVec);
    }

    public Vec3 inverseTransformLocalVecNonScale(Vec3 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        return this.rotation.getConjugated().rotate(localVec);
    }

    @Override
    public Vec3 inverseTransformLocalVec(Vec3 localVec) {
        return this.inverseTransformLocalVecNonScale(localVec).scale(1.0 / this.scaling);
    }

    @Override
    public Vec3 inverseTransformPoint(Vec3 point) {
        return this.getOriginPos().add(this.inverseTransformLocalVec(point.subtract(this.getDestPos())));
    }

    public boolean isMovedThroughPortal(Vec3 lastTickPos, Vec3 pos) {
        return this.rayTrace(lastTickPos, pos) != null;
    }

    @Nullable
    public Vec3 rayTrace(Vec3 from, Vec3 to) {
        return this.lenientRayTrace(from, to, 0.001);
    }

    @Nullable
    public Vec3 lenientRayTrace(Vec3 from, Vec3 to, double leniency) {
        RayTraceResult rayTraceResult = this.getPortalShape().raytracePortalShape(this.getThisSideState(), from, to, leniency);
        if (rayTraceResult == null) {
            return null;
        }
        return rayTraceResult.hitPos();
    }

    @Nullable
    public RayTraceResult generalRayTrace(Vec3 from, Vec3 to, double leniency) {
        return this.getPortalShape().raytracePortalShape(this.getThisSideState(), from, to, leniency);
    }

    @Override
    public double getDistanceToNearestPointInPortal(Vec3 point) {
        return this.getPortalShape().roughDistanceToPortalShape(this.getThisSideState(), point);
    }

    public Vec3 getPointProjectedToPlane(Vec3 pos) {
        Vec3 originPos = this.getOriginPos();
        return this.getLocalVecProjectedToPlane(pos.subtract(originPos)).add(originPos);
    }

    public Vec3 getLocalVecProjectedToPlane(Vec3 offset) {
        double yInPlane = offset.dot(this.axisH);
        double xInPlane = offset.dot(this.axisW);
        return this.axisW.scale(xInPlane).add(this.axisH.scale(yInPlane));
    }

    public Vec3 getNearestPointInPortal(Vec3 pos) {
        Vec3 originPos = this.getOriginPos();
        Vec3 offset = pos.subtract(originPos);
        double yInPlane = offset.dot(this.axisH);
        double xInPlane = offset.dot(this.axisW);
        xInPlane = Mth.clamp((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0));
        yInPlane = Mth.clamp((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0));
        return originPos.add(this.axisW.scale(xInPlane)).add(this.axisH.scale(yInPlane));
    }

    public Level getDestinationWorld() {
        return this.getDestinationWorld(this.level().isClientSide());
    }

    private Level getDestinationWorld(boolean isClient) {
        if (isClient) {
            return CHelper.getClientWorld(this.dimensionTo);
        }
        MinecraftServer server = this.getServer();
        assert (server != null);
        return server.getLevel(this.dimensionTo);
    }

    public static boolean isParallelPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.dimensionTo == b.level().dimension() && a.level().dimension() == b.dimensionTo && a.getOriginPos().distanceTo(b.getDestPos()) < 0.1 && a.getDestPos().distanceTo(b.getOriginPos()) < 0.1 && a.getNormal().dot(b.getContentDirection()) < -0.9;
    }

    public static boolean isParallelOrientedPortal(Portal currPortal, Portal outerPortal) {
        double dot = currPortal.getOriginPos().subtract(outerPortal.getDestPos()).dot(outerPortal.getContentDirection());
        return currPortal.level().dimension() == outerPortal.dimensionTo && currPortal.getNormal().dot(outerPortal.getContentDirection()) < -0.9 && Math.abs(dot) < 0.001;
    }

    public static boolean isReversePortal(Portal a, Portal b) {
        return a.dimensionTo == b.level().dimension() && a.level().dimension() == b.dimensionTo && a.getOriginPos().distanceTo(b.getDestPos()) < 0.1 && a.getDestPos().distanceTo(b.getOriginPos()) < 0.1 && a.getNormal().dot(b.getContentDirection()) > 0.9;
    }

    public static boolean isFlippedPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.level() == b.level() && a.dimensionTo == b.dimensionTo && a.getOriginPos().distanceTo(b.getOriginPos()) < 0.1 && a.getDestPos().distanceTo(b.getDestPos()) < 0.1 && a.getNormal().dot(b.getNormal()) < -0.9;
    }

    @Override
    public double getDestAreaRadiusEstimation() {
        return Math.max(this.width, this.height) * this.scaling;
    }

    @Override
    public boolean isConventionalPortal() {
        return true;
    }

    @Override
    public AABB getThinBoundingBox() {
        if (this.thinBoundingBoxCache == null) {
            this.thinBoundingBoxCache = this.getPortalShape().getBoundingBox(this.getThisSideState(), false, 0.001);
        }
        return this.thinBoundingBoxCache;
    }

    @Override
    public boolean isRoughlyVisibleTo(Vec3 cameraPos) {
        return this.getPortalShape().roughTestVisibility(this.getThisSideState(), cameraPos, IrisInterface.invoker.isShaders());
    }

    @Override
    @Nullable
    public Plane getInnerClipping() {
        return this.getPortalShape().getInnerClipping(this.getThisSideState(), this.getOtherSideState(), this);
    }

    @Override
    @Nullable
    public Vec3[] getOuterFrustumCullingVertices() {
        return this.getFourVerticesLocalCullable(0.0);
    }

    public Matrix4d getFullSpaceTransformation() {
        Vec3 originPos = this.getOriginPos();
        Vec3 destPos = this.getDestPos();
        DQuaternion rot = this.getRotationD();
        return new Matrix4d().translation(destPos.x, destPos.y, destPos.z).scale(this.getScale()).rotate((Quaternionfc)rot.toMcQuaternion()).translate(-originPos.x, -originPos.y, -originPos.z);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getThickness() {
        return this.thickness;
    }

    public Vec3 getAxisW() {
        return this.axisW;
    }

    public void setAxisW(Vec3 axisW) {
        this.axisW = axisW;
        this.updateCache();
    }

    public Vec3 getAxisH() {
        return this.axisH;
    }

    public void setAxisH(Vec3 axisH) {
        this.axisH = axisH;
        this.updateCache();
    }

    public void setDestDim(ResourceKey<Level> dimensionTo) {
        this.dimensionTo = dimensionTo;
    }

    public Vec3 getDestination() {
        return this.destination;
    }

    public double getScaling() {
        return this.scaling;
    }

    public void setScaling(double scaling) {
        this.scaling = scaling;
        this.updateCache();
    }

    public boolean isTeleportChangesScale() {
        return this.teleportChangesScale;
    }

    public void setFuseView(boolean fuseView) {
        this.fuseView = fuseView;
    }

    public boolean isCrossPortalCollisionEnabled() {
        return this.crossPortalCollisionEnabled;
    }

    public void setCrossPortalCollisionEnabled(boolean crossPortalCollisionEnabled) {
        this.crossPortalCollisionEnabled = crossPortalCollisionEnabled;
    }

    public boolean isDoRenderPlayer() {
        return this.doRenderPlayer;
    }

    public void setDoRenderPlayer(boolean doRenderPlayer) {
        this.doRenderPlayer = doRenderPlayer;
    }

    @Nullable
    public List<String> getCommandsOnTeleported() {
        return this.commandsOnTeleported;
    }

    public void setCommandsOnTeleported(@Nullable List<String> commandsOnTeleported) {
        this.commandsOnTeleported = commandsOnTeleported;
    }

    public TransformationDesc getTransformationDesc() {
        return new TransformationDesc(this.getDestDim(), this.getFullSpaceTransformation(), this.getRotationD(), this.getScale());
    }

    @Override
    public boolean cannotRenderInMe(Portal portal) {
        if (this.respectParallelOrientedPortal()) {
            return Portal.isParallelPortal(portal, this);
        }
        return Portal.isParallelOrientedPortal(portal, this);
    }

    public void myUnsetRemoved() {
        this.unsetRemoved();
    }

    public void refreshDimensions() {
        this.boundingBoxCache = null;
    }

    @Override
    @Nullable
    public Matrix4f getAdditionalCameraTransformation() {
        return PortalRenderer.getPortalTransformation(this);
    }

    public boolean canDoOuterFrustumCulling() {
        if (this.isFuseView()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.getPortalShape().canDoOuterFrustumCulling();
    }

    public boolean isTeleportable() {
        return this.teleportable;
    }

    public boolean respectParallelOrientedPortal() {
        return false;
    }

    public void onCollidingWithEntity(Entity entity) {
    }

    @Override
    public boolean getHasCrossPortalCollision() {
        return this.crossPortalCollisionEnabled;
    }

    public boolean getTeleportChangesScale() {
        return this.teleportChangesScale;
    }

    public void setTeleportChangesScale(boolean teleportChangesScale) {
        this.teleportChangesScale = teleportChangesScale;
    }

    public boolean getTeleportChangesGravity() {
        return this.teleportChangesGravity;
    }

    public boolean isTeleportChangesGravity() {
        return this.teleportChangesGravity;
    }

    public void setTeleportChangesGravity(boolean cond) {
        this.teleportChangesGravity = cond;
    }

    public Direction getTeleportedGravityDirection(Direction oldGravityDir) {
        if (!this.getTeleportChangesGravity()) {
            return oldGravityDir;
        }
        return this.getTransformedGravityDirection(oldGravityDir);
    }

    public Direction getTransformedGravityDirection(Direction oldGravityDir) {
        Vec3 oldGravityVec = Vec3.atLowerCornerOf((Vec3i)oldGravityDir.getNormal());
        Vec3 newGravityVec = this.transformLocalVecNonScale(oldGravityVec);
        return Direction.getNearest((double)newGravityVec.x, (double)newGravityVec.y, (double)newGravityVec.z);
    }

    @NotNull
    public PortalState getPortalState() {
        Validate.isTrue((this.axisH != null ? 1 : 0) != 0, (String)"the portal is not yet initialized", (Object[])new Object[0]);
        return new PortalState((ResourceKey<Level>)this.level().dimension(), this.getOriginPos(), this.dimensionTo, this.getDestPos(), this.getScale(), this.getRotationD(), this.getOrientationRotation(), this.width, this.height, this.thickness, this instanceof Mirror);
    }

    public void setPortalState(PortalState state) {
        Validate.isTrue((this.level().dimension() == state.fromWorld ? 1 : 0) != 0);
        Validate.isTrue((this.dimensionTo == state.toWorld ? 1 : 0) != 0);
        this.width = state.width;
        this.height = state.height;
        this.thickness = state.thickness;
        this.setOriginPos(state.fromPos);
        this.setDestination(state.toPos);
        PortalManipulation.setPortalOrientationQuaternion(this, state.orientation);
        if (DQuaternion.isClose(state.rotation, DQuaternion.identity)) {
            this.setRotationTransformationD(null);
        } else {
            this.setRotationTransformationD(state.rotation);
        }
        this.setScaleTransformation(state.scaling);
    }

    public UnilateralPortalState getThisSideState() {
        if (this.thisSideStateCache == null) {
            this.thisSideStateCache = new UnilateralPortalState((ResourceKey<Level>)this.getOriginDim(), this.getOriginPos(), this.getOrientationRotation(), this.width, this.height, this.thickness);
        }
        return this.thisSideStateCache;
    }

    public UnilateralPortalState getOtherSideState() {
        if (this.otherSideStateCache == null) {
            PortalState portalState = this.getPortalState();
            this.otherSideStateCache = UnilateralPortalState.extractOtherSide(portalState);
        }
        return this.otherSideStateCache;
    }

    public void setThisSideState(UnilateralPortalState ups) {
        this.setThisSideState(ups, false);
    }

    public void setThisSideState(UnilateralPortalState ups, boolean lockScale) {
        Validate.notNull((Object)ups);
        PortalState portalState = this.getPortalState();
        PortalState newPortalState = portalState.withThisSideUpdated(ups, lockScale);
        this.setPortalState(newPortalState);
    }

    public void acceptDataSync(Vec3 pos, CompoundTag customData) {
        PortalState oldState;
        try {
            oldState = this.getPortalState();
        }
        catch (Exception ignored) {
            oldState = null;
        }
        this.setPos(pos);
        this.readAdditionalSaveData(customData);
        if (this.animation.defaultAnimation.durationTicks > 0 && oldState != null) {
            this.animation.defaultAnimation.startClientDefaultAnimation(this, oldState);
        }
        NeoForge.EVENT_BUS.post((Event)new ClientPortalAcceptSyncEvent(this));
    }

    public CompoundTag writePortalDataToNbt() {
        CompoundTag nbtCompound = new CompoundTag();
        this.addAdditionalSaveData(nbtCompound);
        return nbtCompound;
    }

    public void readPortalDataFromNbt(CompoundTag compound) {
        block2: {
            try {
                this.readAdditionalSaveData(compound);
            }
            catch (Exception e) {
                LOGGER.error("Failed to read portal data from nbt {}", (Object)compound, (Object)e);
                if (this.isPortalValid()) break block2;
                this.setRemoved(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void updatePortalFromNbt(CompoundTag newNbt) {
        CompoundTag data = this.writePortalDataToNbt();
        newNbt.getAllKeys().forEach(key -> data.put(key, newNbt.get(key)));
        this.readPortalDataFromNbt(data);
    }

    public void rectifyClusterPortals(boolean sync) {
        PortalExtension.get(this).rectifyClusterPortals(this, sync);
    }

    public void reloadPortal() {
        Validate.isTrue((!this.level().isClientSide() ? 1 : 0) != 0);
        this.updateCache();
        this.rectifyClusterPortals(true);
        this.reloadAndSyncToClientNextTick();
    }

    public DefaultPortalAnimation getDefaultAnimation() {
        return this.animation.defaultAnimation;
    }

    public void clearAnimationDrivers(boolean clearThisSide, boolean clearOtherSide) {
        this.animation.clearAnimationDrivers(this, clearThisSide, clearOtherSide);
    }

    public void addThisSideAnimationDriver(PortalAnimationDriver driver) {
        this.getAnimationView().addThisSideAnimation(driver);
        this.reloadAndSyncClusterToClientNextTick();
    }

    public void addOtherSideAnimationDriver(PortalAnimationDriver driver) {
        this.getAnimationView().addOtherSideAnimation(driver);
        this.reloadAndSyncClusterToClientNextTick();
    }

    public void pauseAnimation() {
        this.animation.setPaused(this, true);
    }

    public void resumeAnimation() {
        this.animation.setPaused(this, false);
    }

    public void resetAnimationReferenceState(boolean resetThisSide, boolean resetOtherSide) {
        this.animation.resetReferenceState(this, resetThisSide, resetOtherSide);
    }

    public AnimationView getAnimationView() {
        PortalExtension extension = PortalExtension.get(this);
        if (extension.flippedPortal != null && extension.flippedPortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.flippedPortal, IntraClusterRelation.FLIPPED);
        }
        if (extension.reversePortal != null && extension.reversePortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.reversePortal, IntraClusterRelation.REVERSE);
        }
        if (extension.parallelPortal != null && extension.parallelPortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.parallelPortal, IntraClusterRelation.PARALLEL);
        }
        return new AnimationView(this, this, IntraClusterRelation.SAME);
    }

    public boolean isOtherSideChunkLoaded() {
        Validate.isTrue((!this.level().isClientSide() ? 1 : 0) != 0);
        return McHelper.isServerChunkFullyLoaded((ServerLevel)this.getDestWorld(), new ChunkPos(BlockPos.containing((Position)this.getDestPos())));
    }

    @Nullable
    public PortalState getLastTickPortalState() {
        if (this.lastTickPortalState == null) {
            return this.getThisTickPortalState();
        }
        return this.lastTickPortalState;
    }

    @Nullable
    public PortalState getThisTickPortalState() {
        if (this.portalStateCache == null) {
            this.portalStateCache = this.getPortalState();
        }
        return this.portalStateCache;
    }

    public PortalState getAnimationEndingState() {
        return this.animation.getAnimationEndingState(this);
    }

    public Vec3 transformFromPortalLocalToWorld(Vec3 localPos) {
        return this.axisW.scale(localPos.x).add(this.axisH.scale(localPos.y)).add(this.getNormal().scale(localPos.z)).add(this.getOriginPos());
    }

    public Vec3 transformFromWorldToPortalLocal(Vec3 worldPos) {
        Vec3 relativePos = worldPos.subtract(this.getOriginPos());
        return new Vec3(relativePos.dot(this.axisW), relativePos.dot(this.axisH), relativePos.dot(this.getNormal()));
    }

    @Nullable
    public Portal getAnimationHolder() {
        if (this.animation.hasAnimationDriver()) {
            return this;
        }
        PortalExtension portalExtension = PortalExtension.get(this);
        if (portalExtension.flippedPortal != null && portalExtension.flippedPortal.animation.hasAnimationDriver()) {
            return portalExtension.flippedPortal;
        }
        if (portalExtension.reversePortal != null && portalExtension.reversePortal.animation.hasAnimationDriver()) {
            return portalExtension.reversePortal;
        }
        if (portalExtension.parallelPortal != null && portalExtension.parallelPortal.animation.hasAnimationDriver()) {
            return portalExtension.parallelPortal;
        }
        return null;
    }

    public Portal getPossibleAnimationHolder() {
        Portal holder = this.getAnimationHolder();
        if (holder != null) {
            return holder;
        }
        return this;
    }

    public long getAnimationEffectiveTime() {
        Portal holder = this.getPossibleAnimationHolder();
        return holder.animation.getEffectiveTime(holder.level().getGameTime());
    }

    public void disableDefaultAnimation() {
        this.animation.defaultAnimation.durationTicks = 0;
        this.reloadAndSyncToClientNextTick();
    }

    public VoxelShape getThisSideCollisionExclusion() {
        if (this.thisSideCollisionExclusion == null) {
            this.thisSideCollisionExclusion = this.getPortalShape().getThisSideCollisionExclusion(this.getThisSideState());
        }
        return this.thisSideCollisionExclusion;
    }

    public record TransformationDesc(ResourceKey<Level> dimensionTo, Matrix4d fullSpaceTransformation, DQuaternion rotation, double scaling) {
        public static boolean isRoughlyEqual(TransformationDesc a, TransformationDesc b) {
            if (a.dimensionTo != b.dimensionTo) {
                return false;
            }
            Matrix4d diff = new Matrix4d().set((Matrix4dc)a.fullSpaceTransformation).sub((Matrix4dc)b.fullSpaceTransformation);
            double diffSquareSum = diff.m00() * diff.m00() + diff.m01() * diff.m01() + diff.m02() * diff.m02() + diff.m03() * diff.m03() + diff.m10() * diff.m10() + diff.m11() * diff.m11() + diff.m12() * diff.m12() + diff.m13() * diff.m13() + diff.m20() * diff.m20() + diff.m21() * diff.m21() + diff.m22() * diff.m22() + diff.m23() * diff.m23() + diff.m30() * diff.m30() + diff.m31() * diff.m31() + diff.m32() * diff.m32() + diff.m33() * diff.m33();
            return diffSquareSum < 0.1;
        }
    }

    public static class ClientPortalAcceptSyncEvent
    extends Event {
        public final Portal portal;

        public ClientPortalAcceptSyncEvent(Portal portal) {
            this.portal = portal;
        }
    }
}

