/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import qouteall.q_misc_util.my_util.IntBox;

public class LoadingIndicatorEntity
extends Entity {
    public static final EntityType<LoadingIndicatorEntity> entityType = LoadingIndicatorEntity.getEntityType();
    private static final EntityDataAccessor<Component> TEXT = SynchedEntityData.defineId(LoadingIndicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPONENT);
    private static final EntityDataAccessor<BlockPos> BOX_LOW_POS = SynchedEntityData.defineId(LoadingIndicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockPos> BOX_HIGH_POS = SynchedEntityData.defineId(LoadingIndicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public boolean isValid = false;

    static EntityType<LoadingIndicatorEntity> getEntityType() {
        EntityType.Builder builder = EntityType.Builder.of(LoadingIndicatorEntity::new, (MobCategory)MobCategory.MISC).fireImmune().clientTrackingRange(96).updateInterval(20);
        builder.dimensions = EntityDimensions.fixed((float)1.0f, (float)1.0f);
        return builder.build("");
    }

    public LoadingIndicatorEntity(EntityType type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.tickClient();
        } else if (!this.isValid) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private void tickClient() {
        LocalPlayer player;
        this.addParticles();
        if (this.tickCount > 40 && (player = Minecraft.getInstance().player) != null && player.level() == this.level() && player.position().distanceToSqr(this.position()) < 256.0) {
            this.showMessageClient();
        }
    }

    private void addParticles() {
        int num = this.tickCount < 100 ? 50 : 20;
        IntBox box = this.getBox();
        BlockPos size = box.getSize();
        RandomSource random = this.level().getRandom();
        for (int i = 0; i < num; ++i) {
            Vec3 p = new Vec3(random.nextDouble(), random.nextDouble(), random.nextDouble()).multiply(Vec3.atLowerCornerOf((Vec3i)size)).add(Vec3.atLowerCornerOf((Vec3i)box.l));
            double speedMultiplier = 20.0;
            double vx = speedMultiplier * ((double)random.nextFloat() - 0.5) * 0.5;
            double vy = speedMultiplier * ((double)random.nextFloat() - 0.5) * 0.5;
            double vz = speedMultiplier * ((double)random.nextFloat() - 0.5) * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, p.x, p.y, p.z, vx, vy, vz);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TEXT, (Object)Component.literal((String)"Loading..."));
        builder.define(BOX_LOW_POS, (Object)BlockPos.ZERO);
        builder.define(BOX_HIGH_POS, (Object)BlockPos.ZERO);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    public void inform(Component str) {
        this.setText(str);
    }

    public void setText(Component str) {
        this.getEntityData().set(TEXT, (Object)str);
    }

    public Component getText() {
        return (Component)this.getEntityData().get(TEXT);
    }

    public void setBox(IntBox box) {
        this.getEntityData().set(BOX_LOW_POS, (Object)box.l);
        this.getEntityData().set(BOX_HIGH_POS, (Object)box.h);
    }

    public IntBox getBox() {
        return new IntBox((BlockPos)this.getEntityData().get(BOX_LOW_POS), (BlockPos)this.getEntityData().get(BOX_HIGH_POS));
    }

    private void showMessageClient() {
        Gui inGameHud = Minecraft.getInstance().gui;
        inGameHud.setOverlayMessage(this.getText(), false);
    }
}

