/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.mixin.common.miscellaneous.IEEndDragonFight;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.NormalAnimation;
import qouteall.imm_ptl.core.portal.animation.RotationAnimation;
import qouteall.imm_ptl.core.portal.shape.BoxPortalShape;
import qouteall.q_misc_util.Helper;

public class EndPortalEntity
extends Portal {
    private static final Logger LOGGER = LogManager.getLogger(EndPortalEntity.class);
    public static final EntityType<EndPortalEntity> ENTITY_TYPE = EndPortalEntity.createPortalEntityType(EndPortalEntity::new);
    public static final String PORTAL_TAG_VIEW_BOX = "view_box";
    private static final double BOX_PORTAL_SIDE_LEN = 3.0;
    private static final double BOX_PORTAL_HEIGHT = 1.5;

    public EndPortalEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
        this.setCrossPortalCollisionEnabled(false);
    }

    public static void onEndPortalComplete(ServerLevel world, Vec3 portalCenter) {
        ServerLevel endDim = world.getServer().getLevel(Level.END);
        if (endDim == null) {
            return;
        }
        IPGlobal.EndPortalMode endPortalMode = IPGlobal.endPortalMode;
        if (endPortalMode == IPGlobal.EndPortalMode.normal) {
            EndPortalEntity.generateClassicalEndPortal(world, new Vec3(0.0, 120.0, 0.0), portalCenter);
        } else if (endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            BlockPos endSpawnPos = ServerLevel.END_SPAWN_POINT;
            EndPortalEntity.generateClassicalEndPortal(world, Vec3.atCenterOf((Vec3i)endSpawnPos).add(0.0, 1.0, 0.0), portalCenter);
        } else if (endPortalMode == IPGlobal.EndPortalMode.scaledView) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter, false);
        } else if (endPortalMode == IPGlobal.EndPortalMode.scaledViewRotating) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter, true);
        } else {
            LOGGER.error("End portal mode abnormal");
        }
        EndPortalEntity.doCreateEndPlatform(world);
        EndDragonFight dragonFight = world.getDragonFight();
        if (dragonFight == null) {
            return;
        }
        if (((IEEndDragonFight)dragonFight).ip_getNeedsStateScanning()) {
            ((IEEndDragonFight)dragonFight).ip_scanState();
        }
    }

    private static void doCreateEndPlatform(ServerLevel world) {
        EndPlatformFeature.createEndPlatform((ServerLevelAccessor)world, (BlockPos)BlockPos.containing((Position)ServerLevel.END_SPAWN_POINT.getBottomCenter()).below(), (boolean)true);
    }

    private static void generateClassicalEndPortal(ServerLevel world, Vec3 destination, Vec3 portalCenter) {
        EndPortalEntity portal = new EndPortalEntity(ENTITY_TYPE, (Level)world);
        portal.setPos(portalCenter.x, portalCenter.y, portalCenter.z);
        portal.setDestination(destination);
        portal.setDestDim((ResourceKey<Level>)Level.END);
        portal.setAxisW(new Vec3(0.0, 0.0, 1.0));
        portal.setAxisH(new Vec3(1.0, 0.0, 0.0));
        portal.setWidth(3.0);
        portal.setHeight(3.0);
        world.addFreshEntity((Entity)portal);
    }

    private static void generateScaledViewEndPortal(ServerLevel world, Vec3 frameCenter, boolean hasAnimation) {
        ServerLevel endWorld = world.getServer().getLevel(Level.END);
        Validate.notNull((Object)endWorld, (String)"End dimension is not loaded", (Object[])new Object[0]);
        double sideLen = 3.0;
        double otherSideSideLen = 288.0;
        double height = 1.5;
        Vec3 viewBoxSize = new Vec3(sideLen, height, sideLen);
        double scale = otherSideSideLen / sideLen;
        AABB thisSideBox = Helper.getBoxByBottomPosAndSize(frameCenter.add(0.0, 0.2, 0.0), viewBoxSize);
        AABB otherSideBox = Helper.getBoxByBottomPosAndSize(new Vec3(0.0, 0.0, 0.0), viewBoxSize.scale(scale));
        Vec3 portalCenter = thisSideBox.getCenter();
        EndPortalEntity portal = (EndPortalEntity)ENTITY_TYPE.create((Level)world);
        assert (portal != null);
        portal.setOriginPos(portalCenter);
        portal.setDestDim((ResourceKey<Level>)endWorld.dimension());
        portal.setDestination(otherSideBox.getCenter());
        portal.setAxisW(new Vec3(1.0, 0.0, 0.0));
        portal.setAxisH(new Vec3(0.0, 1.0, 0.0));
        portal.setWidth(sideLen);
        portal.setHeight(height);
        portal.setThickness(sideLen);
        portal.setPortalShape(BoxPortalShape.FACING_OUTWARDS);
        portal.setScaling(scale);
        portal.setTeleportChangesScale(false);
        portal.portalTag = PORTAL_TAG_VIEW_BOX;
        portal.setInteractable(false);
        portal.setCrossPortalCollisionEnabled(false);
        portal.setFuseView(true);
        if (hasAnimation) {
            Vec3 rotationCenter = portalCenter;
            portal.addThisSideAnimationDriver(new RotationAnimation.Builder().setDegreesPerTick(0.5).setInitialOffset(Vec3.ZERO).setRotationAxis(new Vec3(0.0, 1.0, 0.0)).setStartGameTime(world.getGameTime()).setEndGameTime(Long.MAX_VALUE).build());
            portal.addThisSideAnimationDriver(NormalAnimation.createOscillationAnimation(new Vec3(0.0, 0.3, 0.0), 100, world.getGameTime()));
        }
        McHelper.spawnServerEntity(portal);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.tickClient();
        }
    }

    private void tickClient() {
        if (this.isViewBoxPortal()) {
            Vec3 cameraPosVec;
            double dist;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            if (this.getPortalShape() instanceof BoxPortalShape) {
                Vec3 cameraPosVec2 = player.getEyePosition(1.0f);
                double dist2 = this.getDistanceToNearestPointInPortal(cameraPosVec2);
                if (dist2 < 1.0 && this.isInBoxPortalTeleportataionRange(cameraPosVec2)) {
                    double mul = 0.5;
                    player.setDeltaMovement(player.getDeltaMovement().x * mul, player.getDeltaMovement().y * mul, player.getDeltaMovement().z * mul);
                }
            } else if (this.getNormal().y > 0.5 && ((IEEntity)player).ip_getCollidingPortal() == this && (dist = this.getDistanceToNearestPointInPortal(cameraPosVec = player.getEyePosition(1.0f))) < 1.0) {
                double mul = dist / 2.0 + 0.1;
                player.setDeltaMovement(player.getDeltaMovement().x * mul, player.getDeltaMovement().y * mul, player.getDeltaMovement().z * mul);
            }
            this.setFuseView(true);
        }
    }

    @Override
    public void onEntityTeleportedOnServer(Entity entity) {
        super.onEntityTeleportedOnServer(entity);
        if (this.shouldAddSlowFalling(entity)) {
            int duration = 200;
            if (this.isViewBoxPortal()) {
                duration = 400;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, duration, 1));
        }
        MinecraftServer server = this.getServer();
        assert (server != null);
        ServerLevel endWorld = server.getLevel(Level.END);
        if (endWorld != null) {
            EndPortalEntity.doCreateEndPlatform(endWorld);
        }
    }

    private boolean isViewBoxPortal() {
        return Objects.equals(this.portalTag, PORTAL_TAG_VIEW_BOX);
    }

    @Override
    public Vec3 transformVelocityRelativeToPortal(Vec3 originalVelocityRelativeToPortal, Entity entity, Vec3 oldEntityPos) {
        if (this.isViewBoxPortal()) {
            Vec3 offset = oldEntityPos.subtract(this.getOriginPos());
            double horizontalDistanceSq = offset.x * offset.x + offset.z * offset.z;
            double threshold = 1.0;
            if (horizontalDistanceSq > threshold * threshold) {
                return Vec3.ZERO;
            }
        }
        return super.transformVelocityRelativeToPortal(originalVelocityRelativeToPortal, entity, oldEntityPos);
    }

    @Override
    public boolean canTeleportEntity(Entity entity) {
        if (entity instanceof Arrow) {
            return false;
        }
        if (this.getPortalShape() instanceof BoxPortalShape && !this.isInBoxPortalTeleportataionRange(entity.getEyePosition(1.0f))) {
            return false;
        }
        return super.canTeleportEntity(entity);
    }

    private boolean shouldAddSlowFalling(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.gameMode.getGameModeForPlayer() == GameType.CREATIVE) {
                    return false;
                }
                return player.getItemBySlot(EquipmentSlot.CHEST).getItem() != Items.ELYTRA;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLimitBoundingBox() {
        return false;
    }

    @Override
    public void onCollidingWithEntity(Entity entity) {
        if (!this.level().isClientSide() && entity instanceof ServerPlayer && IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            MinecraftServer server = this.getServer();
            assert (server != null);
            ServerLevel endWorld = server.getLevel(Level.END);
            if (endWorld != null) {
                EndPortalEntity.doCreateEndPlatform(endWorld);
            }
        }
    }

    public boolean isInBoxPortalTeleportataionRange(Vec3 pos) {
        Vec3 offset = pos.subtract(this.getOriginPos());
        double horizontalDistanceSq = offset.x * offset.x + offset.z * offset.z;
        double threshold = 1.5;
        return horizontalDistanceSq <= threshold * threshold;
    }
}

