/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Mesh2D;

public class BreakableMirror
extends Mirror {
    public static final EntityType<BreakableMirror> ENTITY_TYPE = BreakableMirror.createPortalEntityType(BreakableMirror::new);
    @Nullable
    public IntBox wallArea;
    @Nullable
    public BlockPortalShape blockPortalShape;
    public boolean unbreakable = false;

    public BreakableMirror(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.wallArea = tag.contains("boxXL") ? new IntBox(new BlockPos(tag.getInt("boxXL"), tag.getInt("boxYL"), tag.getInt("boxZL")), new BlockPos(tag.getInt("boxXH"), tag.getInt("boxYH"), tag.getInt("boxZH"))) : null;
        this.blockPortalShape = tag.contains("blockPortalShape") ? BlockPortalShape.fromTag(tag.getCompound("blockPortalShape")) : null;
        if (tag.contains("unbreakable")) {
            this.unbreakable = tag.getBoolean("unbreakable");
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.wallArea != null) {
            tag.putInt("boxXL", this.wallArea.l.getX());
            tag.putInt("boxYL", this.wallArea.l.getY());
            tag.putInt("boxZL", this.wallArea.l.getZ());
            tag.putInt("boxXH", this.wallArea.h.getX());
            tag.putInt("boxYH", this.wallArea.h.getY());
            tag.putInt("boxZH", this.wallArea.h.getZ());
        }
        if (this.blockPortalShape != null) {
            tag.put("blockPortalShape", (Tag)this.blockPortalShape.toTag());
        }
        tag.putBoolean("unbreakable", this.unbreakable);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.unbreakable && this.level().getGameTime() % 10L == (long)(this.getId() % 10)) {
            this.checkWallIntegrity();
        }
    }

    @Override
    public boolean isPortalValid() {
        return super.isPortalValid() && (this.wallArea != null || this.blockPortalShape != null);
    }

    private void checkWallIntegrity() {
        boolean wallValid = this.wallArea != null ? this.wallArea.fastStream().allMatch(blockPos -> BreakableMirror.isGlass(this.level(), blockPos)) : (this.blockPortalShape != null ? this.blockPortalShape.area.stream().allMatch(blockPos -> BreakableMirror.isGlass(this.level(), blockPos)) : false);
        if (!wallValid) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public static boolean isGlass(Level world, BlockPos blockPos) {
        Block block = world.getBlockState(blockPos).getBlock();
        return block == Blocks.GLASS || block == Blocks.GLASS_PANE || block instanceof StainedGlassBlock || block instanceof StainedGlassPaneBlock;
    }

    private static boolean isGlassPane(Level world, BlockPos blockPos) {
        Block block = world.getBlockState(blockPos).getBlock();
        return block == Blocks.GLASS_PANE || block instanceof StainedGlassPaneBlock;
    }

    public static BreakableMirror createMirror(ServerLevel world, BlockPos glassPos, Direction facing) {
        if (!BreakableMirror.isGlass((Level)world, glassPos)) {
            return null;
        }
        boolean isPane = BreakableMirror.isGlassPane((Level)world, glassPos);
        if (facing.getAxis() == Direction.Axis.Y && isPane) {
            return null;
        }
        Predicate<BlockPos> glassWallPredicate = blockPos -> BreakableMirror.isGlass((Level)world, blockPos) && isPane == BreakableMirror.isGlassPane((Level)world, blockPos) && world.getBlockState(blockPos.relative(facing)).isAir();
        BlockPortalShape shape = BlockPortalShape.findArea(glassPos, facing.getAxis(), glassWallPredicate, blockPos -> !glassWallPredicate.test((BlockPos)blockPos));
        if (shape == null) {
            return null;
        }
        BreakableMirror breakableMirror = (BreakableMirror)ENTITY_TYPE.create((Level)world);
        assert (breakableMirror != null);
        double distanceToCenter = isPane ? 0.0625 : 0.5;
        breakableMirror.blockPortalShape = shape;
        AABB wallBox = McHelper.getWallBox((Level)world, shape.area.stream());
        if (wallBox == null) {
            return null;
        }
        Vec3 pos = Helper.getBoxSurfaceInversed(wallBox, facing.getOpposite()).getCenter();
        pos = Helper.putCoordinate(pos, facing.getAxis(), Helper.getCoordinate(shape.innerAreaBox.getCenterVec().add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(distanceToCenter)), facing.getAxis()));
        breakableMirror.setPos(pos.x, pos.y, pos.z);
        breakableMirror.setDestination(pos);
        breakableMirror.setDestDim((ResourceKey<Level>)world.dimension());
        Tuple<Direction, Direction> perpendicularDirections = Helper.getPerpendicularDirections(facing);
        Direction wDirection = (Direction)perpendicularDirections.getA();
        Direction hDirection = (Direction)perpendicularDirections.getB();
        breakableMirror.setWidth(Helper.getCoordinate(Helper.getBoxSize(wallBox), wDirection.getAxis()));
        breakableMirror.setHeight(Helper.getCoordinate(Helper.getBoxSize(wallBox), hDirection.getAxis()));
        breakableMirror.setAxisW(Vec3.atLowerCornerOf((Vec3i)wDirection.getNormal()));
        breakableMirror.setAxisH(Vec3.atLowerCornerOf((Vec3i)hDirection.getNormal()));
        BreakableMirror.initializeMirrorGeometryShape(breakableMirror, facing, shape);
        BreakableMirror.breakIntersectedMirror(breakableMirror);
        world.addFreshEntity((Entity)breakableMirror);
        return breakableMirror;
    }

    private static void initializeMirrorGeometryShape(BreakableMirror breakableMirror, Direction facing, BlockPortalShape shape) {
        if (shape.isRectangle()) {
            breakableMirror.setPortalShapeToDefault();
            return;
        }
        Vec3 center = breakableMirror.getOriginPos();
        Level world = breakableMirror.level();
        Vec3 axisW = breakableMirror.getAxisW();
        Vec3 axisH = breakableMirror.getAxisH();
        Mesh2D mesh2D = new Mesh2D();
        for (BlockPos blockPos : shape.area) {
            VoxelShape collisionShape = world.getBlockState(blockPos).getCollisionShape((BlockGetter)world, blockPos);
            if (collisionShape.isEmpty()) continue;
            AABB bounds = collisionShape.bounds().move(Vec3.atLowerCornerOf((Vec3i)blockPos));
            Vec3 p1 = new Vec3(bounds.minX, bounds.minY, bounds.minZ);
            Vec3 p2 = new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ);
            double p1LocalX = p1.subtract(center).dot(axisW);
            double p1LocalY = p1.subtract(center).dot(axisH);
            double p2LocalX = p2.subtract(center).dot(axisW);
            double p2LocalY = p2.subtract(center).dot(axisH);
            mesh2D.addQuad(p1LocalX, p1LocalY, p2LocalX, p2LocalY);
        }
        breakableMirror.setPortalShape(new SpecialFlatPortalShape(mesh2D));
    }

    public IntBox getAreaBox() {
        if (this.wallArea != null) {
            return this.wallArea;
        }
        if (this.blockPortalShape != null) {
            return this.blockPortalShape.innerAreaBox;
        }
        throw new RuntimeException();
    }

    private static void breakIntersectedMirror(BreakableMirror newMirror) {
        McHelper.getEntitiesNearby(newMirror, BreakableMirror.class, IPGlobal.maxNormalPortalRadius).stream().filter(mirror1 -> mirror1.getNormal().dot(newMirror.getNormal()) > 0.5).filter(mirror1 -> IntBox.getIntersect(mirror1.getAreaBox(), newMirror.getAreaBox()) != null).filter(mirror -> mirror != newMirror).forEach(e -> e.remove(Entity.RemovalReason.KILLED));
    }
}

