/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific.mixin.common;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.DimensionTransition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGenManager;

@Mixin(value={ServerPlayer.class})
public class MixinServerPlayerEntity_MA {
    @Inject(method={"changeDimension"}, at={@At(value="HEAD")})
    private void onChangeDimensionByVanilla(DimensionTransition dimensionTransition, CallbackInfoReturnable<Entity> cir) {
        ServerPlayer this_ = (ServerPlayer)this;
        MixinServerPlayerEntity_MA.onBeforeDimensionTravel(this_);
    }

    @Inject(method={"Lnet/minecraft/server/level/ServerPlayer;teleportTo(Lnet/minecraft/server/level/ServerLevel;DDDFF)V"}, at={@At(value="HEAD")})
    private void onTeleported(ServerLevel targetWorld, double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        ServerPlayer this_ = (ServerPlayer)this;
        if (this_.level() != targetWorld) {
            MixinServerPlayerEntity_MA.onBeforeDimensionTravel(this_);
        }
    }

    private static void onBeforeDimensionTravel(ServerPlayer player) {
        CustomPortalGenManager customPortalGenManager = IPPerServerInfo.of((MinecraftServer)player.server).customPortalGenManager;
        if (customPortalGenManager != null) {
            customPortalGenManager.onBeforeConventionalDimensionChange(player);
            ImmPtlChunkTracking.removePlayerFromChunkTrackersAndEntityTrackers(player);
            ServerTaskList.of(player.server).addTask(() -> {
                customPortalGenManager.onAfterConventionalDimensionChange(player);
                return true;
            });
        }
    }
}

