/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.lang.reflect.Method;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.Helper;

public class RequiemCompat {
    static boolean isRequiemPresent = false;
    private static Class class_RequiemPlayer;
    private static Class class_PossessionComponent;
    private static Method method_asPossessor;
    private static Method method_getPossessedEntity;

    public static boolean getIsRequiemPresent() {
        return isRequiemPresent;
    }

    public static void init() {
        isRequiemPresent = ModList.get().isLoaded("requiem");
        if (!isRequiemPresent) {
            return;
        }
        class_RequiemPlayer = Helper.noError(() -> Class.forName("ladysnake.requiem.api.v1.RequiemPlayer"));
        class_PossessionComponent = Helper.noError(() -> Class.forName("ladysnake.requiem.api.v1.possession.PossessionComponent"));
        method_asPossessor = Helper.noError(() -> class_RequiemPlayer.getDeclaredMethod("asPossessor", new Class[0]));
        method_getPossessedEntity = Helper.noError(() -> class_PossessionComponent.getDeclaredMethod("getPossessedEntity", new Class[0]));
    }

    public static Mob getPossessedEntity(Player player) {
        Validate.isTrue((boolean)isRequiemPresent);
        Object possessionComponent = Helper.noError(() -> method_asPossessor.invoke((Object)player, new Object[0]));
        Object possessedEntity = Helper.noError(() -> method_getPossessedEntity.invoke(possessionComponent, new Object[0]));
        return (Mob)possessedEntity;
    }

    public static void onPlayerTeleportedServer(ServerPlayer player) {
        if (!isRequiemPresent) {
            return;
        }
        Mob possessedEntity = RequiemCompat.getPossessedEntity((Player)player);
        if (possessedEntity != null && possessedEntity.level() != player.level()) {
            Helper.log("Move Requiem Posessed Entity at Server");
            ServerTeleportationManager.of(player.server).changeEntityDimension((Entity)possessedEntity, (ResourceKey<Level>)player.level().dimension(), McHelper.getEyePos((Entity)player), false);
        }
    }
}

